/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class BmpWriter {
    private static final int pbfType = 0;
    private static final int pbfSize = 2;
    private static final int pbfOffBits = 10;
    private static final int bf_size = 14;
    private static final int pbiSize = 0;
    private static final int pbiWidth = 4;
    private static final int pbiHeight = 8;
    private static final int pbiPlanes = 12;
    private static final int pbiBitCount = 14;
    private static final int pbiSizeImage = 20;
    private static final int pbiXPelsPerMeter = 24;
    private static final int pbiYPelsPerMeter = 28;
    private static final int bi_size = 40;
    private int bfSize;
    private int bfOffBits;
    private int biBitCount;
    private int biSizeImage;
    private RGBProcessor processor;
    private int[] pix;
    private int width;
    private int height;
    private int rgbcount;
    private int rgbquadints;
    private int rgbquadbytes;
    private int widthbytes;

    public BmpWriter(Image img) {
        if (img == null) {
            return;
        }
        PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, true);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if ((pg.status() & 0x80) != 0) {
            return;
        }
        this.pix = (int[])pg.getPixels();
        this.width = pg.getWidth();
        this.height = pg.getHeight();
    }

    public BmpWriter(int[] pix, int width, int height) {
        this.pix = pix;
        this.width = width;
        this.height = height;
    }

    public void write(OutputStream os) throws IOException {
        this.processor = new RGBProcessor(this.pix, 256);
        this.rgbcount = this.processor.count();
        if (this.rgbcount < 0) {
            this.biBitCount = 24;
            this.rgbquadints = 0;
        } else if (this.rgbcount > 16) {
            this.biBitCount = 8;
            this.rgbquadints = 256;
        } else if (this.rgbcount > 2) {
            this.biBitCount = 4;
            this.rgbquadints = 16;
        } else {
            this.biBitCount = 1;
            this.rgbquadints = 2;
        }
        this.widthbytes = (this.width * this.biBitCount + 31 & 0xFFFFFFE0) >>> 3;
        this.rgbquadbytes = this.rgbquadints << 2;
        this.bfOffBits = 54 + this.rgbquadbytes;
        this.biSizeImage = this.widthbytes * this.height;
        this.bfSize = this.bfOffBits + this.biSizeImage;
        this.writeFileHeader(os);
        this.writeInfoHeader(os);
        this.writeRGBQuad(os);
        this.writeBody(os);
    }

    void writeFileHeader(OutputStream os) throws IOException {
        ByteArray fileheader = new ByteArray(14, false);
        fileheader.set2(19778, 0);
        fileheader.set4(this.bfSize, 2);
        fileheader.set4(this.bfOffBits, 10);
        os.write(fileheader.getBytes());
    }

    void writeInfoHeader(OutputStream os) throws IOException {
        ByteArray infoheader = new ByteArray(40, false);
        infoheader.set4(40, 0);
        infoheader.set4(this.width, 4);
        infoheader.set4(this.height, 8);
        infoheader.set2(1, 12);
        infoheader.set2(this.biBitCount, 14);
        infoheader.set4(this.biSizeImage, 20);
        infoheader.set4(4096, 24);
        infoheader.set4(4096, 28);
        os.write(infoheader.getBytes());
    }

    void writeRGBQuad(OutputStream os) throws IOException {
        int[] rgbquad = this.processor.getTable();
        if (rgbquad == null) {
            return;
        }
        ByteArray bamRgbQuad = new ByteArray(this.rgbquadbytes, false);
        int i = 0;
        while (i < this.rgbcount) {
            bamRgbQuad.set4(rgbquad[i], i << 2);
            ++i;
        }
        os.write(bamRgbQuad.getBytes());
    }

    void writeBody(OutputStream os) throws IOException {
        int xy = this.width * this.height;
        byte[] bline = new byte[this.widthbytes];
        int[] iline = new int[this.width + 7];
        while (xy > 0) {
            xy -= this.width;
            int x = 0;
            while (x < this.width) {
                iline[x] = this.pix[xy + x];
                ++x;
            }
            switch (this.biBitCount) {
                case 1: {
                    x = 0;
                    while (x < this.width) {
                        int bx = x >>> 3;
                        int ixs = 0;
                        int i = 0;
                        while (i < 8) {
                            ixs <<= 1;
                            ixs |= this.processor.getIndex(iline[x++]);
                            ++i;
                        }
                        bline[bx] = (byte)ixs;
                    }
                    break;
                }
                case 4: {
                    x = 0;
                    while (x < this.width) {
                        bline[x >>> 1] = (byte)(this.processor.getIndex(iline[x]) << 4 | this.processor.getIndex(iline[x + 1]));
                        x += 2;
                    }
                    break;
                }
                case 8: {
                    x = 0;
                    while (x < this.width) {
                        bline[x] = (byte)this.processor.getIndex(iline[x]);
                        ++x;
                    }
                    break;
                }
                default: {
                    int x3 = 0;
                    int x2 = 0;
                    while (x2 < this.width) {
                        int col = iline[x2];
                        bline[x3 + 2] = (byte)(col >> 16 & 0xFF);
                        bline[x3 + 1] = (byte)(col >> 8 & 0xFF);
                        bline[x3 + 0] = (byte)(col & 0xFF);
                        x3 += 3;
                        ++x2;
                    }
                    break block0;
                }
            }
            os.write(bline);
        }
    }

    static class ByteArray {
        private int h2;
        private int l2;
        private int h4;
        private int l4;
        private int h8;
        private int l8;
        private byte[] bytes;

        byte[] getBytes() {
            return this.bytes;
        }

        ByteArray(boolean bigendian) {
            this.h2 = bigendian ? 0 : 1;
            this.l2 = 1 - this.h2;
            this.h4 = this.h2 << 1;
            this.l4 = this.l2 << 1;
            this.h8 = this.h4 << 1;
            this.l8 = this.l4 << 1;
        }

        ByteArray(int len, boolean bigendian) {
            this(bigendian);
            this.bytes = new byte[len];
        }

        void set1(byte by, int i) {
            this.bytes[i] = by;
        }

        void set1(int in, int i) {
            this.bytes[i] = (byte)in;
        }

        void set2(int in, int i) {
            this.bytes[i + this.h2] = (byte)(in >> 8);
            this.bytes[i + this.l2] = (byte)in;
        }

        void set4(int in, int i) {
            this.set2(in >> 16, i + this.h4);
            this.set2(in, i + this.l4);
        }

        void set8(long lo, int i) {
            this.set4((int)(lo >> 32), i + this.h8);
            this.set4((int)lo, i + this.l8);
        }
    }

    static class RGBProcessor {
        private int[][][] tree;
        private int[] pix;
        private int[] tbl;
        private int lim;
        private int count;
        private int rrggbb;
        private int rr;
        private int gg;
        private int bb;

        RGBProcessor(int[] pix, int lim) {
            this.pix = pix;
            this.lim = lim;
            this.tree = new int[256][][];
            this.tbl = new int[lim + 1];
        }

        int count() {
            int i = 0;
            while (i < this.pix.length) {
                this.splitRGB(this.pix[i]);
                if (this.tree[this.rr] == null) {
                    if (this.overCount()) break;
                    this.tree[this.rr] = new int[256][];
                    this.tree[this.rr][this.gg] = new int[256];
                    this.addRGB(true);
                } else if (this.tree[this.rr][this.gg] == null) {
                    if (this.overCount()) break;
                    this.tree[this.rr][this.gg] = new int[256];
                    this.addRGB(true);
                } else if (this.tree[this.rr][this.gg][this.bb] < 0) {
                    if (this.overCount()) break;
                    this.addRGB(false);
                }
                ++i;
            }
            return this.count;
        }

        boolean overCount() {
            boolean over;
            boolean bl = over = this.count >= this.lim;
            if (over) {
                this.count = -1;
            }
            return over;
        }

        void splitRGB(int col) {
            this.rrggbb = col & 0xFFFFFF;
            this.rr = this.rrggbb >> 16;
            this.gg = this.rrggbb >> 8 & 0xFF;
            this.bb = this.rrggbb & 0xFF;
        }

        void addRGB(boolean init) {
            if (init) {
                int i = 0;
                while (i < 256) {
                    this.tree[this.rr][this.gg][i] = -1;
                    ++i;
                }
            }
            this.tree[this.rr][this.gg][this.bb] = this.count;
            this.tbl[this.count] = this.rrggbb;
            ++this.count;
        }

        int[] getTable() {
            if (this.count > this.lim) {
                return null;
            }
            return this.tbl;
        }

        int getIndex(int col) {
            this.splitRGB(col);
            return this.tree[this.rr][this.gg][this.bb];
        }
    }
}

