/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;

public class DocumentWriter
implements IDocumentWriter {
    private IArchiveFile archive;

    public DocumentWriter(IArchiveFile file) {
        this.archive = file;
    }

    @Override
    public void setRunnable(IReportRunnable runnable) throws EngineException {
        if (this.archive == null || runnable == null) {
            return;
        }
        try {
            ArchiveWriter writer = new ArchiveWriter(this.archive);
            ReportDesignHandle design = (ReportDesignHandle)runnable.getDesignHandle();
            RAOutputStream out = writer.createRandomAccessStream("/design");
            DocumentUtil.serialize((ReportDesignHandle)design, (OutputStream)out);
            out.close();
            out = writer.createRandomAccessStream("/original_design");
            DocumentUtil.serialize((ReportDesignHandle)design, (OutputStream)out);
            out.close();
            Report report = new ReportParser().parse((ReportDesignHandle)runnable.getDesignHandle());
            out = writer.createRandomAccessStream("/design.ir");
            new EngineIRWriter().write((OutputStream)out, report);
            out.close();
        }
        catch (IOException ex) {
            throw new EngineException("exception when updating runnable into a document", ex);
        }
    }

    @Override
    public void close() {
    }
}

