/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.TimelineDevice;

public class PCIeCalculator {
    private final Number pcieGen;
    private final Number pcieWidth;
    private final Number pcieRate;
    private final Long overrideGen;
    private final Long overrideWidth;
    private final Long overrideRate;

    public PCIeCalculator(Analysis analysis, TimelineDevice device) {
        this.pcieGen = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN);
        this.pcieRate = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE);
        this.pcieWidth = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH);
        this.overrideGen = analysis == null ? null : analysis.getPCIeGeneration(device.getId());
        this.overrideWidth = analysis == null ? null : analysis.getPCIeLinkWidth(device.getId());
        this.overrideRate = analysis == null ? null : analysis.getPCIeLinkRate(device.getId());
    }

    public Long getPCIeGeneration() {
        return this.overrideGen != null ? this.overrideGen : this.getDefaultPCIeGeneration();
    }

    public Long getPCIeLinkWidth() {
        return this.overrideWidth != null ? this.overrideWidth : this.getDefaultPCIeLinkWidth();
    }

    public Long getPCIeLinkRate() {
        return this.overrideRate != null ? this.overrideRate : this.getDefaultPCIeLinkRate();
    }

    public Long getDefaultPCIeGeneration() {
        return this.pcieGen instanceof Long ? Long.valueOf(this.pcieGen.longValue()) : null;
    }

    public Long getOverridePCIeGeneration() {
        return this.overrideGen;
    }

    public Long getDefaultPCIeLinkWidth() {
        return this.pcieWidth instanceof Long ? Long.valueOf(this.pcieWidth.longValue()) : null;
    }

    public Long getOverridePCIeLinkWidth() {
        return this.overrideWidth;
    }

    public Long getDefaultPCIeLinkRate() {
        return this.pcieRate instanceof Long ? Long.valueOf(this.pcieRate.longValue()) : null;
    }

    public Long getOverridePCIeLinkRate() {
        return this.overrideRate;
    }

    public Number getScaledUtilization(Number levelCode) {
        return PCIeCalculator.getScaledUtilization(this.pcieGen, this.pcieWidth, this.pcieRate, this.overrideGen, this.overrideWidth, this.overrideRate, levelCode);
    }

    static Long getTheoreticPeak(long generation, long width, long rate) {
        switch ((int)generation) {
            case 1: 
            case 2: {
                return new Long(width * rate * 1000L * 100L);
            }
            case 3: {
                return new Long(width * rate * 123077L);
            }
        }
        return null;
    }

    static Long getUnidirectionalPeak(long generation, long width, long rate) {
        Long peak = PCIeCalculator.getTheoreticPeak(generation, width, rate);
        if (peak == null) {
            return null;
        }
        return new Long(peak * 85L / 100L);
    }

    static Long getBidirectionalPeak(long generation, long width, long rate) {
        Long peak = PCIeCalculator.getTheoreticPeak(generation, width, rate);
        if (peak == null) {
            return null;
        }
        return new Long(peak * 75L / 100L);
    }

    static Number getScaledUtilization(Analysis analysis, TimelineDevice device, Number levelCode) {
        if (analysis != null) {
            Number pciGen = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN);
            Number pciRate = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE);
            Number pciWidth = device.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH);
            Long overrideGen = analysis.getPCIeGeneration(device.getId());
            Long overrideWidth = analysis.getPCIeLinkWidth(device.getId());
            Long overrideRate = analysis.getPCIeLinkRate(device.getId());
            return PCIeCalculator.getScaledUtilization(pciGen, pciWidth, pciRate, overrideGen, overrideWidth, overrideRate, levelCode);
        }
        return levelCode;
    }

    private static Number getScaledUtilization(Number pciGen, Number pciWidth, Number pciRate, Long overrideGen, Long overrideWidth, Long overrideRate, Number levelCode) {
        if (pciGen instanceof Long && pciRate instanceof Long && pciWidth instanceof Long) {
            Long def = PCIeCalculator.getTheoreticPeak(pciGen.longValue(), pciWidth.longValue(), pciRate.longValue());
            Long override = PCIeCalculator.getTheoreticPeak(overrideGen != null ? overrideGen.longValue() : pciGen.longValue(), overrideWidth != null ? overrideWidth.longValue() : pciWidth.longValue(), overrideRate != null ? overrideRate.longValue() : pciRate.longValue());
            if (def != null && override != null && def != override) {
                double ratio = def.doubleValue() / override.doubleValue();
                CuptiMetricValueUtilizationLevel level = CuptiMetricValueUtilizationLevel.valueOf((int)levelCode.longValue());
                double levelPercent = level == null ? 0.0 : level.getEquivalentUtilizationPercent();
                CuptiMetricValueUtilizationLevel newLevel = CuptiMetricValueUtilizationLevel.valueForPercent(levelPercent *= ratio);
                return new Long(newLevel.getCode());
            }
        }
        return levelCode;
    }
}

