/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.ActionUtil;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private CEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.open_action");
    }

    public OpenAction(CEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof ISourceReference || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        try {
            ICElement element = SelectionConverter.codeResolve(this.fEditor, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element);
            if (element == null) {
                IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            ICElement input = SelectionConverter.getInput(this.fEditor);
            int type = element.getElementType();
            if (type == 11 || type == 12) {
                element = input;
            }
            this.run(new Object[]{element});
        }
        catch (CModelException e) {
            this.showError((CoreException)e);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object element = objectArray[n2];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (CModelException e) {
                    CUIPlugin.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 10001, ActionMessages.OpenAction_error_message, (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof ICElement) {
                        name = ((ICElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)NLS.bind((String)ActionMessages.OpenAction_error_messageArgs, (Object)name, (Object)x.getMessage()));
                }
            }
            ++n2;
        }
    }

    public Object getElementToOpen(Object object) throws CModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

