.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
polyhedra \- draws the 80 uniform polyhedra and their duals
.SH SYNOPSIS
.SH SYNOPSIS
.B polyhedra
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-speed \fIfloat\fP]
[\-duration \fIseconds\fP]
[\-no-wander]
[\-spin \fIXYZ\fP]
[\-wireframe]
[\-no-titles]
[\-which \fIname\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
This program renders 160 different 3D solids, and displays some
information about each.  A new solid is chosen every few seconds.

There are 75 uniform polyhedra, plus an inifinite number of
prisms and antiprisms:

  * Convex Uniform Polyhedra:
    * Platonic solids (5)
    * Archimedean solids (13)
    * Convex prisms and antiprisms (2 infinite families)
  * Nonconvex Uniform Polyhedra:
    * Kepler-Poinsot polyhedra (4)
    * Nonconvex uniform polyhedra (53)
    * Nonconvex prisms, antiprisms, and crossed antiprisms
      (3 infinite families)

Representative samples of the prism sets brings the total to 80 solids.
Including the \fIdual\fP of each brings the total up to 160.  (To
create the "dual" of a polyhedron, faces are replaced with vertices,
and vertices with faces.)
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds.).
.TP 8
.B \-speed \fInumber\fP
Larger numbers mean run faster.  Default: 1.0.
.TP 8
.B \-duration \fIseconds\fP
How long before switching to a new polyhedron.  Default 12 seconds.
.TP 8
.B \-wander | \-no-wander
Whether the objects should wander around the screen.
.TP 8
.B \-spin [XYZ] | \-no-spin
Which axes, if any, to spin around on.
.TP 8
.B \-titles | \-no-titles
Whether to display text describing each object.
.TP 8
.B \-which \fIobject-name\fP
Display only one particular object, identified by number, name, or
Whthoff symbol.
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH KEY BINDINGS
When running in a window, you can rotate the object with the mouse.
Also, the following keystrokes are defined:
.TP 12
.B SPC \fIor\fP TAB
Select a new polyhedron at random.
.TP 12
.B + \fIor\fP >
Select the next-higher-numbered polyhedron.
.TP 12
.B - \fIor\fP <
Select the next-lower-numbered polyhedron.
.TP 12
.B ESC \fIor\fP ^C
Quit.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 1991-2002 Dr. Zvi Har'El.

Copyright \(co 2004 Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Based on the program \fIkaleido\fP ("Kaleidoscopic construction of 
uniform polyhedra"), by Dr. Zvi Har'El <rl@math.technion.ac.il>
    http://www.math.technion.ac.il/~rl/
    ftp://ftp.math.technion.ac.il/kaleido/

Adapted for OpenGL and XScreenSaver by Jamie Zawinski, 2004.
