#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Features.Transforms.EPBasis import EPBasis

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054970.6259077
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:50 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/Features/Transforms/HermiteGaussEPBasis.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class HermiteGaussEPBasis(EPBasis):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(HermiteGaussEPBasis, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Hermite-Gauss basis (Harmonic oscillator) at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''Hermite-Gauss basis (Harmonic oscillator)''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForwardDimConstantsAtIndex(self, forwardDimRep, backwardDimRep, forwardIndex, **KWS):



        ## CHEETAH: generated from @def transformMatricesForwardDimConstantsAtIndex($forwardDimRep, $backwardDimRep, $forwardIndex) at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''real hermiteGaussMinusOne = 0.0;
real hermiteGaussMinusTwo = 0.0;
const real _root = _hermite_zeros_''')
        _v = VFFSL(SL,"forwardDimRep.parent.name",True) # '${forwardDimRep.parent.name}' on line 34, col 35
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.parent.name}')) # from line 34, col 35.
        write('''[''')
        _v = VFFSL(SL,"forwardIndex",True) # '${forwardIndex}' on line 34, col 64
        if _v is not None: write(_filter(_v, rawExpr='${forwardIndex}')) # from line 34, col 64.
        write('''] / sqrt(''')
        _v = VFFSL(SL,"forwardDimRep.fieldCount",True) / 2.0 # '${forwardDimRep.fieldCount / 2.0}' on line 34, col 88
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.fieldCount / 2.0}')) # from line 34, col 88.
        write(''');
const real expFactor = exp(-0.5 * _root * _root / ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 35, col 51
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 35, col 51.
        write(''');
const real expFactor2 = exp(-_root * _root / ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 36, col 46
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 36, col 46.
        write(''');
const real normalisation = 1.0/sqrt(''')
        _v = VFFSL(SL,"forwardDimRep._maximum",True) # '${forwardDimRep._maximum}' on line 37, col 37
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep._maximum}')) # from line 37, col 37.
        write(''');
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 40, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''real hermiteGauss;
const real correctionFactor = exp( -0.5 * _root * _root * (''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 43, col 60
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 43, col 60.
        write(''' - ''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 43, col 94
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 43, col 94.
        write(''' - 1) / ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 43, col 118
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 43, col 118.
        write(''') * normalisation;
if (''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 44, col 5
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 44, col 5.
        write(''' == 0)
  hermiteGauss = pow(M_PI, -0.25) * expFactor;
else if (''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 46, col 10
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 46, col 10.
        write(''' == 1)
  hermiteGauss = sqrt(2.0) * _root * hermiteGaussMinusOne * expFactor;
else
  hermiteGauss = sqrt(2.0/''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 49, col 27
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 49, col 27.
        write(''') * _root * hermiteGaussMinusOne * expFactor \\
                 - sqrt((''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 50, col 26
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 50, col 26.
        write('''-1.0)/''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 50, col 48
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 50, col 48.
        write(''') * hermiteGaussMinusTwo * expFactor2;

''')
        _v = super(HermiteGaussEPBasis, self).transformMatricesForDimRepsAtIndices(forwardDimRep,backwardDimRep,forwardIndex,backwardIndex)
        if _v is not None: write(_filter(_v))
        write('''
hermiteGaussMinusTwo = hermiteGaussMinusOne;
hermiteGaussMinusOne = hermiteGauss;
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def forwardMatrixForDimAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def forwardMatrixForDimAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 59, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''hermiteGauss * correctionFactor * ''')
        _v = VFFSL(SL,"forwardDimRep.stepSizeArrayName",True) # '${forwardDimRep.stepSizeArrayName}' on line 60, col 35
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.stepSizeArrayName}')) # from line 60, col 35.
        write('''[''')
        _v = VFFSL(SL,"forwardIndex",True) # '$forwardIndex' on line 60, col 70
        if _v is not None: write(_filter(_v, rawExpr='$forwardIndex')) # from line 60, col 70.
        write(''']''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def backwardMatrixForDimAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def backwardMatrixForDimAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 63, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''hermiteGauss * correctionFactor''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # HermiteGaussEPBasis.tmpl
        # 
        # Hermite-Gauss basis using the definite parity of the basis functions to remove
        # half the work.
        # 
        # Created by Graham Dennis on 2008-12-28.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''





''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_HermiteGaussEPBasis = 'writeBody'

## END CLASS DEFINITION

if not hasattr(HermiteGaussEPBasis, '_initCheetahAttributes'):
    templateAPIClass = getattr(HermiteGaussEPBasis,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(HermiteGaussEPBasis)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=HermiteGaussEPBasis()).run()


