/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.MoreMath;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.TestEval;
import org.javia.arity.TestFormat;
import org.javia.arity.Util;

public class UnitTest {
    private static final String[] profileCases = new String[]{"(100.5 + 20009.999)*(7+4+3)/(5/2)^3!)*2", "fun1(x)=(x+2)*(x+3)", "otherFun(x)=(fun1(x-1)*x+1)*(fun1(2-x)+10)", "log(x+30.5, 3)^.7*sin(x+.5)"};
    static boolean allOk = true;
    static int checkCounter = 0;

    public static void main(String[] stringArray) throws SyntaxException, ArityException {
        int n = stringArray.length;
        if (n == 0) {
            UnitTest.runUnitTests();
            UnitTest.profile();
        } else if (n == 1 && stringArray[0].equals("-profile")) {
            UnitTest.profile();
        } else {
            Symbols symbols = new Symbols();
            for (int i = 0; i < n; ++i) {
                FunctionAndName functionAndName = symbols.compile(stringArray[i]);
                symbols.define(functionAndName);
            }
            UnitTest.profile(symbols, stringArray[n - 1]);
        }
    }

    static void profile(Symbols symbols, String string) throws SyntaxException, ArityException {
        Function function = symbols.compile((String)string).function;
        System.out.println("\n" + string + ": " + function);
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.gc();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            symbols.compile(string);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("compilation time: " + (l2 - l) + " us");
        double[] dArray = new double[function.arity()];
        runtime.gc();
        l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            function.eval(dArray);
        }
        l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("execution time: " + (l3 > 100L ? "" + (double)l3 / 100.0 + " us" : "" + l3 + " ns"));
    }

    private static void profile() {
        String[] stringArray = profileCases;
        Symbols symbols = new Symbols();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                symbols.define(symbols.compile(stringArray[i]));
                UnitTest.profile(symbols, stringArray[i]);
            }
        }
        catch (Exception exception) {
            throw new Error("" + exception);
        }
    }

    static void runUnitTests() {
        checkCounter = 0;
        UnitTest.cheq(MoreMath.log(-1.0), Double.NaN);
        UnitTest.cheq(MoreMath.log(-0.03), Double.NaN);
        UnitTest.cheq(MoreMath.intLog10(-0.03), 0.0);
        UnitTest.cheq(MoreMath.intLog10(0.03), -2.0);
        UnitTest.cheq(MoreMath.intExp10(3), 1000.0);
        UnitTest.cheq(MoreMath.intExp10(-1), 0.1);
        UnitTest.cheq(Util.shortApprox(1.235, 0.02), 1.24);
        UnitTest.cheq(Util.shortApprox(1.235, 0.4), 1.2000000000000002);
        UnitTest.cheq(Util.shortApprox(-1.235, 0.02), -1.24);
        UnitTest.cheq(Util.shortApprox(-1.235, 0.4), -1.2000000000000002);
        UnitTest.check(TestFormat.testFormat());
        try {
            UnitTest.check(TestEval.testEval());
        }
        catch (ArityException arityException) {
            System.out.println("" + arityException);
        }
        if (!allOk) {
            System.out.println("\n*** Some tests FAILED ***\n");
            System.exit(1);
        } else {
            System.out.println("\n*** All tests passed OK ***\n");
        }
    }

    static void cheq(double d, double d2) {
        ++checkCounter;
        if (!(d == d2 || Double.isNaN(d) && Double.isNaN(d2))) {
            allOk = false;
        }
    }

    static void check(boolean bl) {
        ++checkCounter;
        if (!bl) {
            allOk = false;
        }
    }
}

