/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.dom;

import com.sun.xml.fastinfoset.Encoder;
import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import java.io.IOException;
import org.jvnet.fastinfoset.FastInfosetException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMDocumentSerializer
extends Encoder {
    protected Node[] _namespaceAttributes = new Node[4];
    protected Node[] _attributes = new Node[32];

    public final void serialize(Node n) throws IOException {
        switch (n.getNodeType()) {
            case 9: {
                this.serialize((Document)n);
            }
            case 1: {
                this.serializeElementAsDocument(n);
                break;
            }
            case 8: {
                this.serializeComment(n);
                break;
            }
            case 7: {
                this.serializeProcessingInstruction(n);
            }
        }
    }

    public final void serialize(Document d) throws IOException {
        this.reset();
        this.encodeHeader(false);
        this.encodeInitialVocabulary();
        NodeList nl = d.getChildNodes();
        block5: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    this.serializeElement(n);
                    continue block5;
                }
                case 8: {
                    this.serializeComment(n);
                    continue block5;
                }
                case 7: {
                    this.serializeProcessingInstruction(n);
                }
            }
        }
        this.encodeDocumentTermination();
    }

    protected final void serializeElementAsDocument(Node e) throws IOException {
        this.reset();
        this.encodeHeader(false);
        this.encodeInitialVocabulary();
        this.serializeElement(e);
        this.encodeDocumentTermination();
    }

    protected final void serializeElement(Node e) throws IOException {
        Node a;
        int i;
        this.encodeTermination();
        int namespaceAttributesSize = 0;
        int attributesSize = 0;
        if (e.hasAttributes()) {
            NamedNodeMap nnm = e.getAttributes();
            for (i = 0; i < nnm.getLength(); ++i) {
                Node[] attributes;
                a = nnm.item(i);
                String namespaceURI = a.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                    if (namespaceAttributesSize == this._namespaceAttributes.length) {
                        attributes = new Node[namespaceAttributesSize * 3 / 2 + 1];
                        System.arraycopy(this._namespaceAttributes, 0, attributes, 0, namespaceAttributesSize);
                        this._namespaceAttributes = attributes;
                    }
                    this._namespaceAttributes[namespaceAttributesSize++] = a;
                    continue;
                }
                if (attributesSize == this._attributes.length) {
                    attributes = new Node[attributesSize * 3 / 2 + 1];
                    System.arraycopy(this._attributes, 0, attributes, 0, attributesSize);
                    this._attributes = attributes;
                }
                this._attributes[attributesSize++] = a;
            }
        }
        if (namespaceAttributesSize > 0) {
            if (attributesSize > 0) {
                this.write(120);
            } else {
                this.write(56);
            }
            for (int i2 = 0; i2 < namespaceAttributesSize; ++i2) {
                Node a2 = this._namespaceAttributes[i2];
                this._namespaceAttributes[i2] = null;
                String prefix = a2.getLocalName();
                if (prefix == "xmlns" || prefix.equals("xmlns")) {
                    prefix = "";
                }
                String uri = a2.getNodeValue();
                this.encodeNamespaceAttribute(prefix, uri);
            }
            this.write(240);
            this._b = 0;
        } else {
            this._b = attributesSize > 0 ? 64 : 0;
        }
        String namespaceURI = e.getNamespaceURI();
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        this.encodeElement(namespaceURI, e.getNodeName(), e.getLocalName());
        if (attributesSize > 0) {
            for (i = 0; i < attributesSize; ++i) {
                a = this._attributes[i];
                this._attributes[i] = null;
                namespaceURI = a.getNamespaceURI();
                namespaceURI = namespaceURI == null ? "" : namespaceURI;
                this.encodeAttribute(namespaceURI, a.getNodeName(), a.getLocalName());
                String value = a.getNodeValue();
                boolean addToTable = value.length() < this.attributeValueSizeConstraint;
                this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable);
            }
            this._b = 240;
            this._terminate = true;
        }
        if (e.hasChildNodes()) {
            NodeList nl = e.getChildNodes();
            block10: for (int i3 = 0; i3 < nl.getLength(); ++i3) {
                Node n = nl.item(i3);
                switch (n.getNodeType()) {
                    case 1: {
                        this.serializeElement(n);
                        continue block10;
                    }
                    case 3: {
                        this.serializeText(n);
                        continue block10;
                    }
                    case 4: {
                        this.serializeCDATA(n);
                        continue block10;
                    }
                    case 8: {
                        this.serializeComment(n);
                        continue block10;
                    }
                    case 7: {
                        this.serializeProcessingInstruction(n);
                    }
                }
            }
        }
        this.encodeElementTermination();
    }

    protected final void serializeText(Node t) throws IOException {
        int length;
        String text = t.getNodeValue();
        int n = length = text != null ? text.length() : 0;
        if (length == 0) {
            return;
        }
        if (length < this._charBuffer.length) {
            this.encodeTermination();
            text.getChars(0, length, this._charBuffer, 0);
            this.encodeCharacters(this._charBuffer, 0, length);
        } else {
            this.encodeTermination();
            char[] ch = text.toCharArray();
            this.encodeCharactersNoClone(ch, 0, length);
        }
    }

    protected final void serializeCDATA(Node t) throws IOException {
        int length;
        String text = t.getNodeValue();
        int n = length = text != null ? text.length() : 0;
        if (length == 0) {
            return;
        }
        this.encodeTermination();
        char[] ch = text.toCharArray();
        try {
            this.encodeCIIBuiltInAlgorithmDataAsCDATA(ch, 0, length);
        }
        catch (FastInfosetException e) {
            throw new IOException("");
        }
    }

    protected final void serializeComment(Node c) throws IOException {
        int length;
        this.encodeTermination();
        String comment = c.getNodeValue();
        int n = length = comment != null ? comment.length() : 0;
        if (length == 0) {
            this.encodeComment(this._charBuffer, 0, 0);
        } else if (length < this._charBuffer.length) {
            comment.getChars(0, length, this._charBuffer, 0);
            this.encodeComment(this._charBuffer, 0, length);
        } else {
            char[] ch = comment.toCharArray();
            this.encodeCommentNoClone(ch, 0, length);
        }
    }

    protected final void serializeProcessingInstruction(Node pi) throws IOException {
        this.encodeTermination();
        String target = pi.getNodeName();
        String data = pi.getNodeValue();
        this.encodeProcessingInstruction(target, data);
    }

    protected final void encodeElement(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (namespaceURI != names[i].namespaceName && !namespaceURI.equals(names[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(names[i].index);
                return;
            }
        }
        if (localName != null) {
            this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, DOMDocumentSerializer.getPrefixFromQualifiedName(qName), localName, entry);
        } else {
            this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, "", qName, entry);
        }
    }

    protected final void encodeAttribute(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (namespaceURI != names[i].namespaceName && !namespaceURI.equals(names[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(names[i].index);
                return;
            }
        }
        if (localName != null) {
            this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, DOMDocumentSerializer.getPrefixFromQualifiedName(qName), localName, entry);
        } else {
            this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, "", qName, entry);
        }
    }
}

