// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) M(rsb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{eq, r0, r0, 0}, true, eq, "eq r0 r0 0", "eq_r0_r0_0"},
     {{eq, r0, r1, 0}, true, eq, "eq r0 r1 0", "eq_r0_r1_0"},
     {{eq, r0, r2, 0}, true, eq, "eq r0 r2 0", "eq_r0_r2_0"},
     {{eq, r0, r3, 0}, true, eq, "eq r0 r3 0", "eq_r0_r3_0"},
     {{eq, r0, r4, 0}, true, eq, "eq r0 r4 0", "eq_r0_r4_0"},
     {{eq, r0, r5, 0}, true, eq, "eq r0 r5 0", "eq_r0_r5_0"},
     {{eq, r0, r6, 0}, true, eq, "eq r0 r6 0", "eq_r0_r6_0"},
     {{eq, r0, r7, 0}, true, eq, "eq r0 r7 0", "eq_r0_r7_0"},
     {{eq, r1, r0, 0}, true, eq, "eq r1 r0 0", "eq_r1_r0_0"},
     {{eq, r1, r1, 0}, true, eq, "eq r1 r1 0", "eq_r1_r1_0"},
     {{eq, r1, r2, 0}, true, eq, "eq r1 r2 0", "eq_r1_r2_0"},
     {{eq, r1, r3, 0}, true, eq, "eq r1 r3 0", "eq_r1_r3_0"},
     {{eq, r1, r4, 0}, true, eq, "eq r1 r4 0", "eq_r1_r4_0"},
     {{eq, r1, r5, 0}, true, eq, "eq r1 r5 0", "eq_r1_r5_0"},
     {{eq, r1, r6, 0}, true, eq, "eq r1 r6 0", "eq_r1_r6_0"},
     {{eq, r1, r7, 0}, true, eq, "eq r1 r7 0", "eq_r1_r7_0"},
     {{eq, r2, r0, 0}, true, eq, "eq r2 r0 0", "eq_r2_r0_0"},
     {{eq, r2, r1, 0}, true, eq, "eq r2 r1 0", "eq_r2_r1_0"},
     {{eq, r2, r2, 0}, true, eq, "eq r2 r2 0", "eq_r2_r2_0"},
     {{eq, r2, r3, 0}, true, eq, "eq r2 r3 0", "eq_r2_r3_0"},
     {{eq, r2, r4, 0}, true, eq, "eq r2 r4 0", "eq_r2_r4_0"},
     {{eq, r2, r5, 0}, true, eq, "eq r2 r5 0", "eq_r2_r5_0"},
     {{eq, r2, r6, 0}, true, eq, "eq r2 r6 0", "eq_r2_r6_0"},
     {{eq, r2, r7, 0}, true, eq, "eq r2 r7 0", "eq_r2_r7_0"},
     {{eq, r3, r0, 0}, true, eq, "eq r3 r0 0", "eq_r3_r0_0"},
     {{eq, r3, r1, 0}, true, eq, "eq r3 r1 0", "eq_r3_r1_0"},
     {{eq, r3, r2, 0}, true, eq, "eq r3 r2 0", "eq_r3_r2_0"},
     {{eq, r3, r3, 0}, true, eq, "eq r3 r3 0", "eq_r3_r3_0"},
     {{eq, r3, r4, 0}, true, eq, "eq r3 r4 0", "eq_r3_r4_0"},
     {{eq, r3, r5, 0}, true, eq, "eq r3 r5 0", "eq_r3_r5_0"},
     {{eq, r3, r6, 0}, true, eq, "eq r3 r6 0", "eq_r3_r6_0"},
     {{eq, r3, r7, 0}, true, eq, "eq r3 r7 0", "eq_r3_r7_0"},
     {{eq, r4, r0, 0}, true, eq, "eq r4 r0 0", "eq_r4_r0_0"},
     {{eq, r4, r1, 0}, true, eq, "eq r4 r1 0", "eq_r4_r1_0"},
     {{eq, r4, r2, 0}, true, eq, "eq r4 r2 0", "eq_r4_r2_0"},
     {{eq, r4, r3, 0}, true, eq, "eq r4 r3 0", "eq_r4_r3_0"},
     {{eq, r4, r4, 0}, true, eq, "eq r4 r4 0", "eq_r4_r4_0"},
     {{eq, r4, r5, 0}, true, eq, "eq r4 r5 0", "eq_r4_r5_0"},
     {{eq, r4, r6, 0}, true, eq, "eq r4 r6 0", "eq_r4_r6_0"},
     {{eq, r4, r7, 0}, true, eq, "eq r4 r7 0", "eq_r4_r7_0"},
     {{eq, r5, r0, 0}, true, eq, "eq r5 r0 0", "eq_r5_r0_0"},
     {{eq, r5, r1, 0}, true, eq, "eq r5 r1 0", "eq_r5_r1_0"},
     {{eq, r5, r2, 0}, true, eq, "eq r5 r2 0", "eq_r5_r2_0"},
     {{eq, r5, r3, 0}, true, eq, "eq r5 r3 0", "eq_r5_r3_0"},
     {{eq, r5, r4, 0}, true, eq, "eq r5 r4 0", "eq_r5_r4_0"},
     {{eq, r5, r5, 0}, true, eq, "eq r5 r5 0", "eq_r5_r5_0"},
     {{eq, r5, r6, 0}, true, eq, "eq r5 r6 0", "eq_r5_r6_0"},
     {{eq, r5, r7, 0}, true, eq, "eq r5 r7 0", "eq_r5_r7_0"},
     {{eq, r6, r0, 0}, true, eq, "eq r6 r0 0", "eq_r6_r0_0"},
     {{eq, r6, r1, 0}, true, eq, "eq r6 r1 0", "eq_r6_r1_0"},
     {{eq, r6, r2, 0}, true, eq, "eq r6 r2 0", "eq_r6_r2_0"},
     {{eq, r6, r3, 0}, true, eq, "eq r6 r3 0", "eq_r6_r3_0"},
     {{eq, r6, r4, 0}, true, eq, "eq r6 r4 0", "eq_r6_r4_0"},
     {{eq, r6, r5, 0}, true, eq, "eq r6 r5 0", "eq_r6_r5_0"},
     {{eq, r6, r6, 0}, true, eq, "eq r6 r6 0", "eq_r6_r6_0"},
     {{eq, r6, r7, 0}, true, eq, "eq r6 r7 0", "eq_r6_r7_0"},
     {{eq, r7, r0, 0}, true, eq, "eq r7 r0 0", "eq_r7_r0_0"},
     {{eq, r7, r1, 0}, true, eq, "eq r7 r1 0", "eq_r7_r1_0"},
     {{eq, r7, r2, 0}, true, eq, "eq r7 r2 0", "eq_r7_r2_0"},
     {{eq, r7, r3, 0}, true, eq, "eq r7 r3 0", "eq_r7_r3_0"},
     {{eq, r7, r4, 0}, true, eq, "eq r7 r4 0", "eq_r7_r4_0"},
     {{eq, r7, r5, 0}, true, eq, "eq r7 r5 0", "eq_r7_r5_0"},
     {{eq, r7, r6, 0}, true, eq, "eq r7 r6 0", "eq_r7_r6_0"},
     {{eq, r7, r7, 0}, true, eq, "eq r7 r7 0", "eq_r7_r7_0"},
     {{ne, r0, r0, 0}, true, ne, "ne r0 r0 0", "ne_r0_r0_0"},
     {{ne, r0, r1, 0}, true, ne, "ne r0 r1 0", "ne_r0_r1_0"},
     {{ne, r0, r2, 0}, true, ne, "ne r0 r2 0", "ne_r0_r2_0"},
     {{ne, r0, r3, 0}, true, ne, "ne r0 r3 0", "ne_r0_r3_0"},
     {{ne, r0, r4, 0}, true, ne, "ne r0 r4 0", "ne_r0_r4_0"},
     {{ne, r0, r5, 0}, true, ne, "ne r0 r5 0", "ne_r0_r5_0"},
     {{ne, r0, r6, 0}, true, ne, "ne r0 r6 0", "ne_r0_r6_0"},
     {{ne, r0, r7, 0}, true, ne, "ne r0 r7 0", "ne_r0_r7_0"},
     {{ne, r1, r0, 0}, true, ne, "ne r1 r0 0", "ne_r1_r0_0"},
     {{ne, r1, r1, 0}, true, ne, "ne r1 r1 0", "ne_r1_r1_0"},
     {{ne, r1, r2, 0}, true, ne, "ne r1 r2 0", "ne_r1_r2_0"},
     {{ne, r1, r3, 0}, true, ne, "ne r1 r3 0", "ne_r1_r3_0"},
     {{ne, r1, r4, 0}, true, ne, "ne r1 r4 0", "ne_r1_r4_0"},
     {{ne, r1, r5, 0}, true, ne, "ne r1 r5 0", "ne_r1_r5_0"},
     {{ne, r1, r6, 0}, true, ne, "ne r1 r6 0", "ne_r1_r6_0"},
     {{ne, r1, r7, 0}, true, ne, "ne r1 r7 0", "ne_r1_r7_0"},
     {{ne, r2, r0, 0}, true, ne, "ne r2 r0 0", "ne_r2_r0_0"},
     {{ne, r2, r1, 0}, true, ne, "ne r2 r1 0", "ne_r2_r1_0"},
     {{ne, r2, r2, 0}, true, ne, "ne r2 r2 0", "ne_r2_r2_0"},
     {{ne, r2, r3, 0}, true, ne, "ne r2 r3 0", "ne_r2_r3_0"},
     {{ne, r2, r4, 0}, true, ne, "ne r2 r4 0", "ne_r2_r4_0"},
     {{ne, r2, r5, 0}, true, ne, "ne r2 r5 0", "ne_r2_r5_0"},
     {{ne, r2, r6, 0}, true, ne, "ne r2 r6 0", "ne_r2_r6_0"},
     {{ne, r2, r7, 0}, true, ne, "ne r2 r7 0", "ne_r2_r7_0"},
     {{ne, r3, r0, 0}, true, ne, "ne r3 r0 0", "ne_r3_r0_0"},
     {{ne, r3, r1, 0}, true, ne, "ne r3 r1 0", "ne_r3_r1_0"},
     {{ne, r3, r2, 0}, true, ne, "ne r3 r2 0", "ne_r3_r2_0"},
     {{ne, r3, r3, 0}, true, ne, "ne r3 r3 0", "ne_r3_r3_0"},
     {{ne, r3, r4, 0}, true, ne, "ne r3 r4 0", "ne_r3_r4_0"},
     {{ne, r3, r5, 0}, true, ne, "ne r3 r5 0", "ne_r3_r5_0"},
     {{ne, r3, r6, 0}, true, ne, "ne r3 r6 0", "ne_r3_r6_0"},
     {{ne, r3, r7, 0}, true, ne, "ne r3 r7 0", "ne_r3_r7_0"},
     {{ne, r4, r0, 0}, true, ne, "ne r4 r0 0", "ne_r4_r0_0"},
     {{ne, r4, r1, 0}, true, ne, "ne r4 r1 0", "ne_r4_r1_0"},
     {{ne, r4, r2, 0}, true, ne, "ne r4 r2 0", "ne_r4_r2_0"},
     {{ne, r4, r3, 0}, true, ne, "ne r4 r3 0", "ne_r4_r3_0"},
     {{ne, r4, r4, 0}, true, ne, "ne r4 r4 0", "ne_r4_r4_0"},
     {{ne, r4, r5, 0}, true, ne, "ne r4 r5 0", "ne_r4_r5_0"},
     {{ne, r4, r6, 0}, true, ne, "ne r4 r6 0", "ne_r4_r6_0"},
     {{ne, r4, r7, 0}, true, ne, "ne r4 r7 0", "ne_r4_r7_0"},
     {{ne, r5, r0, 0}, true, ne, "ne r5 r0 0", "ne_r5_r0_0"},
     {{ne, r5, r1, 0}, true, ne, "ne r5 r1 0", "ne_r5_r1_0"},
     {{ne, r5, r2, 0}, true, ne, "ne r5 r2 0", "ne_r5_r2_0"},
     {{ne, r5, r3, 0}, true, ne, "ne r5 r3 0", "ne_r5_r3_0"},
     {{ne, r5, r4, 0}, true, ne, "ne r5 r4 0", "ne_r5_r4_0"},
     {{ne, r5, r5, 0}, true, ne, "ne r5 r5 0", "ne_r5_r5_0"},
     {{ne, r5, r6, 0}, true, ne, "ne r5 r6 0", "ne_r5_r6_0"},
     {{ne, r5, r7, 0}, true, ne, "ne r5 r7 0", "ne_r5_r7_0"},
     {{ne, r6, r0, 0}, true, ne, "ne r6 r0 0", "ne_r6_r0_0"},
     {{ne, r6, r1, 0}, true, ne, "ne r6 r1 0", "ne_r6_r1_0"},
     {{ne, r6, r2, 0}, true, ne, "ne r6 r2 0", "ne_r6_r2_0"},
     {{ne, r6, r3, 0}, true, ne, "ne r6 r3 0", "ne_r6_r3_0"},
     {{ne, r6, r4, 0}, true, ne, "ne r6 r4 0", "ne_r6_r4_0"},
     {{ne, r6, r5, 0}, true, ne, "ne r6 r5 0", "ne_r6_r5_0"},
     {{ne, r6, r6, 0}, true, ne, "ne r6 r6 0", "ne_r6_r6_0"},
     {{ne, r6, r7, 0}, true, ne, "ne r6 r7 0", "ne_r6_r7_0"},
     {{ne, r7, r0, 0}, true, ne, "ne r7 r0 0", "ne_r7_r0_0"},
     {{ne, r7, r1, 0}, true, ne, "ne r7 r1 0", "ne_r7_r1_0"},
     {{ne, r7, r2, 0}, true, ne, "ne r7 r2 0", "ne_r7_r2_0"},
     {{ne, r7, r3, 0}, true, ne, "ne r7 r3 0", "ne_r7_r3_0"},
     {{ne, r7, r4, 0}, true, ne, "ne r7 r4 0", "ne_r7_r4_0"},
     {{ne, r7, r5, 0}, true, ne, "ne r7 r5 0", "ne_r7_r5_0"},
     {{ne, r7, r6, 0}, true, ne, "ne r7 r6 0", "ne_r7_r6_0"},
     {{ne, r7, r7, 0}, true, ne, "ne r7 r7 0", "ne_r7_r7_0"},
     {{cs, r0, r0, 0}, true, cs, "cs r0 r0 0", "cs_r0_r0_0"},
     {{cs, r0, r1, 0}, true, cs, "cs r0 r1 0", "cs_r0_r1_0"},
     {{cs, r0, r2, 0}, true, cs, "cs r0 r2 0", "cs_r0_r2_0"},
     {{cs, r0, r3, 0}, true, cs, "cs r0 r3 0", "cs_r0_r3_0"},
     {{cs, r0, r4, 0}, true, cs, "cs r0 r4 0", "cs_r0_r4_0"},
     {{cs, r0, r5, 0}, true, cs, "cs r0 r5 0", "cs_r0_r5_0"},
     {{cs, r0, r6, 0}, true, cs, "cs r0 r6 0", "cs_r0_r6_0"},
     {{cs, r0, r7, 0}, true, cs, "cs r0 r7 0", "cs_r0_r7_0"},
     {{cs, r1, r0, 0}, true, cs, "cs r1 r0 0", "cs_r1_r0_0"},
     {{cs, r1, r1, 0}, true, cs, "cs r1 r1 0", "cs_r1_r1_0"},
     {{cs, r1, r2, 0}, true, cs, "cs r1 r2 0", "cs_r1_r2_0"},
     {{cs, r1, r3, 0}, true, cs, "cs r1 r3 0", "cs_r1_r3_0"},
     {{cs, r1, r4, 0}, true, cs, "cs r1 r4 0", "cs_r1_r4_0"},
     {{cs, r1, r5, 0}, true, cs, "cs r1 r5 0", "cs_r1_r5_0"},
     {{cs, r1, r6, 0}, true, cs, "cs r1 r6 0", "cs_r1_r6_0"},
     {{cs, r1, r7, 0}, true, cs, "cs r1 r7 0", "cs_r1_r7_0"},
     {{cs, r2, r0, 0}, true, cs, "cs r2 r0 0", "cs_r2_r0_0"},
     {{cs, r2, r1, 0}, true, cs, "cs r2 r1 0", "cs_r2_r1_0"},
     {{cs, r2, r2, 0}, true, cs, "cs r2 r2 0", "cs_r2_r2_0"},
     {{cs, r2, r3, 0}, true, cs, "cs r2 r3 0", "cs_r2_r3_0"},
     {{cs, r2, r4, 0}, true, cs, "cs r2 r4 0", "cs_r2_r4_0"},
     {{cs, r2, r5, 0}, true, cs, "cs r2 r5 0", "cs_r2_r5_0"},
     {{cs, r2, r6, 0}, true, cs, "cs r2 r6 0", "cs_r2_r6_0"},
     {{cs, r2, r7, 0}, true, cs, "cs r2 r7 0", "cs_r2_r7_0"},
     {{cs, r3, r0, 0}, true, cs, "cs r3 r0 0", "cs_r3_r0_0"},
     {{cs, r3, r1, 0}, true, cs, "cs r3 r1 0", "cs_r3_r1_0"},
     {{cs, r3, r2, 0}, true, cs, "cs r3 r2 0", "cs_r3_r2_0"},
     {{cs, r3, r3, 0}, true, cs, "cs r3 r3 0", "cs_r3_r3_0"},
     {{cs, r3, r4, 0}, true, cs, "cs r3 r4 0", "cs_r3_r4_0"},
     {{cs, r3, r5, 0}, true, cs, "cs r3 r5 0", "cs_r3_r5_0"},
     {{cs, r3, r6, 0}, true, cs, "cs r3 r6 0", "cs_r3_r6_0"},
     {{cs, r3, r7, 0}, true, cs, "cs r3 r7 0", "cs_r3_r7_0"},
     {{cs, r4, r0, 0}, true, cs, "cs r4 r0 0", "cs_r4_r0_0"},
     {{cs, r4, r1, 0}, true, cs, "cs r4 r1 0", "cs_r4_r1_0"},
     {{cs, r4, r2, 0}, true, cs, "cs r4 r2 0", "cs_r4_r2_0"},
     {{cs, r4, r3, 0}, true, cs, "cs r4 r3 0", "cs_r4_r3_0"},
     {{cs, r4, r4, 0}, true, cs, "cs r4 r4 0", "cs_r4_r4_0"},
     {{cs, r4, r5, 0}, true, cs, "cs r4 r5 0", "cs_r4_r5_0"},
     {{cs, r4, r6, 0}, true, cs, "cs r4 r6 0", "cs_r4_r6_0"},
     {{cs, r4, r7, 0}, true, cs, "cs r4 r7 0", "cs_r4_r7_0"},
     {{cs, r5, r0, 0}, true, cs, "cs r5 r0 0", "cs_r5_r0_0"},
     {{cs, r5, r1, 0}, true, cs, "cs r5 r1 0", "cs_r5_r1_0"},
     {{cs, r5, r2, 0}, true, cs, "cs r5 r2 0", "cs_r5_r2_0"},
     {{cs, r5, r3, 0}, true, cs, "cs r5 r3 0", "cs_r5_r3_0"},
     {{cs, r5, r4, 0}, true, cs, "cs r5 r4 0", "cs_r5_r4_0"},
     {{cs, r5, r5, 0}, true, cs, "cs r5 r5 0", "cs_r5_r5_0"},
     {{cs, r5, r6, 0}, true, cs, "cs r5 r6 0", "cs_r5_r6_0"},
     {{cs, r5, r7, 0}, true, cs, "cs r5 r7 0", "cs_r5_r7_0"},
     {{cs, r6, r0, 0}, true, cs, "cs r6 r0 0", "cs_r6_r0_0"},
     {{cs, r6, r1, 0}, true, cs, "cs r6 r1 0", "cs_r6_r1_0"},
     {{cs, r6, r2, 0}, true, cs, "cs r6 r2 0", "cs_r6_r2_0"},
     {{cs, r6, r3, 0}, true, cs, "cs r6 r3 0", "cs_r6_r3_0"},
     {{cs, r6, r4, 0}, true, cs, "cs r6 r4 0", "cs_r6_r4_0"},
     {{cs, r6, r5, 0}, true, cs, "cs r6 r5 0", "cs_r6_r5_0"},
     {{cs, r6, r6, 0}, true, cs, "cs r6 r6 0", "cs_r6_r6_0"},
     {{cs, r6, r7, 0}, true, cs, "cs r6 r7 0", "cs_r6_r7_0"},
     {{cs, r7, r0, 0}, true, cs, "cs r7 r0 0", "cs_r7_r0_0"},
     {{cs, r7, r1, 0}, true, cs, "cs r7 r1 0", "cs_r7_r1_0"},
     {{cs, r7, r2, 0}, true, cs, "cs r7 r2 0", "cs_r7_r2_0"},
     {{cs, r7, r3, 0}, true, cs, "cs r7 r3 0", "cs_r7_r3_0"},
     {{cs, r7, r4, 0}, true, cs, "cs r7 r4 0", "cs_r7_r4_0"},
     {{cs, r7, r5, 0}, true, cs, "cs r7 r5 0", "cs_r7_r5_0"},
     {{cs, r7, r6, 0}, true, cs, "cs r7 r6 0", "cs_r7_r6_0"},
     {{cs, r7, r7, 0}, true, cs, "cs r7 r7 0", "cs_r7_r7_0"},
     {{cc, r0, r0, 0}, true, cc, "cc r0 r0 0", "cc_r0_r0_0"},
     {{cc, r0, r1, 0}, true, cc, "cc r0 r1 0", "cc_r0_r1_0"},
     {{cc, r0, r2, 0}, true, cc, "cc r0 r2 0", "cc_r0_r2_0"},
     {{cc, r0, r3, 0}, true, cc, "cc r0 r3 0", "cc_r0_r3_0"},
     {{cc, r0, r4, 0}, true, cc, "cc r0 r4 0", "cc_r0_r4_0"},
     {{cc, r0, r5, 0}, true, cc, "cc r0 r5 0", "cc_r0_r5_0"},
     {{cc, r0, r6, 0}, true, cc, "cc r0 r6 0", "cc_r0_r6_0"},
     {{cc, r0, r7, 0}, true, cc, "cc r0 r7 0", "cc_r0_r7_0"},
     {{cc, r1, r0, 0}, true, cc, "cc r1 r0 0", "cc_r1_r0_0"},
     {{cc, r1, r1, 0}, true, cc, "cc r1 r1 0", "cc_r1_r1_0"},
     {{cc, r1, r2, 0}, true, cc, "cc r1 r2 0", "cc_r1_r2_0"},
     {{cc, r1, r3, 0}, true, cc, "cc r1 r3 0", "cc_r1_r3_0"},
     {{cc, r1, r4, 0}, true, cc, "cc r1 r4 0", "cc_r1_r4_0"},
     {{cc, r1, r5, 0}, true, cc, "cc r1 r5 0", "cc_r1_r5_0"},
     {{cc, r1, r6, 0}, true, cc, "cc r1 r6 0", "cc_r1_r6_0"},
     {{cc, r1, r7, 0}, true, cc, "cc r1 r7 0", "cc_r1_r7_0"},
     {{cc, r2, r0, 0}, true, cc, "cc r2 r0 0", "cc_r2_r0_0"},
     {{cc, r2, r1, 0}, true, cc, "cc r2 r1 0", "cc_r2_r1_0"},
     {{cc, r2, r2, 0}, true, cc, "cc r2 r2 0", "cc_r2_r2_0"},
     {{cc, r2, r3, 0}, true, cc, "cc r2 r3 0", "cc_r2_r3_0"},
     {{cc, r2, r4, 0}, true, cc, "cc r2 r4 0", "cc_r2_r4_0"},
     {{cc, r2, r5, 0}, true, cc, "cc r2 r5 0", "cc_r2_r5_0"},
     {{cc, r2, r6, 0}, true, cc, "cc r2 r6 0", "cc_r2_r6_0"},
     {{cc, r2, r7, 0}, true, cc, "cc r2 r7 0", "cc_r2_r7_0"},
     {{cc, r3, r0, 0}, true, cc, "cc r3 r0 0", "cc_r3_r0_0"},
     {{cc, r3, r1, 0}, true, cc, "cc r3 r1 0", "cc_r3_r1_0"},
     {{cc, r3, r2, 0}, true, cc, "cc r3 r2 0", "cc_r3_r2_0"},
     {{cc, r3, r3, 0}, true, cc, "cc r3 r3 0", "cc_r3_r3_0"},
     {{cc, r3, r4, 0}, true, cc, "cc r3 r4 0", "cc_r3_r4_0"},
     {{cc, r3, r5, 0}, true, cc, "cc r3 r5 0", "cc_r3_r5_0"},
     {{cc, r3, r6, 0}, true, cc, "cc r3 r6 0", "cc_r3_r6_0"},
     {{cc, r3, r7, 0}, true, cc, "cc r3 r7 0", "cc_r3_r7_0"},
     {{cc, r4, r0, 0}, true, cc, "cc r4 r0 0", "cc_r4_r0_0"},
     {{cc, r4, r1, 0}, true, cc, "cc r4 r1 0", "cc_r4_r1_0"},
     {{cc, r4, r2, 0}, true, cc, "cc r4 r2 0", "cc_r4_r2_0"},
     {{cc, r4, r3, 0}, true, cc, "cc r4 r3 0", "cc_r4_r3_0"},
     {{cc, r4, r4, 0}, true, cc, "cc r4 r4 0", "cc_r4_r4_0"},
     {{cc, r4, r5, 0}, true, cc, "cc r4 r5 0", "cc_r4_r5_0"},
     {{cc, r4, r6, 0}, true, cc, "cc r4 r6 0", "cc_r4_r6_0"},
     {{cc, r4, r7, 0}, true, cc, "cc r4 r7 0", "cc_r4_r7_0"},
     {{cc, r5, r0, 0}, true, cc, "cc r5 r0 0", "cc_r5_r0_0"},
     {{cc, r5, r1, 0}, true, cc, "cc r5 r1 0", "cc_r5_r1_0"},
     {{cc, r5, r2, 0}, true, cc, "cc r5 r2 0", "cc_r5_r2_0"},
     {{cc, r5, r3, 0}, true, cc, "cc r5 r3 0", "cc_r5_r3_0"},
     {{cc, r5, r4, 0}, true, cc, "cc r5 r4 0", "cc_r5_r4_0"},
     {{cc, r5, r5, 0}, true, cc, "cc r5 r5 0", "cc_r5_r5_0"},
     {{cc, r5, r6, 0}, true, cc, "cc r5 r6 0", "cc_r5_r6_0"},
     {{cc, r5, r7, 0}, true, cc, "cc r5 r7 0", "cc_r5_r7_0"},
     {{cc, r6, r0, 0}, true, cc, "cc r6 r0 0", "cc_r6_r0_0"},
     {{cc, r6, r1, 0}, true, cc, "cc r6 r1 0", "cc_r6_r1_0"},
     {{cc, r6, r2, 0}, true, cc, "cc r6 r2 0", "cc_r6_r2_0"},
     {{cc, r6, r3, 0}, true, cc, "cc r6 r3 0", "cc_r6_r3_0"},
     {{cc, r6, r4, 0}, true, cc, "cc r6 r4 0", "cc_r6_r4_0"},
     {{cc, r6, r5, 0}, true, cc, "cc r6 r5 0", "cc_r6_r5_0"},
     {{cc, r6, r6, 0}, true, cc, "cc r6 r6 0", "cc_r6_r6_0"},
     {{cc, r6, r7, 0}, true, cc, "cc r6 r7 0", "cc_r6_r7_0"},
     {{cc, r7, r0, 0}, true, cc, "cc r7 r0 0", "cc_r7_r0_0"},
     {{cc, r7, r1, 0}, true, cc, "cc r7 r1 0", "cc_r7_r1_0"},
     {{cc, r7, r2, 0}, true, cc, "cc r7 r2 0", "cc_r7_r2_0"},
     {{cc, r7, r3, 0}, true, cc, "cc r7 r3 0", "cc_r7_r3_0"},
     {{cc, r7, r4, 0}, true, cc, "cc r7 r4 0", "cc_r7_r4_0"},
     {{cc, r7, r5, 0}, true, cc, "cc r7 r5 0", "cc_r7_r5_0"},
     {{cc, r7, r6, 0}, true, cc, "cc r7 r6 0", "cc_r7_r6_0"},
     {{cc, r7, r7, 0}, true, cc, "cc r7 r7 0", "cc_r7_r7_0"},
     {{mi, r0, r0, 0}, true, mi, "mi r0 r0 0", "mi_r0_r0_0"},
     {{mi, r0, r1, 0}, true, mi, "mi r0 r1 0", "mi_r0_r1_0"},
     {{mi, r0, r2, 0}, true, mi, "mi r0 r2 0", "mi_r0_r2_0"},
     {{mi, r0, r3, 0}, true, mi, "mi r0 r3 0", "mi_r0_r3_0"},
     {{mi, r0, r4, 0}, true, mi, "mi r0 r4 0", "mi_r0_r4_0"},
     {{mi, r0, r5, 0}, true, mi, "mi r0 r5 0", "mi_r0_r5_0"},
     {{mi, r0, r6, 0}, true, mi, "mi r0 r6 0", "mi_r0_r6_0"},
     {{mi, r0, r7, 0}, true, mi, "mi r0 r7 0", "mi_r0_r7_0"},
     {{mi, r1, r0, 0}, true, mi, "mi r1 r0 0", "mi_r1_r0_0"},
     {{mi, r1, r1, 0}, true, mi, "mi r1 r1 0", "mi_r1_r1_0"},
     {{mi, r1, r2, 0}, true, mi, "mi r1 r2 0", "mi_r1_r2_0"},
     {{mi, r1, r3, 0}, true, mi, "mi r1 r3 0", "mi_r1_r3_0"},
     {{mi, r1, r4, 0}, true, mi, "mi r1 r4 0", "mi_r1_r4_0"},
     {{mi, r1, r5, 0}, true, mi, "mi r1 r5 0", "mi_r1_r5_0"},
     {{mi, r1, r6, 0}, true, mi, "mi r1 r6 0", "mi_r1_r6_0"},
     {{mi, r1, r7, 0}, true, mi, "mi r1 r7 0", "mi_r1_r7_0"},
     {{mi, r2, r0, 0}, true, mi, "mi r2 r0 0", "mi_r2_r0_0"},
     {{mi, r2, r1, 0}, true, mi, "mi r2 r1 0", "mi_r2_r1_0"},
     {{mi, r2, r2, 0}, true, mi, "mi r2 r2 0", "mi_r2_r2_0"},
     {{mi, r2, r3, 0}, true, mi, "mi r2 r3 0", "mi_r2_r3_0"},
     {{mi, r2, r4, 0}, true, mi, "mi r2 r4 0", "mi_r2_r4_0"},
     {{mi, r2, r5, 0}, true, mi, "mi r2 r5 0", "mi_r2_r5_0"},
     {{mi, r2, r6, 0}, true, mi, "mi r2 r6 0", "mi_r2_r6_0"},
     {{mi, r2, r7, 0}, true, mi, "mi r2 r7 0", "mi_r2_r7_0"},
     {{mi, r3, r0, 0}, true, mi, "mi r3 r0 0", "mi_r3_r0_0"},
     {{mi, r3, r1, 0}, true, mi, "mi r3 r1 0", "mi_r3_r1_0"},
     {{mi, r3, r2, 0}, true, mi, "mi r3 r2 0", "mi_r3_r2_0"},
     {{mi, r3, r3, 0}, true, mi, "mi r3 r3 0", "mi_r3_r3_0"},
     {{mi, r3, r4, 0}, true, mi, "mi r3 r4 0", "mi_r3_r4_0"},
     {{mi, r3, r5, 0}, true, mi, "mi r3 r5 0", "mi_r3_r5_0"},
     {{mi, r3, r6, 0}, true, mi, "mi r3 r6 0", "mi_r3_r6_0"},
     {{mi, r3, r7, 0}, true, mi, "mi r3 r7 0", "mi_r3_r7_0"},
     {{mi, r4, r0, 0}, true, mi, "mi r4 r0 0", "mi_r4_r0_0"},
     {{mi, r4, r1, 0}, true, mi, "mi r4 r1 0", "mi_r4_r1_0"},
     {{mi, r4, r2, 0}, true, mi, "mi r4 r2 0", "mi_r4_r2_0"},
     {{mi, r4, r3, 0}, true, mi, "mi r4 r3 0", "mi_r4_r3_0"},
     {{mi, r4, r4, 0}, true, mi, "mi r4 r4 0", "mi_r4_r4_0"},
     {{mi, r4, r5, 0}, true, mi, "mi r4 r5 0", "mi_r4_r5_0"},
     {{mi, r4, r6, 0}, true, mi, "mi r4 r6 0", "mi_r4_r6_0"},
     {{mi, r4, r7, 0}, true, mi, "mi r4 r7 0", "mi_r4_r7_0"},
     {{mi, r5, r0, 0}, true, mi, "mi r5 r0 0", "mi_r5_r0_0"},
     {{mi, r5, r1, 0}, true, mi, "mi r5 r1 0", "mi_r5_r1_0"},
     {{mi, r5, r2, 0}, true, mi, "mi r5 r2 0", "mi_r5_r2_0"},
     {{mi, r5, r3, 0}, true, mi, "mi r5 r3 0", "mi_r5_r3_0"},
     {{mi, r5, r4, 0}, true, mi, "mi r5 r4 0", "mi_r5_r4_0"},
     {{mi, r5, r5, 0}, true, mi, "mi r5 r5 0", "mi_r5_r5_0"},
     {{mi, r5, r6, 0}, true, mi, "mi r5 r6 0", "mi_r5_r6_0"},
     {{mi, r5, r7, 0}, true, mi, "mi r5 r7 0", "mi_r5_r7_0"},
     {{mi, r6, r0, 0}, true, mi, "mi r6 r0 0", "mi_r6_r0_0"},
     {{mi, r6, r1, 0}, true, mi, "mi r6 r1 0", "mi_r6_r1_0"},
     {{mi, r6, r2, 0}, true, mi, "mi r6 r2 0", "mi_r6_r2_0"},
     {{mi, r6, r3, 0}, true, mi, "mi r6 r3 0", "mi_r6_r3_0"},
     {{mi, r6, r4, 0}, true, mi, "mi r6 r4 0", "mi_r6_r4_0"},
     {{mi, r6, r5, 0}, true, mi, "mi r6 r5 0", "mi_r6_r5_0"},
     {{mi, r6, r6, 0}, true, mi, "mi r6 r6 0", "mi_r6_r6_0"},
     {{mi, r6, r7, 0}, true, mi, "mi r6 r7 0", "mi_r6_r7_0"},
     {{mi, r7, r0, 0}, true, mi, "mi r7 r0 0", "mi_r7_r0_0"},
     {{mi, r7, r1, 0}, true, mi, "mi r7 r1 0", "mi_r7_r1_0"},
     {{mi, r7, r2, 0}, true, mi, "mi r7 r2 0", "mi_r7_r2_0"},
     {{mi, r7, r3, 0}, true, mi, "mi r7 r3 0", "mi_r7_r3_0"},
     {{mi, r7, r4, 0}, true, mi, "mi r7 r4 0", "mi_r7_r4_0"},
     {{mi, r7, r5, 0}, true, mi, "mi r7 r5 0", "mi_r7_r5_0"},
     {{mi, r7, r6, 0}, true, mi, "mi r7 r6 0", "mi_r7_r6_0"},
     {{mi, r7, r7, 0}, true, mi, "mi r7 r7 0", "mi_r7_r7_0"},
     {{pl, r0, r0, 0}, true, pl, "pl r0 r0 0", "pl_r0_r0_0"},
     {{pl, r0, r1, 0}, true, pl, "pl r0 r1 0", "pl_r0_r1_0"},
     {{pl, r0, r2, 0}, true, pl, "pl r0 r2 0", "pl_r0_r2_0"},
     {{pl, r0, r3, 0}, true, pl, "pl r0 r3 0", "pl_r0_r3_0"},
     {{pl, r0, r4, 0}, true, pl, "pl r0 r4 0", "pl_r0_r4_0"},
     {{pl, r0, r5, 0}, true, pl, "pl r0 r5 0", "pl_r0_r5_0"},
     {{pl, r0, r6, 0}, true, pl, "pl r0 r6 0", "pl_r0_r6_0"},
     {{pl, r0, r7, 0}, true, pl, "pl r0 r7 0", "pl_r0_r7_0"},
     {{pl, r1, r0, 0}, true, pl, "pl r1 r0 0", "pl_r1_r0_0"},
     {{pl, r1, r1, 0}, true, pl, "pl r1 r1 0", "pl_r1_r1_0"},
     {{pl, r1, r2, 0}, true, pl, "pl r1 r2 0", "pl_r1_r2_0"},
     {{pl, r1, r3, 0}, true, pl, "pl r1 r3 0", "pl_r1_r3_0"},
     {{pl, r1, r4, 0}, true, pl, "pl r1 r4 0", "pl_r1_r4_0"},
     {{pl, r1, r5, 0}, true, pl, "pl r1 r5 0", "pl_r1_r5_0"},
     {{pl, r1, r6, 0}, true, pl, "pl r1 r6 0", "pl_r1_r6_0"},
     {{pl, r1, r7, 0}, true, pl, "pl r1 r7 0", "pl_r1_r7_0"},
     {{pl, r2, r0, 0}, true, pl, "pl r2 r0 0", "pl_r2_r0_0"},
     {{pl, r2, r1, 0}, true, pl, "pl r2 r1 0", "pl_r2_r1_0"},
     {{pl, r2, r2, 0}, true, pl, "pl r2 r2 0", "pl_r2_r2_0"},
     {{pl, r2, r3, 0}, true, pl, "pl r2 r3 0", "pl_r2_r3_0"},
     {{pl, r2, r4, 0}, true, pl, "pl r2 r4 0", "pl_r2_r4_0"},
     {{pl, r2, r5, 0}, true, pl, "pl r2 r5 0", "pl_r2_r5_0"},
     {{pl, r2, r6, 0}, true, pl, "pl r2 r6 0", "pl_r2_r6_0"},
     {{pl, r2, r7, 0}, true, pl, "pl r2 r7 0", "pl_r2_r7_0"},
     {{pl, r3, r0, 0}, true, pl, "pl r3 r0 0", "pl_r3_r0_0"},
     {{pl, r3, r1, 0}, true, pl, "pl r3 r1 0", "pl_r3_r1_0"},
     {{pl, r3, r2, 0}, true, pl, "pl r3 r2 0", "pl_r3_r2_0"},
     {{pl, r3, r3, 0}, true, pl, "pl r3 r3 0", "pl_r3_r3_0"},
     {{pl, r3, r4, 0}, true, pl, "pl r3 r4 0", "pl_r3_r4_0"},
     {{pl, r3, r5, 0}, true, pl, "pl r3 r5 0", "pl_r3_r5_0"},
     {{pl, r3, r6, 0}, true, pl, "pl r3 r6 0", "pl_r3_r6_0"},
     {{pl, r3, r7, 0}, true, pl, "pl r3 r7 0", "pl_r3_r7_0"},
     {{pl, r4, r0, 0}, true, pl, "pl r4 r0 0", "pl_r4_r0_0"},
     {{pl, r4, r1, 0}, true, pl, "pl r4 r1 0", "pl_r4_r1_0"},
     {{pl, r4, r2, 0}, true, pl, "pl r4 r2 0", "pl_r4_r2_0"},
     {{pl, r4, r3, 0}, true, pl, "pl r4 r3 0", "pl_r4_r3_0"},
     {{pl, r4, r4, 0}, true, pl, "pl r4 r4 0", "pl_r4_r4_0"},
     {{pl, r4, r5, 0}, true, pl, "pl r4 r5 0", "pl_r4_r5_0"},
     {{pl, r4, r6, 0}, true, pl, "pl r4 r6 0", "pl_r4_r6_0"},
     {{pl, r4, r7, 0}, true, pl, "pl r4 r7 0", "pl_r4_r7_0"},
     {{pl, r5, r0, 0}, true, pl, "pl r5 r0 0", "pl_r5_r0_0"},
     {{pl, r5, r1, 0}, true, pl, "pl r5 r1 0", "pl_r5_r1_0"},
     {{pl, r5, r2, 0}, true, pl, "pl r5 r2 0", "pl_r5_r2_0"},
     {{pl, r5, r3, 0}, true, pl, "pl r5 r3 0", "pl_r5_r3_0"},
     {{pl, r5, r4, 0}, true, pl, "pl r5 r4 0", "pl_r5_r4_0"},
     {{pl, r5, r5, 0}, true, pl, "pl r5 r5 0", "pl_r5_r5_0"},
     {{pl, r5, r6, 0}, true, pl, "pl r5 r6 0", "pl_r5_r6_0"},
     {{pl, r5, r7, 0}, true, pl, "pl r5 r7 0", "pl_r5_r7_0"},
     {{pl, r6, r0, 0}, true, pl, "pl r6 r0 0", "pl_r6_r0_0"},
     {{pl, r6, r1, 0}, true, pl, "pl r6 r1 0", "pl_r6_r1_0"},
     {{pl, r6, r2, 0}, true, pl, "pl r6 r2 0", "pl_r6_r2_0"},
     {{pl, r6, r3, 0}, true, pl, "pl r6 r3 0", "pl_r6_r3_0"},
     {{pl, r6, r4, 0}, true, pl, "pl r6 r4 0", "pl_r6_r4_0"},
     {{pl, r6, r5, 0}, true, pl, "pl r6 r5 0", "pl_r6_r5_0"},
     {{pl, r6, r6, 0}, true, pl, "pl r6 r6 0", "pl_r6_r6_0"},
     {{pl, r6, r7, 0}, true, pl, "pl r6 r7 0", "pl_r6_r7_0"},
     {{pl, r7, r0, 0}, true, pl, "pl r7 r0 0", "pl_r7_r0_0"},
     {{pl, r7, r1, 0}, true, pl, "pl r7 r1 0", "pl_r7_r1_0"},
     {{pl, r7, r2, 0}, true, pl, "pl r7 r2 0", "pl_r7_r2_0"},
     {{pl, r7, r3, 0}, true, pl, "pl r7 r3 0", "pl_r7_r3_0"},
     {{pl, r7, r4, 0}, true, pl, "pl r7 r4 0", "pl_r7_r4_0"},
     {{pl, r7, r5, 0}, true, pl, "pl r7 r5 0", "pl_r7_r5_0"},
     {{pl, r7, r6, 0}, true, pl, "pl r7 r6 0", "pl_r7_r6_0"},
     {{pl, r7, r7, 0}, true, pl, "pl r7 r7 0", "pl_r7_r7_0"},
     {{vs, r0, r0, 0}, true, vs, "vs r0 r0 0", "vs_r0_r0_0"},
     {{vs, r0, r1, 0}, true, vs, "vs r0 r1 0", "vs_r0_r1_0"},
     {{vs, r0, r2, 0}, true, vs, "vs r0 r2 0", "vs_r0_r2_0"},
     {{vs, r0, r3, 0}, true, vs, "vs r0 r3 0", "vs_r0_r3_0"},
     {{vs, r0, r4, 0}, true, vs, "vs r0 r4 0", "vs_r0_r4_0"},
     {{vs, r0, r5, 0}, true, vs, "vs r0 r5 0", "vs_r0_r5_0"},
     {{vs, r0, r6, 0}, true, vs, "vs r0 r6 0", "vs_r0_r6_0"},
     {{vs, r0, r7, 0}, true, vs, "vs r0 r7 0", "vs_r0_r7_0"},
     {{vs, r1, r0, 0}, true, vs, "vs r1 r0 0", "vs_r1_r0_0"},
     {{vs, r1, r1, 0}, true, vs, "vs r1 r1 0", "vs_r1_r1_0"},
     {{vs, r1, r2, 0}, true, vs, "vs r1 r2 0", "vs_r1_r2_0"},
     {{vs, r1, r3, 0}, true, vs, "vs r1 r3 0", "vs_r1_r3_0"},
     {{vs, r1, r4, 0}, true, vs, "vs r1 r4 0", "vs_r1_r4_0"},
     {{vs, r1, r5, 0}, true, vs, "vs r1 r5 0", "vs_r1_r5_0"},
     {{vs, r1, r6, 0}, true, vs, "vs r1 r6 0", "vs_r1_r6_0"},
     {{vs, r1, r7, 0}, true, vs, "vs r1 r7 0", "vs_r1_r7_0"},
     {{vs, r2, r0, 0}, true, vs, "vs r2 r0 0", "vs_r2_r0_0"},
     {{vs, r2, r1, 0}, true, vs, "vs r2 r1 0", "vs_r2_r1_0"},
     {{vs, r2, r2, 0}, true, vs, "vs r2 r2 0", "vs_r2_r2_0"},
     {{vs, r2, r3, 0}, true, vs, "vs r2 r3 0", "vs_r2_r3_0"},
     {{vs, r2, r4, 0}, true, vs, "vs r2 r4 0", "vs_r2_r4_0"},
     {{vs, r2, r5, 0}, true, vs, "vs r2 r5 0", "vs_r2_r5_0"},
     {{vs, r2, r6, 0}, true, vs, "vs r2 r6 0", "vs_r2_r6_0"},
     {{vs, r2, r7, 0}, true, vs, "vs r2 r7 0", "vs_r2_r7_0"},
     {{vs, r3, r0, 0}, true, vs, "vs r3 r0 0", "vs_r3_r0_0"},
     {{vs, r3, r1, 0}, true, vs, "vs r3 r1 0", "vs_r3_r1_0"},
     {{vs, r3, r2, 0}, true, vs, "vs r3 r2 0", "vs_r3_r2_0"},
     {{vs, r3, r3, 0}, true, vs, "vs r3 r3 0", "vs_r3_r3_0"},
     {{vs, r3, r4, 0}, true, vs, "vs r3 r4 0", "vs_r3_r4_0"},
     {{vs, r3, r5, 0}, true, vs, "vs r3 r5 0", "vs_r3_r5_0"},
     {{vs, r3, r6, 0}, true, vs, "vs r3 r6 0", "vs_r3_r6_0"},
     {{vs, r3, r7, 0}, true, vs, "vs r3 r7 0", "vs_r3_r7_0"},
     {{vs, r4, r0, 0}, true, vs, "vs r4 r0 0", "vs_r4_r0_0"},
     {{vs, r4, r1, 0}, true, vs, "vs r4 r1 0", "vs_r4_r1_0"},
     {{vs, r4, r2, 0}, true, vs, "vs r4 r2 0", "vs_r4_r2_0"},
     {{vs, r4, r3, 0}, true, vs, "vs r4 r3 0", "vs_r4_r3_0"},
     {{vs, r4, r4, 0}, true, vs, "vs r4 r4 0", "vs_r4_r4_0"},
     {{vs, r4, r5, 0}, true, vs, "vs r4 r5 0", "vs_r4_r5_0"},
     {{vs, r4, r6, 0}, true, vs, "vs r4 r6 0", "vs_r4_r6_0"},
     {{vs, r4, r7, 0}, true, vs, "vs r4 r7 0", "vs_r4_r7_0"},
     {{vs, r5, r0, 0}, true, vs, "vs r5 r0 0", "vs_r5_r0_0"},
     {{vs, r5, r1, 0}, true, vs, "vs r5 r1 0", "vs_r5_r1_0"},
     {{vs, r5, r2, 0}, true, vs, "vs r5 r2 0", "vs_r5_r2_0"},
     {{vs, r5, r3, 0}, true, vs, "vs r5 r3 0", "vs_r5_r3_0"},
     {{vs, r5, r4, 0}, true, vs, "vs r5 r4 0", "vs_r5_r4_0"},
     {{vs, r5, r5, 0}, true, vs, "vs r5 r5 0", "vs_r5_r5_0"},
     {{vs, r5, r6, 0}, true, vs, "vs r5 r6 0", "vs_r5_r6_0"},
     {{vs, r5, r7, 0}, true, vs, "vs r5 r7 0", "vs_r5_r7_0"},
     {{vs, r6, r0, 0}, true, vs, "vs r6 r0 0", "vs_r6_r0_0"},
     {{vs, r6, r1, 0}, true, vs, "vs r6 r1 0", "vs_r6_r1_0"},
     {{vs, r6, r2, 0}, true, vs, "vs r6 r2 0", "vs_r6_r2_0"},
     {{vs, r6, r3, 0}, true, vs, "vs r6 r3 0", "vs_r6_r3_0"},
     {{vs, r6, r4, 0}, true, vs, "vs r6 r4 0", "vs_r6_r4_0"},
     {{vs, r6, r5, 0}, true, vs, "vs r6 r5 0", "vs_r6_r5_0"},
     {{vs, r6, r6, 0}, true, vs, "vs r6 r6 0", "vs_r6_r6_0"},
     {{vs, r6, r7, 0}, true, vs, "vs r6 r7 0", "vs_r6_r7_0"},
     {{vs, r7, r0, 0}, true, vs, "vs r7 r0 0", "vs_r7_r0_0"},
     {{vs, r7, r1, 0}, true, vs, "vs r7 r1 0", "vs_r7_r1_0"},
     {{vs, r7, r2, 0}, true, vs, "vs r7 r2 0", "vs_r7_r2_0"},
     {{vs, r7, r3, 0}, true, vs, "vs r7 r3 0", "vs_r7_r3_0"},
     {{vs, r7, r4, 0}, true, vs, "vs r7 r4 0", "vs_r7_r4_0"},
     {{vs, r7, r5, 0}, true, vs, "vs r7 r5 0", "vs_r7_r5_0"},
     {{vs, r7, r6, 0}, true, vs, "vs r7 r6 0", "vs_r7_r6_0"},
     {{vs, r7, r7, 0}, true, vs, "vs r7 r7 0", "vs_r7_r7_0"},
     {{vc, r0, r0, 0}, true, vc, "vc r0 r0 0", "vc_r0_r0_0"},
     {{vc, r0, r1, 0}, true, vc, "vc r0 r1 0", "vc_r0_r1_0"},
     {{vc, r0, r2, 0}, true, vc, "vc r0 r2 0", "vc_r0_r2_0"},
     {{vc, r0, r3, 0}, true, vc, "vc r0 r3 0", "vc_r0_r3_0"},
     {{vc, r0, r4, 0}, true, vc, "vc r0 r4 0", "vc_r0_r4_0"},
     {{vc, r0, r5, 0}, true, vc, "vc r0 r5 0", "vc_r0_r5_0"},
     {{vc, r0, r6, 0}, true, vc, "vc r0 r6 0", "vc_r0_r6_0"},
     {{vc, r0, r7, 0}, true, vc, "vc r0 r7 0", "vc_r0_r7_0"},
     {{vc, r1, r0, 0}, true, vc, "vc r1 r0 0", "vc_r1_r0_0"},
     {{vc, r1, r1, 0}, true, vc, "vc r1 r1 0", "vc_r1_r1_0"},
     {{vc, r1, r2, 0}, true, vc, "vc r1 r2 0", "vc_r1_r2_0"},
     {{vc, r1, r3, 0}, true, vc, "vc r1 r3 0", "vc_r1_r3_0"},
     {{vc, r1, r4, 0}, true, vc, "vc r1 r4 0", "vc_r1_r4_0"},
     {{vc, r1, r5, 0}, true, vc, "vc r1 r5 0", "vc_r1_r5_0"},
     {{vc, r1, r6, 0}, true, vc, "vc r1 r6 0", "vc_r1_r6_0"},
     {{vc, r1, r7, 0}, true, vc, "vc r1 r7 0", "vc_r1_r7_0"},
     {{vc, r2, r0, 0}, true, vc, "vc r2 r0 0", "vc_r2_r0_0"},
     {{vc, r2, r1, 0}, true, vc, "vc r2 r1 0", "vc_r2_r1_0"},
     {{vc, r2, r2, 0}, true, vc, "vc r2 r2 0", "vc_r2_r2_0"},
     {{vc, r2, r3, 0}, true, vc, "vc r2 r3 0", "vc_r2_r3_0"},
     {{vc, r2, r4, 0}, true, vc, "vc r2 r4 0", "vc_r2_r4_0"},
     {{vc, r2, r5, 0}, true, vc, "vc r2 r5 0", "vc_r2_r5_0"},
     {{vc, r2, r6, 0}, true, vc, "vc r2 r6 0", "vc_r2_r6_0"},
     {{vc, r2, r7, 0}, true, vc, "vc r2 r7 0", "vc_r2_r7_0"},
     {{vc, r3, r0, 0}, true, vc, "vc r3 r0 0", "vc_r3_r0_0"},
     {{vc, r3, r1, 0}, true, vc, "vc r3 r1 0", "vc_r3_r1_0"},
     {{vc, r3, r2, 0}, true, vc, "vc r3 r2 0", "vc_r3_r2_0"},
     {{vc, r3, r3, 0}, true, vc, "vc r3 r3 0", "vc_r3_r3_0"},
     {{vc, r3, r4, 0}, true, vc, "vc r3 r4 0", "vc_r3_r4_0"},
     {{vc, r3, r5, 0}, true, vc, "vc r3 r5 0", "vc_r3_r5_0"},
     {{vc, r3, r6, 0}, true, vc, "vc r3 r6 0", "vc_r3_r6_0"},
     {{vc, r3, r7, 0}, true, vc, "vc r3 r7 0", "vc_r3_r7_0"},
     {{vc, r4, r0, 0}, true, vc, "vc r4 r0 0", "vc_r4_r0_0"},
     {{vc, r4, r1, 0}, true, vc, "vc r4 r1 0", "vc_r4_r1_0"},
     {{vc, r4, r2, 0}, true, vc, "vc r4 r2 0", "vc_r4_r2_0"},
     {{vc, r4, r3, 0}, true, vc, "vc r4 r3 0", "vc_r4_r3_0"},
     {{vc, r4, r4, 0}, true, vc, "vc r4 r4 0", "vc_r4_r4_0"},
     {{vc, r4, r5, 0}, true, vc, "vc r4 r5 0", "vc_r4_r5_0"},
     {{vc, r4, r6, 0}, true, vc, "vc r4 r6 0", "vc_r4_r6_0"},
     {{vc, r4, r7, 0}, true, vc, "vc r4 r7 0", "vc_r4_r7_0"},
     {{vc, r5, r0, 0}, true, vc, "vc r5 r0 0", "vc_r5_r0_0"},
     {{vc, r5, r1, 0}, true, vc, "vc r5 r1 0", "vc_r5_r1_0"},
     {{vc, r5, r2, 0}, true, vc, "vc r5 r2 0", "vc_r5_r2_0"},
     {{vc, r5, r3, 0}, true, vc, "vc r5 r3 0", "vc_r5_r3_0"},
     {{vc, r5, r4, 0}, true, vc, "vc r5 r4 0", "vc_r5_r4_0"},
     {{vc, r5, r5, 0}, true, vc, "vc r5 r5 0", "vc_r5_r5_0"},
     {{vc, r5, r6, 0}, true, vc, "vc r5 r6 0", "vc_r5_r6_0"},
     {{vc, r5, r7, 0}, true, vc, "vc r5 r7 0", "vc_r5_r7_0"},
     {{vc, r6, r0, 0}, true, vc, "vc r6 r0 0", "vc_r6_r0_0"},
     {{vc, r6, r1, 0}, true, vc, "vc r6 r1 0", "vc_r6_r1_0"},
     {{vc, r6, r2, 0}, true, vc, "vc r6 r2 0", "vc_r6_r2_0"},
     {{vc, r6, r3, 0}, true, vc, "vc r6 r3 0", "vc_r6_r3_0"},
     {{vc, r6, r4, 0}, true, vc, "vc r6 r4 0", "vc_r6_r4_0"},
     {{vc, r6, r5, 0}, true, vc, "vc r6 r5 0", "vc_r6_r5_0"},
     {{vc, r6, r6, 0}, true, vc, "vc r6 r6 0", "vc_r6_r6_0"},
     {{vc, r6, r7, 0}, true, vc, "vc r6 r7 0", "vc_r6_r7_0"},
     {{vc, r7, r0, 0}, true, vc, "vc r7 r0 0", "vc_r7_r0_0"},
     {{vc, r7, r1, 0}, true, vc, "vc r7 r1 0", "vc_r7_r1_0"},
     {{vc, r7, r2, 0}, true, vc, "vc r7 r2 0", "vc_r7_r2_0"},
     {{vc, r7, r3, 0}, true, vc, "vc r7 r3 0", "vc_r7_r3_0"},
     {{vc, r7, r4, 0}, true, vc, "vc r7 r4 0", "vc_r7_r4_0"},
     {{vc, r7, r5, 0}, true, vc, "vc r7 r5 0", "vc_r7_r5_0"},
     {{vc, r7, r6, 0}, true, vc, "vc r7 r6 0", "vc_r7_r6_0"},
     {{vc, r7, r7, 0}, true, vc, "vc r7 r7 0", "vc_r7_r7_0"},
     {{hi, r0, r0, 0}, true, hi, "hi r0 r0 0", "hi_r0_r0_0"},
     {{hi, r0, r1, 0}, true, hi, "hi r0 r1 0", "hi_r0_r1_0"},
     {{hi, r0, r2, 0}, true, hi, "hi r0 r2 0", "hi_r0_r2_0"},
     {{hi, r0, r3, 0}, true, hi, "hi r0 r3 0", "hi_r0_r3_0"},
     {{hi, r0, r4, 0}, true, hi, "hi r0 r4 0", "hi_r0_r4_0"},
     {{hi, r0, r5, 0}, true, hi, "hi r0 r5 0", "hi_r0_r5_0"},
     {{hi, r0, r6, 0}, true, hi, "hi r0 r6 0", "hi_r0_r6_0"},
     {{hi, r0, r7, 0}, true, hi, "hi r0 r7 0", "hi_r0_r7_0"},
     {{hi, r1, r0, 0}, true, hi, "hi r1 r0 0", "hi_r1_r0_0"},
     {{hi, r1, r1, 0}, true, hi, "hi r1 r1 0", "hi_r1_r1_0"},
     {{hi, r1, r2, 0}, true, hi, "hi r1 r2 0", "hi_r1_r2_0"},
     {{hi, r1, r3, 0}, true, hi, "hi r1 r3 0", "hi_r1_r3_0"},
     {{hi, r1, r4, 0}, true, hi, "hi r1 r4 0", "hi_r1_r4_0"},
     {{hi, r1, r5, 0}, true, hi, "hi r1 r5 0", "hi_r1_r5_0"},
     {{hi, r1, r6, 0}, true, hi, "hi r1 r6 0", "hi_r1_r6_0"},
     {{hi, r1, r7, 0}, true, hi, "hi r1 r7 0", "hi_r1_r7_0"},
     {{hi, r2, r0, 0}, true, hi, "hi r2 r0 0", "hi_r2_r0_0"},
     {{hi, r2, r1, 0}, true, hi, "hi r2 r1 0", "hi_r2_r1_0"},
     {{hi, r2, r2, 0}, true, hi, "hi r2 r2 0", "hi_r2_r2_0"},
     {{hi, r2, r3, 0}, true, hi, "hi r2 r3 0", "hi_r2_r3_0"},
     {{hi, r2, r4, 0}, true, hi, "hi r2 r4 0", "hi_r2_r4_0"},
     {{hi, r2, r5, 0}, true, hi, "hi r2 r5 0", "hi_r2_r5_0"},
     {{hi, r2, r6, 0}, true, hi, "hi r2 r6 0", "hi_r2_r6_0"},
     {{hi, r2, r7, 0}, true, hi, "hi r2 r7 0", "hi_r2_r7_0"},
     {{hi, r3, r0, 0}, true, hi, "hi r3 r0 0", "hi_r3_r0_0"},
     {{hi, r3, r1, 0}, true, hi, "hi r3 r1 0", "hi_r3_r1_0"},
     {{hi, r3, r2, 0}, true, hi, "hi r3 r2 0", "hi_r3_r2_0"},
     {{hi, r3, r3, 0}, true, hi, "hi r3 r3 0", "hi_r3_r3_0"},
     {{hi, r3, r4, 0}, true, hi, "hi r3 r4 0", "hi_r3_r4_0"},
     {{hi, r3, r5, 0}, true, hi, "hi r3 r5 0", "hi_r3_r5_0"},
     {{hi, r3, r6, 0}, true, hi, "hi r3 r6 0", "hi_r3_r6_0"},
     {{hi, r3, r7, 0}, true, hi, "hi r3 r7 0", "hi_r3_r7_0"},
     {{hi, r4, r0, 0}, true, hi, "hi r4 r0 0", "hi_r4_r0_0"},
     {{hi, r4, r1, 0}, true, hi, "hi r4 r1 0", "hi_r4_r1_0"},
     {{hi, r4, r2, 0}, true, hi, "hi r4 r2 0", "hi_r4_r2_0"},
     {{hi, r4, r3, 0}, true, hi, "hi r4 r3 0", "hi_r4_r3_0"},
     {{hi, r4, r4, 0}, true, hi, "hi r4 r4 0", "hi_r4_r4_0"},
     {{hi, r4, r5, 0}, true, hi, "hi r4 r5 0", "hi_r4_r5_0"},
     {{hi, r4, r6, 0}, true, hi, "hi r4 r6 0", "hi_r4_r6_0"},
     {{hi, r4, r7, 0}, true, hi, "hi r4 r7 0", "hi_r4_r7_0"},
     {{hi, r5, r0, 0}, true, hi, "hi r5 r0 0", "hi_r5_r0_0"},
     {{hi, r5, r1, 0}, true, hi, "hi r5 r1 0", "hi_r5_r1_0"},
     {{hi, r5, r2, 0}, true, hi, "hi r5 r2 0", "hi_r5_r2_0"},
     {{hi, r5, r3, 0}, true, hi, "hi r5 r3 0", "hi_r5_r3_0"},
     {{hi, r5, r4, 0}, true, hi, "hi r5 r4 0", "hi_r5_r4_0"},
     {{hi, r5, r5, 0}, true, hi, "hi r5 r5 0", "hi_r5_r5_0"},
     {{hi, r5, r6, 0}, true, hi, "hi r5 r6 0", "hi_r5_r6_0"},
     {{hi, r5, r7, 0}, true, hi, "hi r5 r7 0", "hi_r5_r7_0"},
     {{hi, r6, r0, 0}, true, hi, "hi r6 r0 0", "hi_r6_r0_0"},
     {{hi, r6, r1, 0}, true, hi, "hi r6 r1 0", "hi_r6_r1_0"},
     {{hi, r6, r2, 0}, true, hi, "hi r6 r2 0", "hi_r6_r2_0"},
     {{hi, r6, r3, 0}, true, hi, "hi r6 r3 0", "hi_r6_r3_0"},
     {{hi, r6, r4, 0}, true, hi, "hi r6 r4 0", "hi_r6_r4_0"},
     {{hi, r6, r5, 0}, true, hi, "hi r6 r5 0", "hi_r6_r5_0"},
     {{hi, r6, r6, 0}, true, hi, "hi r6 r6 0", "hi_r6_r6_0"},
     {{hi, r6, r7, 0}, true, hi, "hi r6 r7 0", "hi_r6_r7_0"},
     {{hi, r7, r0, 0}, true, hi, "hi r7 r0 0", "hi_r7_r0_0"},
     {{hi, r7, r1, 0}, true, hi, "hi r7 r1 0", "hi_r7_r1_0"},
     {{hi, r7, r2, 0}, true, hi, "hi r7 r2 0", "hi_r7_r2_0"},
     {{hi, r7, r3, 0}, true, hi, "hi r7 r3 0", "hi_r7_r3_0"},
     {{hi, r7, r4, 0}, true, hi, "hi r7 r4 0", "hi_r7_r4_0"},
     {{hi, r7, r5, 0}, true, hi, "hi r7 r5 0", "hi_r7_r5_0"},
     {{hi, r7, r6, 0}, true, hi, "hi r7 r6 0", "hi_r7_r6_0"},
     {{hi, r7, r7, 0}, true, hi, "hi r7 r7 0", "hi_r7_r7_0"},
     {{ls, r0, r0, 0}, true, ls, "ls r0 r0 0", "ls_r0_r0_0"},
     {{ls, r0, r1, 0}, true, ls, "ls r0 r1 0", "ls_r0_r1_0"},
     {{ls, r0, r2, 0}, true, ls, "ls r0 r2 0", "ls_r0_r2_0"},
     {{ls, r0, r3, 0}, true, ls, "ls r0 r3 0", "ls_r0_r3_0"},
     {{ls, r0, r4, 0}, true, ls, "ls r0 r4 0", "ls_r0_r4_0"},
     {{ls, r0, r5, 0}, true, ls, "ls r0 r5 0", "ls_r0_r5_0"},
     {{ls, r0, r6, 0}, true, ls, "ls r0 r6 0", "ls_r0_r6_0"},
     {{ls, r0, r7, 0}, true, ls, "ls r0 r7 0", "ls_r0_r7_0"},
     {{ls, r1, r0, 0}, true, ls, "ls r1 r0 0", "ls_r1_r0_0"},
     {{ls, r1, r1, 0}, true, ls, "ls r1 r1 0", "ls_r1_r1_0"},
     {{ls, r1, r2, 0}, true, ls, "ls r1 r2 0", "ls_r1_r2_0"},
     {{ls, r1, r3, 0}, true, ls, "ls r1 r3 0", "ls_r1_r3_0"},
     {{ls, r1, r4, 0}, true, ls, "ls r1 r4 0", "ls_r1_r4_0"},
     {{ls, r1, r5, 0}, true, ls, "ls r1 r5 0", "ls_r1_r5_0"},
     {{ls, r1, r6, 0}, true, ls, "ls r1 r6 0", "ls_r1_r6_0"},
     {{ls, r1, r7, 0}, true, ls, "ls r1 r7 0", "ls_r1_r7_0"},
     {{ls, r2, r0, 0}, true, ls, "ls r2 r0 0", "ls_r2_r0_0"},
     {{ls, r2, r1, 0}, true, ls, "ls r2 r1 0", "ls_r2_r1_0"},
     {{ls, r2, r2, 0}, true, ls, "ls r2 r2 0", "ls_r2_r2_0"},
     {{ls, r2, r3, 0}, true, ls, "ls r2 r3 0", "ls_r2_r3_0"},
     {{ls, r2, r4, 0}, true, ls, "ls r2 r4 0", "ls_r2_r4_0"},
     {{ls, r2, r5, 0}, true, ls, "ls r2 r5 0", "ls_r2_r5_0"},
     {{ls, r2, r6, 0}, true, ls, "ls r2 r6 0", "ls_r2_r6_0"},
     {{ls, r2, r7, 0}, true, ls, "ls r2 r7 0", "ls_r2_r7_0"},
     {{ls, r3, r0, 0}, true, ls, "ls r3 r0 0", "ls_r3_r0_0"},
     {{ls, r3, r1, 0}, true, ls, "ls r3 r1 0", "ls_r3_r1_0"},
     {{ls, r3, r2, 0}, true, ls, "ls r3 r2 0", "ls_r3_r2_0"},
     {{ls, r3, r3, 0}, true, ls, "ls r3 r3 0", "ls_r3_r3_0"},
     {{ls, r3, r4, 0}, true, ls, "ls r3 r4 0", "ls_r3_r4_0"},
     {{ls, r3, r5, 0}, true, ls, "ls r3 r5 0", "ls_r3_r5_0"},
     {{ls, r3, r6, 0}, true, ls, "ls r3 r6 0", "ls_r3_r6_0"},
     {{ls, r3, r7, 0}, true, ls, "ls r3 r7 0", "ls_r3_r7_0"},
     {{ls, r4, r0, 0}, true, ls, "ls r4 r0 0", "ls_r4_r0_0"},
     {{ls, r4, r1, 0}, true, ls, "ls r4 r1 0", "ls_r4_r1_0"},
     {{ls, r4, r2, 0}, true, ls, "ls r4 r2 0", "ls_r4_r2_0"},
     {{ls, r4, r3, 0}, true, ls, "ls r4 r3 0", "ls_r4_r3_0"},
     {{ls, r4, r4, 0}, true, ls, "ls r4 r4 0", "ls_r4_r4_0"},
     {{ls, r4, r5, 0}, true, ls, "ls r4 r5 0", "ls_r4_r5_0"},
     {{ls, r4, r6, 0}, true, ls, "ls r4 r6 0", "ls_r4_r6_0"},
     {{ls, r4, r7, 0}, true, ls, "ls r4 r7 0", "ls_r4_r7_0"},
     {{ls, r5, r0, 0}, true, ls, "ls r5 r0 0", "ls_r5_r0_0"},
     {{ls, r5, r1, 0}, true, ls, "ls r5 r1 0", "ls_r5_r1_0"},
     {{ls, r5, r2, 0}, true, ls, "ls r5 r2 0", "ls_r5_r2_0"},
     {{ls, r5, r3, 0}, true, ls, "ls r5 r3 0", "ls_r5_r3_0"},
     {{ls, r5, r4, 0}, true, ls, "ls r5 r4 0", "ls_r5_r4_0"},
     {{ls, r5, r5, 0}, true, ls, "ls r5 r5 0", "ls_r5_r5_0"},
     {{ls, r5, r6, 0}, true, ls, "ls r5 r6 0", "ls_r5_r6_0"},
     {{ls, r5, r7, 0}, true, ls, "ls r5 r7 0", "ls_r5_r7_0"},
     {{ls, r6, r0, 0}, true, ls, "ls r6 r0 0", "ls_r6_r0_0"},
     {{ls, r6, r1, 0}, true, ls, "ls r6 r1 0", "ls_r6_r1_0"},
     {{ls, r6, r2, 0}, true, ls, "ls r6 r2 0", "ls_r6_r2_0"},
     {{ls, r6, r3, 0}, true, ls, "ls r6 r3 0", "ls_r6_r3_0"},
     {{ls, r6, r4, 0}, true, ls, "ls r6 r4 0", "ls_r6_r4_0"},
     {{ls, r6, r5, 0}, true, ls, "ls r6 r5 0", "ls_r6_r5_0"},
     {{ls, r6, r6, 0}, true, ls, "ls r6 r6 0", "ls_r6_r6_0"},
     {{ls, r6, r7, 0}, true, ls, "ls r6 r7 0", "ls_r6_r7_0"},
     {{ls, r7, r0, 0}, true, ls, "ls r7 r0 0", "ls_r7_r0_0"},
     {{ls, r7, r1, 0}, true, ls, "ls r7 r1 0", "ls_r7_r1_0"},
     {{ls, r7, r2, 0}, true, ls, "ls r7 r2 0", "ls_r7_r2_0"},
     {{ls, r7, r3, 0}, true, ls, "ls r7 r3 0", "ls_r7_r3_0"},
     {{ls, r7, r4, 0}, true, ls, "ls r7 r4 0", "ls_r7_r4_0"},
     {{ls, r7, r5, 0}, true, ls, "ls r7 r5 0", "ls_r7_r5_0"},
     {{ls, r7, r6, 0}, true, ls, "ls r7 r6 0", "ls_r7_r6_0"},
     {{ls, r7, r7, 0}, true, ls, "ls r7 r7 0", "ls_r7_r7_0"},
     {{ge, r0, r0, 0}, true, ge, "ge r0 r0 0", "ge_r0_r0_0"},
     {{ge, r0, r1, 0}, true, ge, "ge r0 r1 0", "ge_r0_r1_0"},
     {{ge, r0, r2, 0}, true, ge, "ge r0 r2 0", "ge_r0_r2_0"},
     {{ge, r0, r3, 0}, true, ge, "ge r0 r3 0", "ge_r0_r3_0"},
     {{ge, r0, r4, 0}, true, ge, "ge r0 r4 0", "ge_r0_r4_0"},
     {{ge, r0, r5, 0}, true, ge, "ge r0 r5 0", "ge_r0_r5_0"},
     {{ge, r0, r6, 0}, true, ge, "ge r0 r6 0", "ge_r0_r6_0"},
     {{ge, r0, r7, 0}, true, ge, "ge r0 r7 0", "ge_r0_r7_0"},
     {{ge, r1, r0, 0}, true, ge, "ge r1 r0 0", "ge_r1_r0_0"},
     {{ge, r1, r1, 0}, true, ge, "ge r1 r1 0", "ge_r1_r1_0"},
     {{ge, r1, r2, 0}, true, ge, "ge r1 r2 0", "ge_r1_r2_0"},
     {{ge, r1, r3, 0}, true, ge, "ge r1 r3 0", "ge_r1_r3_0"},
     {{ge, r1, r4, 0}, true, ge, "ge r1 r4 0", "ge_r1_r4_0"},
     {{ge, r1, r5, 0}, true, ge, "ge r1 r5 0", "ge_r1_r5_0"},
     {{ge, r1, r6, 0}, true, ge, "ge r1 r6 0", "ge_r1_r6_0"},
     {{ge, r1, r7, 0}, true, ge, "ge r1 r7 0", "ge_r1_r7_0"},
     {{ge, r2, r0, 0}, true, ge, "ge r2 r0 0", "ge_r2_r0_0"},
     {{ge, r2, r1, 0}, true, ge, "ge r2 r1 0", "ge_r2_r1_0"},
     {{ge, r2, r2, 0}, true, ge, "ge r2 r2 0", "ge_r2_r2_0"},
     {{ge, r2, r3, 0}, true, ge, "ge r2 r3 0", "ge_r2_r3_0"},
     {{ge, r2, r4, 0}, true, ge, "ge r2 r4 0", "ge_r2_r4_0"},
     {{ge, r2, r5, 0}, true, ge, "ge r2 r5 0", "ge_r2_r5_0"},
     {{ge, r2, r6, 0}, true, ge, "ge r2 r6 0", "ge_r2_r6_0"},
     {{ge, r2, r7, 0}, true, ge, "ge r2 r7 0", "ge_r2_r7_0"},
     {{ge, r3, r0, 0}, true, ge, "ge r3 r0 0", "ge_r3_r0_0"},
     {{ge, r3, r1, 0}, true, ge, "ge r3 r1 0", "ge_r3_r1_0"},
     {{ge, r3, r2, 0}, true, ge, "ge r3 r2 0", "ge_r3_r2_0"},
     {{ge, r3, r3, 0}, true, ge, "ge r3 r3 0", "ge_r3_r3_0"},
     {{ge, r3, r4, 0}, true, ge, "ge r3 r4 0", "ge_r3_r4_0"},
     {{ge, r3, r5, 0}, true, ge, "ge r3 r5 0", "ge_r3_r5_0"},
     {{ge, r3, r6, 0}, true, ge, "ge r3 r6 0", "ge_r3_r6_0"},
     {{ge, r3, r7, 0}, true, ge, "ge r3 r7 0", "ge_r3_r7_0"},
     {{ge, r4, r0, 0}, true, ge, "ge r4 r0 0", "ge_r4_r0_0"},
     {{ge, r4, r1, 0}, true, ge, "ge r4 r1 0", "ge_r4_r1_0"},
     {{ge, r4, r2, 0}, true, ge, "ge r4 r2 0", "ge_r4_r2_0"},
     {{ge, r4, r3, 0}, true, ge, "ge r4 r3 0", "ge_r4_r3_0"},
     {{ge, r4, r4, 0}, true, ge, "ge r4 r4 0", "ge_r4_r4_0"},
     {{ge, r4, r5, 0}, true, ge, "ge r4 r5 0", "ge_r4_r5_0"},
     {{ge, r4, r6, 0}, true, ge, "ge r4 r6 0", "ge_r4_r6_0"},
     {{ge, r4, r7, 0}, true, ge, "ge r4 r7 0", "ge_r4_r7_0"},
     {{ge, r5, r0, 0}, true, ge, "ge r5 r0 0", "ge_r5_r0_0"},
     {{ge, r5, r1, 0}, true, ge, "ge r5 r1 0", "ge_r5_r1_0"},
     {{ge, r5, r2, 0}, true, ge, "ge r5 r2 0", "ge_r5_r2_0"},
     {{ge, r5, r3, 0}, true, ge, "ge r5 r3 0", "ge_r5_r3_0"},
     {{ge, r5, r4, 0}, true, ge, "ge r5 r4 0", "ge_r5_r4_0"},
     {{ge, r5, r5, 0}, true, ge, "ge r5 r5 0", "ge_r5_r5_0"},
     {{ge, r5, r6, 0}, true, ge, "ge r5 r6 0", "ge_r5_r6_0"},
     {{ge, r5, r7, 0}, true, ge, "ge r5 r7 0", "ge_r5_r7_0"},
     {{ge, r6, r0, 0}, true, ge, "ge r6 r0 0", "ge_r6_r0_0"},
     {{ge, r6, r1, 0}, true, ge, "ge r6 r1 0", "ge_r6_r1_0"},
     {{ge, r6, r2, 0}, true, ge, "ge r6 r2 0", "ge_r6_r2_0"},
     {{ge, r6, r3, 0}, true, ge, "ge r6 r3 0", "ge_r6_r3_0"},
     {{ge, r6, r4, 0}, true, ge, "ge r6 r4 0", "ge_r6_r4_0"},
     {{ge, r6, r5, 0}, true, ge, "ge r6 r5 0", "ge_r6_r5_0"},
     {{ge, r6, r6, 0}, true, ge, "ge r6 r6 0", "ge_r6_r6_0"},
     {{ge, r6, r7, 0}, true, ge, "ge r6 r7 0", "ge_r6_r7_0"},
     {{ge, r7, r0, 0}, true, ge, "ge r7 r0 0", "ge_r7_r0_0"},
     {{ge, r7, r1, 0}, true, ge, "ge r7 r1 0", "ge_r7_r1_0"},
     {{ge, r7, r2, 0}, true, ge, "ge r7 r2 0", "ge_r7_r2_0"},
     {{ge, r7, r3, 0}, true, ge, "ge r7 r3 0", "ge_r7_r3_0"},
     {{ge, r7, r4, 0}, true, ge, "ge r7 r4 0", "ge_r7_r4_0"},
     {{ge, r7, r5, 0}, true, ge, "ge r7 r5 0", "ge_r7_r5_0"},
     {{ge, r7, r6, 0}, true, ge, "ge r7 r6 0", "ge_r7_r6_0"},
     {{ge, r7, r7, 0}, true, ge, "ge r7 r7 0", "ge_r7_r7_0"},
     {{lt, r0, r0, 0}, true, lt, "lt r0 r0 0", "lt_r0_r0_0"},
     {{lt, r0, r1, 0}, true, lt, "lt r0 r1 0", "lt_r0_r1_0"},
     {{lt, r0, r2, 0}, true, lt, "lt r0 r2 0", "lt_r0_r2_0"},
     {{lt, r0, r3, 0}, true, lt, "lt r0 r3 0", "lt_r0_r3_0"},
     {{lt, r0, r4, 0}, true, lt, "lt r0 r4 0", "lt_r0_r4_0"},
     {{lt, r0, r5, 0}, true, lt, "lt r0 r5 0", "lt_r0_r5_0"},
     {{lt, r0, r6, 0}, true, lt, "lt r0 r6 0", "lt_r0_r6_0"},
     {{lt, r0, r7, 0}, true, lt, "lt r0 r7 0", "lt_r0_r7_0"},
     {{lt, r1, r0, 0}, true, lt, "lt r1 r0 0", "lt_r1_r0_0"},
     {{lt, r1, r1, 0}, true, lt, "lt r1 r1 0", "lt_r1_r1_0"},
     {{lt, r1, r2, 0}, true, lt, "lt r1 r2 0", "lt_r1_r2_0"},
     {{lt, r1, r3, 0}, true, lt, "lt r1 r3 0", "lt_r1_r3_0"},
     {{lt, r1, r4, 0}, true, lt, "lt r1 r4 0", "lt_r1_r4_0"},
     {{lt, r1, r5, 0}, true, lt, "lt r1 r5 0", "lt_r1_r5_0"},
     {{lt, r1, r6, 0}, true, lt, "lt r1 r6 0", "lt_r1_r6_0"},
     {{lt, r1, r7, 0}, true, lt, "lt r1 r7 0", "lt_r1_r7_0"},
     {{lt, r2, r0, 0}, true, lt, "lt r2 r0 0", "lt_r2_r0_0"},
     {{lt, r2, r1, 0}, true, lt, "lt r2 r1 0", "lt_r2_r1_0"},
     {{lt, r2, r2, 0}, true, lt, "lt r2 r2 0", "lt_r2_r2_0"},
     {{lt, r2, r3, 0}, true, lt, "lt r2 r3 0", "lt_r2_r3_0"},
     {{lt, r2, r4, 0}, true, lt, "lt r2 r4 0", "lt_r2_r4_0"},
     {{lt, r2, r5, 0}, true, lt, "lt r2 r5 0", "lt_r2_r5_0"},
     {{lt, r2, r6, 0}, true, lt, "lt r2 r6 0", "lt_r2_r6_0"},
     {{lt, r2, r7, 0}, true, lt, "lt r2 r7 0", "lt_r2_r7_0"},
     {{lt, r3, r0, 0}, true, lt, "lt r3 r0 0", "lt_r3_r0_0"},
     {{lt, r3, r1, 0}, true, lt, "lt r3 r1 0", "lt_r3_r1_0"},
     {{lt, r3, r2, 0}, true, lt, "lt r3 r2 0", "lt_r3_r2_0"},
     {{lt, r3, r3, 0}, true, lt, "lt r3 r3 0", "lt_r3_r3_0"},
     {{lt, r3, r4, 0}, true, lt, "lt r3 r4 0", "lt_r3_r4_0"},
     {{lt, r3, r5, 0}, true, lt, "lt r3 r5 0", "lt_r3_r5_0"},
     {{lt, r3, r6, 0}, true, lt, "lt r3 r6 0", "lt_r3_r6_0"},
     {{lt, r3, r7, 0}, true, lt, "lt r3 r7 0", "lt_r3_r7_0"},
     {{lt, r4, r0, 0}, true, lt, "lt r4 r0 0", "lt_r4_r0_0"},
     {{lt, r4, r1, 0}, true, lt, "lt r4 r1 0", "lt_r4_r1_0"},
     {{lt, r4, r2, 0}, true, lt, "lt r4 r2 0", "lt_r4_r2_0"},
     {{lt, r4, r3, 0}, true, lt, "lt r4 r3 0", "lt_r4_r3_0"},
     {{lt, r4, r4, 0}, true, lt, "lt r4 r4 0", "lt_r4_r4_0"},
     {{lt, r4, r5, 0}, true, lt, "lt r4 r5 0", "lt_r4_r5_0"},
     {{lt, r4, r6, 0}, true, lt, "lt r4 r6 0", "lt_r4_r6_0"},
     {{lt, r4, r7, 0}, true, lt, "lt r4 r7 0", "lt_r4_r7_0"},
     {{lt, r5, r0, 0}, true, lt, "lt r5 r0 0", "lt_r5_r0_0"},
     {{lt, r5, r1, 0}, true, lt, "lt r5 r1 0", "lt_r5_r1_0"},
     {{lt, r5, r2, 0}, true, lt, "lt r5 r2 0", "lt_r5_r2_0"},
     {{lt, r5, r3, 0}, true, lt, "lt r5 r3 0", "lt_r5_r3_0"},
     {{lt, r5, r4, 0}, true, lt, "lt r5 r4 0", "lt_r5_r4_0"},
     {{lt, r5, r5, 0}, true, lt, "lt r5 r5 0", "lt_r5_r5_0"},
     {{lt, r5, r6, 0}, true, lt, "lt r5 r6 0", "lt_r5_r6_0"},
     {{lt, r5, r7, 0}, true, lt, "lt r5 r7 0", "lt_r5_r7_0"},
     {{lt, r6, r0, 0}, true, lt, "lt r6 r0 0", "lt_r6_r0_0"},
     {{lt, r6, r1, 0}, true, lt, "lt r6 r1 0", "lt_r6_r1_0"},
     {{lt, r6, r2, 0}, true, lt, "lt r6 r2 0", "lt_r6_r2_0"},
     {{lt, r6, r3, 0}, true, lt, "lt r6 r3 0", "lt_r6_r3_0"},
     {{lt, r6, r4, 0}, true, lt, "lt r6 r4 0", "lt_r6_r4_0"},
     {{lt, r6, r5, 0}, true, lt, "lt r6 r5 0", "lt_r6_r5_0"},
     {{lt, r6, r6, 0}, true, lt, "lt r6 r6 0", "lt_r6_r6_0"},
     {{lt, r6, r7, 0}, true, lt, "lt r6 r7 0", "lt_r6_r7_0"},
     {{lt, r7, r0, 0}, true, lt, "lt r7 r0 0", "lt_r7_r0_0"},
     {{lt, r7, r1, 0}, true, lt, "lt r7 r1 0", "lt_r7_r1_0"},
     {{lt, r7, r2, 0}, true, lt, "lt r7 r2 0", "lt_r7_r2_0"},
     {{lt, r7, r3, 0}, true, lt, "lt r7 r3 0", "lt_r7_r3_0"},
     {{lt, r7, r4, 0}, true, lt, "lt r7 r4 0", "lt_r7_r4_0"},
     {{lt, r7, r5, 0}, true, lt, "lt r7 r5 0", "lt_r7_r5_0"},
     {{lt, r7, r6, 0}, true, lt, "lt r7 r6 0", "lt_r7_r6_0"},
     {{lt, r7, r7, 0}, true, lt, "lt r7 r7 0", "lt_r7_r7_0"},
     {{gt, r0, r0, 0}, true, gt, "gt r0 r0 0", "gt_r0_r0_0"},
     {{gt, r0, r1, 0}, true, gt, "gt r0 r1 0", "gt_r0_r1_0"},
     {{gt, r0, r2, 0}, true, gt, "gt r0 r2 0", "gt_r0_r2_0"},
     {{gt, r0, r3, 0}, true, gt, "gt r0 r3 0", "gt_r0_r3_0"},
     {{gt, r0, r4, 0}, true, gt, "gt r0 r4 0", "gt_r0_r4_0"},
     {{gt, r0, r5, 0}, true, gt, "gt r0 r5 0", "gt_r0_r5_0"},
     {{gt, r0, r6, 0}, true, gt, "gt r0 r6 0", "gt_r0_r6_0"},
     {{gt, r0, r7, 0}, true, gt, "gt r0 r7 0", "gt_r0_r7_0"},
     {{gt, r1, r0, 0}, true, gt, "gt r1 r0 0", "gt_r1_r0_0"},
     {{gt, r1, r1, 0}, true, gt, "gt r1 r1 0", "gt_r1_r1_0"},
     {{gt, r1, r2, 0}, true, gt, "gt r1 r2 0", "gt_r1_r2_0"},
     {{gt, r1, r3, 0}, true, gt, "gt r1 r3 0", "gt_r1_r3_0"},
     {{gt, r1, r4, 0}, true, gt, "gt r1 r4 0", "gt_r1_r4_0"},
     {{gt, r1, r5, 0}, true, gt, "gt r1 r5 0", "gt_r1_r5_0"},
     {{gt, r1, r6, 0}, true, gt, "gt r1 r6 0", "gt_r1_r6_0"},
     {{gt, r1, r7, 0}, true, gt, "gt r1 r7 0", "gt_r1_r7_0"},
     {{gt, r2, r0, 0}, true, gt, "gt r2 r0 0", "gt_r2_r0_0"},
     {{gt, r2, r1, 0}, true, gt, "gt r2 r1 0", "gt_r2_r1_0"},
     {{gt, r2, r2, 0}, true, gt, "gt r2 r2 0", "gt_r2_r2_0"},
     {{gt, r2, r3, 0}, true, gt, "gt r2 r3 0", "gt_r2_r3_0"},
     {{gt, r2, r4, 0}, true, gt, "gt r2 r4 0", "gt_r2_r4_0"},
     {{gt, r2, r5, 0}, true, gt, "gt r2 r5 0", "gt_r2_r5_0"},
     {{gt, r2, r6, 0}, true, gt, "gt r2 r6 0", "gt_r2_r6_0"},
     {{gt, r2, r7, 0}, true, gt, "gt r2 r7 0", "gt_r2_r7_0"},
     {{gt, r3, r0, 0}, true, gt, "gt r3 r0 0", "gt_r3_r0_0"},
     {{gt, r3, r1, 0}, true, gt, "gt r3 r1 0", "gt_r3_r1_0"},
     {{gt, r3, r2, 0}, true, gt, "gt r3 r2 0", "gt_r3_r2_0"},
     {{gt, r3, r3, 0}, true, gt, "gt r3 r3 0", "gt_r3_r3_0"},
     {{gt, r3, r4, 0}, true, gt, "gt r3 r4 0", "gt_r3_r4_0"},
     {{gt, r3, r5, 0}, true, gt, "gt r3 r5 0", "gt_r3_r5_0"},
     {{gt, r3, r6, 0}, true, gt, "gt r3 r6 0", "gt_r3_r6_0"},
     {{gt, r3, r7, 0}, true, gt, "gt r3 r7 0", "gt_r3_r7_0"},
     {{gt, r4, r0, 0}, true, gt, "gt r4 r0 0", "gt_r4_r0_0"},
     {{gt, r4, r1, 0}, true, gt, "gt r4 r1 0", "gt_r4_r1_0"},
     {{gt, r4, r2, 0}, true, gt, "gt r4 r2 0", "gt_r4_r2_0"},
     {{gt, r4, r3, 0}, true, gt, "gt r4 r3 0", "gt_r4_r3_0"},
     {{gt, r4, r4, 0}, true, gt, "gt r4 r4 0", "gt_r4_r4_0"},
     {{gt, r4, r5, 0}, true, gt, "gt r4 r5 0", "gt_r4_r5_0"},
     {{gt, r4, r6, 0}, true, gt, "gt r4 r6 0", "gt_r4_r6_0"},
     {{gt, r4, r7, 0}, true, gt, "gt r4 r7 0", "gt_r4_r7_0"},
     {{gt, r5, r0, 0}, true, gt, "gt r5 r0 0", "gt_r5_r0_0"},
     {{gt, r5, r1, 0}, true, gt, "gt r5 r1 0", "gt_r5_r1_0"},
     {{gt, r5, r2, 0}, true, gt, "gt r5 r2 0", "gt_r5_r2_0"},
     {{gt, r5, r3, 0}, true, gt, "gt r5 r3 0", "gt_r5_r3_0"},
     {{gt, r5, r4, 0}, true, gt, "gt r5 r4 0", "gt_r5_r4_0"},
     {{gt, r5, r5, 0}, true, gt, "gt r5 r5 0", "gt_r5_r5_0"},
     {{gt, r5, r6, 0}, true, gt, "gt r5 r6 0", "gt_r5_r6_0"},
     {{gt, r5, r7, 0}, true, gt, "gt r5 r7 0", "gt_r5_r7_0"},
     {{gt, r6, r0, 0}, true, gt, "gt r6 r0 0", "gt_r6_r0_0"},
     {{gt, r6, r1, 0}, true, gt, "gt r6 r1 0", "gt_r6_r1_0"},
     {{gt, r6, r2, 0}, true, gt, "gt r6 r2 0", "gt_r6_r2_0"},
     {{gt, r6, r3, 0}, true, gt, "gt r6 r3 0", "gt_r6_r3_0"},
     {{gt, r6, r4, 0}, true, gt, "gt r6 r4 0", "gt_r6_r4_0"},
     {{gt, r6, r5, 0}, true, gt, "gt r6 r5 0", "gt_r6_r5_0"},
     {{gt, r6, r6, 0}, true, gt, "gt r6 r6 0", "gt_r6_r6_0"},
     {{gt, r6, r7, 0}, true, gt, "gt r6 r7 0", "gt_r6_r7_0"},
     {{gt, r7, r0, 0}, true, gt, "gt r7 r0 0", "gt_r7_r0_0"},
     {{gt, r7, r1, 0}, true, gt, "gt r7 r1 0", "gt_r7_r1_0"},
     {{gt, r7, r2, 0}, true, gt, "gt r7 r2 0", "gt_r7_r2_0"},
     {{gt, r7, r3, 0}, true, gt, "gt r7 r3 0", "gt_r7_r3_0"},
     {{gt, r7, r4, 0}, true, gt, "gt r7 r4 0", "gt_r7_r4_0"},
     {{gt, r7, r5, 0}, true, gt, "gt r7 r5 0", "gt_r7_r5_0"},
     {{gt, r7, r6, 0}, true, gt, "gt r7 r6 0", "gt_r7_r6_0"},
     {{gt, r7, r7, 0}, true, gt, "gt r7 r7 0", "gt_r7_r7_0"},
     {{le, r0, r0, 0}, true, le, "le r0 r0 0", "le_r0_r0_0"},
     {{le, r0, r1, 0}, true, le, "le r0 r1 0", "le_r0_r1_0"},
     {{le, r0, r2, 0}, true, le, "le r0 r2 0", "le_r0_r2_0"},
     {{le, r0, r3, 0}, true, le, "le r0 r3 0", "le_r0_r3_0"},
     {{le, r0, r4, 0}, true, le, "le r0 r4 0", "le_r0_r4_0"},
     {{le, r0, r5, 0}, true, le, "le r0 r5 0", "le_r0_r5_0"},
     {{le, r0, r6, 0}, true, le, "le r0 r6 0", "le_r0_r6_0"},
     {{le, r0, r7, 0}, true, le, "le r0 r7 0", "le_r0_r7_0"},
     {{le, r1, r0, 0}, true, le, "le r1 r0 0", "le_r1_r0_0"},
     {{le, r1, r1, 0}, true, le, "le r1 r1 0", "le_r1_r1_0"},
     {{le, r1, r2, 0}, true, le, "le r1 r2 0", "le_r1_r2_0"},
     {{le, r1, r3, 0}, true, le, "le r1 r3 0", "le_r1_r3_0"},
     {{le, r1, r4, 0}, true, le, "le r1 r4 0", "le_r1_r4_0"},
     {{le, r1, r5, 0}, true, le, "le r1 r5 0", "le_r1_r5_0"},
     {{le, r1, r6, 0}, true, le, "le r1 r6 0", "le_r1_r6_0"},
     {{le, r1, r7, 0}, true, le, "le r1 r7 0", "le_r1_r7_0"},
     {{le, r2, r0, 0}, true, le, "le r2 r0 0", "le_r2_r0_0"},
     {{le, r2, r1, 0}, true, le, "le r2 r1 0", "le_r2_r1_0"},
     {{le, r2, r2, 0}, true, le, "le r2 r2 0", "le_r2_r2_0"},
     {{le, r2, r3, 0}, true, le, "le r2 r3 0", "le_r2_r3_0"},
     {{le, r2, r4, 0}, true, le, "le r2 r4 0", "le_r2_r4_0"},
     {{le, r2, r5, 0}, true, le, "le r2 r5 0", "le_r2_r5_0"},
     {{le, r2, r6, 0}, true, le, "le r2 r6 0", "le_r2_r6_0"},
     {{le, r2, r7, 0}, true, le, "le r2 r7 0", "le_r2_r7_0"},
     {{le, r3, r0, 0}, true, le, "le r3 r0 0", "le_r3_r0_0"},
     {{le, r3, r1, 0}, true, le, "le r3 r1 0", "le_r3_r1_0"},
     {{le, r3, r2, 0}, true, le, "le r3 r2 0", "le_r3_r2_0"},
     {{le, r3, r3, 0}, true, le, "le r3 r3 0", "le_r3_r3_0"},
     {{le, r3, r4, 0}, true, le, "le r3 r4 0", "le_r3_r4_0"},
     {{le, r3, r5, 0}, true, le, "le r3 r5 0", "le_r3_r5_0"},
     {{le, r3, r6, 0}, true, le, "le r3 r6 0", "le_r3_r6_0"},
     {{le, r3, r7, 0}, true, le, "le r3 r7 0", "le_r3_r7_0"},
     {{le, r4, r0, 0}, true, le, "le r4 r0 0", "le_r4_r0_0"},
     {{le, r4, r1, 0}, true, le, "le r4 r1 0", "le_r4_r1_0"},
     {{le, r4, r2, 0}, true, le, "le r4 r2 0", "le_r4_r2_0"},
     {{le, r4, r3, 0}, true, le, "le r4 r3 0", "le_r4_r3_0"},
     {{le, r4, r4, 0}, true, le, "le r4 r4 0", "le_r4_r4_0"},
     {{le, r4, r5, 0}, true, le, "le r4 r5 0", "le_r4_r5_0"},
     {{le, r4, r6, 0}, true, le, "le r4 r6 0", "le_r4_r6_0"},
     {{le, r4, r7, 0}, true, le, "le r4 r7 0", "le_r4_r7_0"},
     {{le, r5, r0, 0}, true, le, "le r5 r0 0", "le_r5_r0_0"},
     {{le, r5, r1, 0}, true, le, "le r5 r1 0", "le_r5_r1_0"},
     {{le, r5, r2, 0}, true, le, "le r5 r2 0", "le_r5_r2_0"},
     {{le, r5, r3, 0}, true, le, "le r5 r3 0", "le_r5_r3_0"},
     {{le, r5, r4, 0}, true, le, "le r5 r4 0", "le_r5_r4_0"},
     {{le, r5, r5, 0}, true, le, "le r5 r5 0", "le_r5_r5_0"},
     {{le, r5, r6, 0}, true, le, "le r5 r6 0", "le_r5_r6_0"},
     {{le, r5, r7, 0}, true, le, "le r5 r7 0", "le_r5_r7_0"},
     {{le, r6, r0, 0}, true, le, "le r6 r0 0", "le_r6_r0_0"},
     {{le, r6, r1, 0}, true, le, "le r6 r1 0", "le_r6_r1_0"},
     {{le, r6, r2, 0}, true, le, "le r6 r2 0", "le_r6_r2_0"},
     {{le, r6, r3, 0}, true, le, "le r6 r3 0", "le_r6_r3_0"},
     {{le, r6, r4, 0}, true, le, "le r6 r4 0", "le_r6_r4_0"},
     {{le, r6, r5, 0}, true, le, "le r6 r5 0", "le_r6_r5_0"},
     {{le, r6, r6, 0}, true, le, "le r6 r6 0", "le_r6_r6_0"},
     {{le, r6, r7, 0}, true, le, "le r6 r7 0", "le_r6_r7_0"},
     {{le, r7, r0, 0}, true, le, "le r7 r0 0", "le_r7_r0_0"},
     {{le, r7, r1, 0}, true, le, "le r7 r1 0", "le_r7_r1_0"},
     {{le, r7, r2, 0}, true, le, "le r7 r2 0", "le_r7_r2_0"},
     {{le, r7, r3, 0}, true, le, "le r7 r3 0", "le_r7_r3_0"},
     {{le, r7, r4, 0}, true, le, "le r7 r4 0", "le_r7_r4_0"},
     {{le, r7, r5, 0}, true, le, "le r7 r5 0", "le_r7_r5_0"},
     {{le, r7, r6, 0}, true, le, "le r7 r6 0", "le_r7_r6_0"},
     {{le, r7, r7, 0}, true, le, "le r7 r7 0", "le_r7_r7_0"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rdlow-rnlow-operand-immediate-zero-in-it-block-rsb-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RDLOW_RNLOW_OPERAND_IMMEDIATE_ZERO_IN_IT_"    \
      "BLOCK_" #mnemonic "_T32",                                            \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
