;
; PedroM - Operating System for Ti-89/Ti-92+/V200.
; Copyright (C) 2003, 2004, 2005 Patrick Pelissier
;
; This program is free software ; you can redistribute it and/or modify it under the
; terms of the GNU General Public License as published by the Free Software Foundation;
; either version 2 of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; See the GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License along with this program;
; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Shell Input Output Interface		***
;***                                                            ***
;******************************************************************

; Display a return
DispReturn:
	pea	Return_str(pc)
	bsr	printf
	bra.s	DispAddqReturn

; Display '2 args' error
DispArg2Files:
	pea	Arg2_str(pc)
	bra.s	DispErrorPrintf

; Display 'arg: FileName' error
DispArgFileName:
	pea	Arg1_str(pc)
	bra.s	DispErrorPrintf

; Display 'Error: Argument number'
DispArgNumber:
	pea	ArgNumber_str(pc)
DispErrorPrintf
	bsr	errorPrintf
DispAddqReturn:
	addq.l	#4,a7
	rts	

; Display 'Confirm' and input a string from he user.
; Is the string is 'yes', it returns -1 else 0
; Out: d0.b
Confirm:
	pea	Confirmation_str(pc)
	bsr	printf				; Print 'Confirmation'
	subq.l	#4,a7
	bsr	GKeyFlush			; Flush Key Buffer
	move.l	a7,a0
	moveq	#4,d3
	bsr.s	InputString
	clr.w	d0
	cmp.b	#'y',(a0)+
	bne.s	\exit
	cmp.b	#'e',(a0)+
	bne.s	\exit
	cmp.b	#'s',(a0)+
	bne.s	\exit
	tst.b	(a0)+
	seq.b	d0
\exit	addq.l	#8,a7
	rts

; Get a key using GetKey.
; Enable the cursor during the waiting of the key.
; Destroy/Return: 
;	d0.w = Key
GetCursorKey:
	bsr	CU_start
	bsr	GetKey
	move.w	d0,-(a7)
	bsr	CU_stop
	move.w	(a7)+,d0
	rts
	
; Put a string on the screen
; In:
;	a0 -> String
;	d0.w = x
;	d1.w = y
; Out :
;	nothing
; Destroy:
;	nothing
DisplayString:
	movem.l	d0-d2/a0-a1,-(a7)
	move.w	#4,-(a7)
	pea	(a0)
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	bsr	DrawStr
	lea     10(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	rts


; Input a string
; Support FunctionKey / History Command / Cursor / Completion / HelpKeys / Switching
; In :
;	d3.w = maxchar
;	a0.l -> String to fill (maxchar+4)
; Out:
;	d0.w = string lenght
; Destroy :
;	d0
InputString:
	movem.l	d1-d6/a0-a3,-(a7)
	moveq	#-1,d5				; History Index
	move.l	a0,a1				; a1 -> Current char
	clr.b	(a0)				; Null string
	clr.w	d4				; 0 char
	move.w	CURRENT_POINT_X,d6
\loop:	jsr	StrWidthFromTo			; Calculate the length of the string
	add.w	d6,d0				; and X position
	move.w	d0,CURRENT_POINT_X		; Update CURSOR X
	pea	(a1)
\EndLoop:	tst.b	(a1)+
		bne.s	\EndLoop
	pea	(a1)
	move.b	#' ',-1(a1)			; 1 Space
	move.b	#' ',(a1)+			; 2 Spaces
	move.b	#' ',(a1)+			; 3 Spaces
	clr.b	(a1)+				; Null string
	move.w	d6,d0				; X pos
	move.w	CURRENT_POINT_Y,d1		; Y pos
	bsr.s	DisplayString			; Display string
	move.l	(a7)+,a1
	clr.b	-(a1)
	move.l	(a7)+,a1	
	bsr.s	GetCursorKey
	cmp.w	#KEY_ENTER,d0			;Enter ?
	beq	\Enter
	cmp.w	#KEY_CLEAR,d0			;Clear ?
	beq	\Clear
	cmp.w	#KEY_BACK,d0
	beq.s	\Del
	cmp.w	#KEY_ESC,d0			;ESC ?
	beq.s	\Esc
	cmp.w	#KEY_UP,d0			;Up ?
	beq	\Up
	cmp.w	#KEY_DOWN,d0			;Down ?
	beq	\Dn
	cmp.w	#KEY_LEFT,d0			;Left ?
	beq	\Left
	cmp.w	#KEY_RIGHT,d0			;Right ?
	beq	\Right
	cmp.w	#KEY_LEFT+KEY_2ND,d0		;2nd+Left ?
	beq	\Left2
	cmp.w	#KEY_RIGHT+KEY_2ND,d0		;2nd+Right?
	beq	\Right2
	cmp.w	#HELPKEYS_KEY,d0
	beq	\DisplayHelpKeys
	cmpi.w	#KEY_ON,d0			; Break ?
	beq	\Completion
	cmpi.w	#KEY_F1,d0			; F1-F8 ?
	blt.s	\NoFKey
		cmpi.w	#KEY_F8,d0
		ble.s	\FKey
\NoFKey	cmp.w	#255,d0				;Charactre invalide ?
	bhi	\CheckSwitch
	bsr.s	\AddChar
	bra	\loop

\Del:	cmp.l	a0,a1
	beq	\loop
	subq.w	#1,d4
	;memmove(a1+1, a1, until a1 = zero)
	; a1 -> x y z 0 t
	subq.l	#1,a1
	move.l	a1,a2
\DelCharLoop:	move.b	1(a2),(a2)+
		bne.s	\DelCharLoop
	bra	\loop
\Esc:	clr.w	d4		; No char
	clr.b	(a0)		; Void string
\Enter:	bsr	DispReturn	; Disp final return
	move.w	d4,d0		; Number of Char
	movem.l (a7)+,d1-d6/a0-a3
	rts
	
; Add a char in a1
\AddChar:
	pea	(a2)
	cmp.w	d3,d4				; NbrChar < Maxchar ?
	beq.s	\MaxCharRts
	addq.w	#1,d4				; NbrChar++
	;memmove(a1, a1+1, until a1 = zero)
	; a1 -> x y z 0 t
	move.l	a1,a2
\AddCharLoop1:	tst.b	(a2)+
		bne.s	\AddCharLoop1
	; a2 -> t
	subq.l	#1,a2
\AddCharLoop2	move.b	(a2),1(a2)
		subq.l	#1,a2
		cmp.l	a1,a2
		bge.s	\AddCharLoop2
	move.b	d0,(a1)+			; Save new char
\MaxCharRts
	move.l	(a7)+,a2
	rts
	
; Function Key support (Or Fast Key ?)
\FKey:	sub.w	#KEY_F1-1,d0
	; Search for 'system\fkey[d0+1]'
	movem.l	d0-d2/a0-a1,-(a7)
	lea	-20(a7),a7		; Stack Frame
	move.w	d0,-(a7)
	pea	FKeyFormat_str(pc)
	pea	6(a7)
	bsr	sprintf_redirect	; 6(a7) = 'fkey1'
	lea	10(a7),a2
	bsr	getenv			; Get environement variable
	lea	30(a7),a7
	move.l	a0,a2
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,d0
	beq	\loop
	tst.b	(a2)
	beq	\loop
\FLoop		move.b	(a2)+,d0
		beq	\loop
		cmpi.b	#SHELL_AUTO_CHAR,d0
		beq	\Enter			; End of command
		bsr	\AddChar
		bra.s	\FLoop

\Left:	cmp.l	a0,a1
	beq	\loop
	subq.l	#1,a1
	bra	\loop
\Right:	tst.b	(a1)
	beq	\loop
	addq.l	#1,a1
	bra	\loop
\Left2:	cmp.l	a0,a1
	beq	\loop
	subq.l	#1,a1
	bra.s	\Left2
\Right2:
	tst.b	(a1)
	beq	\loop
	addq.l	#1,a1
	bra.s	\Right2

; Clear the entire Input Line
\Clear:
	tst.b	(a0)
	beq.s	\ClearCommand
	moveq	#-1,d5			; Reset History index
	bsr.s	\Clean
	bra	\loop
\ClearCommand:
	move.l	a0,a1
	move.b	#'c',(a1)+
	move.b	#'l',(a1)+
	move.b	#'e',(a1)+
	move.b	#'a',(a1)+
	move.b	#'r',(a1)+
	clr.b	(a1)
	bra	\Enter
	
; Routine which clears the Input Line
\Clean	move.w	d4,d0
	beq.s	\CleanEnd		; No characters
	pea	(a0)
	subq.l	#4,a7
	move.l	a7,a0
	move.b	d6,(a0)+
	move.b	CURRENT_POINT_Y+1,(a0)+
	move.b	#SCR_WIDTH-1,(a0)+
	move.b	CURRENT_POINT_Y+1,(a0)
	addq.b	#USED_FONT*2+6,(a0)
	move.w	#A_REVERSE,-(a7)
	pea	ScrRect(pc)
	pea	-3(a0)
	bsr	ScrRectFill
	lea	14(a7),a7
	move.l	(a7)+,a0
	move.l	a0,a1			; Reset string ptr
	clr.b	(a0)
	clr.w	d4			; Reset length
\CleanEnd
	rts

; History
\Up:	cmpi.w	#SHELL_HISTORY,d5
	bge	\loop
	addq.w	#1,d5
	bra.s	\CopyHistory
\Dn:	tst.w	d5
	ble.s	\Clear
	subq.w	#1,d5
\CopyHistory
	lea	SHELL_HISTORY_TAB,a3
	move.w	d5,d0
	mulu.w	#SHELL_MAX_LINE+2,d0
	adda.l	d0,a3					; Saved String
	tst.b	(a3)					; If no pasted string
	beq.s	\FixIndex				; Return
	bsr.s	\Clean
\PasteLoop	move.b	(a3)+,d0			; Read char
		beq.s	\Loop2				; Check if the string is finished
		bsr	\AddChar
		bra.s	\PasteLoop
\FixIndex
	subq.w	#1,d5					; Too high
\Loop2	bra	\loop

; Completion
\Completion:
	bsr.s	Completion
	bra	\loop

; Display HelpKeys
\DisplayHelpKeys
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	CURRENT_POINT_X,-(a7)
	bsr	HelpKeys
	move.l	(a7)+,CURRENT_POINT_X
	movem.l	(a7)+,d0-d7/a0-a6
	bra	\loop
	
; Switch Task
\CheckSwitch:
	movem.l	d0-d2/a0-a1,-(a7)
	lea	ShellInput_str(pc),a0
	jsr	PID_CheckSwitch
	movem.l	(a7)+,d0-d2/a0-a1
	bra	\loop

; Completion
; It is really written in 'Quick & Dirty' style.
; Not good, but nevertheless it works well...
; The chars are put inside the KeyBuffer, so there isn't any output.
; In:
;	a0 -> Start of string
;	a1 -> End of string
Completion:
	move.b	(a1),-(a7)				; Save Last Char (The buffer is in RAM)
	movem.l	d0-d7/a0-a6,-(a7)
	; Create a PopUp
	movem.l	a0/a1,-(a7)
	clr.w	-(a7)					; Auto-compute Height
	clr.l	-(a7)					; No title
	jsr	PopupNew				; New PopUp
	addq.l	#6,a7
	move.w	d0,a5					; a5 = HANDLE of Popup
	movem.l	(a7)+,a0/a1
	; Set vars
	suba.l	a6,a6					; Found Entry Ptr = NULL
	clr.b	(a1)					; Nullify the string
	clr.w	d4					; Length of the string
	clr.w	d6					; Number of successful entries

	; Search back ' ' or start of string
\loop_char	cmp.l	a0,a1				; Check if the start of the string
		ble.s	\Done
		move.b	-(a1),d0			; Read next char
		cmpi.b	#' ',d0				; If ' ', then we have a word
		beq.s	\Done1
		cmpi.b	#SCRIPT_VARIABLE_CHAR,d0	; If '$', then we have a word.		
		beq.s	\Done1
		cmpi.b	#'{',d0				; If '{', then we have a word.		
		beq.s	\Done1		
		cmpi.b	#'\',d0				; If '\', then it is a folder\file completion
		beq	\Folder
		addq.w	#1,d4				; One more char
		bra.s	\loop_char			; Next char
\Done1:	addq.l	#1,a1					; *a1 == ' ', so skip again ' '
\Done	move.l	a1,a4					; Save the word to complete in a4

	; Search for a command which starts with a1 string
	tst.w	d4					; Is there at least one char?
	beq	\EndCompletion				; No char => No completion
	; 1. Search in the folder Table
	move.w	#FOLDER_LIST_HANDLE,a0
	bsr	CompletionFolderSearch
	moveq	#'\',d7					; Final char if we found inside the Folder Table
	; 2. Search in the internal commands
	lea	BuiltinCommandTable,a2
	move.l	a2,a3
\InternalSearchLoop:
		move.w	(a2),d0				; Read offset
		beq.s	\InternalSearchLoopEnd		; Check if zero
		lea	0(a3,d0.w),a0			; String Command Name
		bsr	CompletionCmp			; Check this command
		addq.l	#4,a2				; Next entry
		bra.s	\InternalSearchLoop
\InternalSearchLoopEnd
	; 3. Search in the files in the current folder
	move.w	CUR_FOLDER_HD,a0
	bsr	CompletionFolderSearch
	; 4. Search in the files of the PATH
	bsr	PathInit
\FolderLoop:	bsr	PathNext
		move.l	a0,d0
		beq.s	\resolve
		move.l	a0,a2			; Save Path Variable
		move.w	#FOLDER_LIST_HANDLE,a0
		bsr	FindSymEntry
		move.l	a0,d0
		beq.s	\NextFolder		; Folder not found, next folder
			move.w	SYM_ENTRY.hVal(a0),a0
			bsr	CompletionFolderSearch
\NextFolder	move.l	a2,a0
		bra.s	\FolderLoop

\Folder	; 5. Find inside the given folder if any
	tst.w	d4					; Is a char ?
	beq	\EndCompletion				; No char => No completion
	; a1 -> '\'
	lea	1(a1),a4				; File Ptr
	pea	(a1)					; Save ptr
	clr.b	(a1)					; Replace '\' by 0 (It is in RAM)
\Floop		cmp.l	a0,a1				; Search for the folder name
		ble.s	\FDone
		move.b	-(a1),d0			; Read char
		cmpi.b	#SCRIPT_VARIABLE_CHAR,d0	; If '$', then we have a word.		
		beq.s	\FDone1
		cmpi.b	#'{',d0				; If '{', then we have a word.		
		beq.s	\FDone1		
		cmpi.b	#' ',d0				; Cmp
		bne.s	\Floop				; Continue
\FDone1	addq.l	#1,a1
\FDone:		
	move.w	#FOLDER_LIST_HANDLE,a0			; Find folder (a1)
	bsr	FindSymEntry				; Find entry ?
	move.l	(a7)+,a1				; Reload ptr
	move.b	#'\',(a1)				; Restore string
	move.l	a0,d0					; Check success
	beq	\EndCompletion				; No => quit
	move.w	SYM_ENTRY.hVal(a0),a0			; Folder Handle
	bsr	CompletionFolderSearch			; Complete

\resolve

	; Now we have a list of all the entries which may success
	; d6 = Number of Found Entries
	; d5 = Max Len of char to put
	; d4 = Len of entry to complete
	; a6 -> A sucessfull entry
	; d7 = Final char ' ' or '\'
	subq.w	#1,d6					; = Number of success find
	blt.s	\EndCompletion
		; Now we have at least one entry
		lea	0(a6,d4.w),a1			; Ptr to entry (Remaining char).
		move.w	d5,d1				; d5 = Number of char to put
		sub.w	d4,d1				; - Number of chars already put
		subq.w	#1,d1				; -1 for dbf
		blt.s	\DisplayMenu			; If no char can be put, display the menu
\PutKeyInBuffer:
		move.w	#$500,d0			; Stop interrupts while putting keys
		trap	#1
		jsr	UpDateKeyBuffer			; Remove unused old values (like ENTER ;) )
\PutLoop		clr.w	d4
			move.b	(a1)+,d4		; Read char
			bsr.s	\AddKeyToFIFOKeyBuffer	; Put char in Key Buffer
			dbf	d1,\PutLoop
		move.w	d7,d4				; Add final ' ' or '\' character
		beq.s	\EndPutKeyInBuffer
			bsr.s	\AddKeyToFIFOKeyBuffer	
\EndPutKeyInBuffer:
		clr.w	KEY_STATUS			; Clear status
		clr.w	d0
		trap	#1				; Restore interrupts
			
	; Free the menu and quit.
\EndCompletion
	move.w	a5,-(a7)
	bsr	HeapFree				; HeapFree(H_NULL) doesn't crash contrary to AMS.
	addq.l	#2,a7
	movem.l	(a7)+,d0-d7/a0-a6
	move.b	(a7)+,(a1)				; Restore Last Char (It is in RAM)
	rts
\AddKeyToFIFOKeyBuffer:
	jmp	AddKeyToFIFOKeyBuffer
\DisplayMenu:
	move.w	a5,d0					; Check if PopUp is created
	beq.s	\EndCompletion				; No so quit.
	clr.w	-(a7)					; Start ID
	moveq	#-1,d0		
	move.l	d0,-(a7)				; X & Y
	move.w	a5,-(a7)				; Handle
	jsr	PopupDo					; Display the menu
	addq.l	#8,a7
	tst.w	d0					; Memory Error or ESC ?
	beq.s	\EndCompletion				; => End completion
	move.w	d0,-(a7)
	move.w	a5,-(a7)
	jsr	PopupText				; Get the associated text
	addq.l	#4,a7
	move.l	a0,d0
	beq.s	\EndCompletion				; Error ? => Quit
	move.l	a0,a6
	bsr	strlen_reg				; d5.w = Length of the text
	move.w	d0,d1					; I hope it is > d4 ...
	moveq	#' ',d7					; Completion char (Error if folder.)
	lea	0(a6,d4.w),a1				; Ptr to entry (Remaining char).
	sub.w	d4,d1					; - Number of chars already put
	subq.w	#1,d1					; -1 for dbf
	blt.s	\EndCompletion
	bra.s	\PutKeyInBuffer
	
; Search in the given folder 
;	a0= FOLDER HANDLE
CompletionFolderSearch:
	trap	#3
	addq.w	#2,a0				; Skip Max
	move.w	(a0)+,d3			; Number of folders (at least one !)
	subq.w	#1,d3
	blt.s	\EndFolder
\Loop		bsr.s	CompletionCmp		; Compare and add to buffer
		lea	SYM_ENTRY.sizeof(a0),a0	; Next entry
		dbf	d3,\Loop	
\EndFolder
	rts
			
CompletionCmp:
	pea	(a0)
	move.l	a4,a1				; String Source
	move.w	d4,d2				; Length
	subq.w	#1,d2				; -1 for dbf
\IntCmp		cmpm.b	(a1)+,(a0)+		; Compare 
		dbne	d2,\IntCmp		; and decrement
	bne.s	\Ret
		; Add this string to the list of the possible completion
		move.l	a6,d2
		beq.s	\FirstEntry
			; Find the max length of all the possible commands 
			; so that we put as mush char as possible
			move.l	a6,a1		; Old string
			move.l	(a7),a0		; New string
			moveq	#-1,d0		; Length
			\StrCmp:	addq.w	#1,d0
					tst.b	(a1)
					beq.s	\StrDone
					cmpm.b	(a1)+,(a0)+	; Compare 
					beq.s	\StrCmp		; 
			\StrDone:
				clr.w	d7		; No final char!
				cmp.w	d0,d5		; Get the min between d5 and d0
				ble.s	\NewEntry
					move.w	d0,d5
					bra.s	\NewEntry
\FirstEntry	; First entry of the list: the number of char 
		; to put is the length of the string.
		bsr	strlen
		move.w	d0,d5			; Length of command
		move.l	(a7),a6			; Save found command
		moveq	#' ',d7			; d7 = Final Char
\NewEntry	addq.w	#1,d6
		; Add this entry in the Popup
		move.w	a5,d0			; Check if PopUp is created
		beq.s	\Ret			; no so quit
			clr.w	-(a7)		; No parent
			move.l	2(a7),-(a7)	; Push Text Ptr
			clr.w	-(a7)		; Auto-Id
			move.w	a5,-(a7)	; Push Handle
			jsr	PopupAddText	; Add Text in PopUp
			lea	10(a7),a7	; FIXME: Check success ?
\Ret	move.l	(a7)+,a0
	rts


;; **********************************************************
;; Main Loop of the SHELL interface
;; **********************************************************
ShellCommand:
	; Display first line
	move.b	#USED_FONT,CURRENT_FONT		; Set current font
	bsr	clrscr				; Clear Screen
	pea	Pedrom_str(pc)
	bsr	printf				; Print 'PedroM'
	pea	Author_str(pc)	
	bsr	printf				; Printf '(c) PpHd'
	bsr	DispReturn
	jsr	PID_Init			; Set the Process Number of this Shell Command

	; Run 'start' script?
	tst.b	RUN_START_SCRIPT
	beq.s	\NoRun
		pea	StartScript_sym(pc)
		bsr	SymFindPtr			; Search file 'start'
		addq.l	#4,a7
		move.l	a0,d0
		beq.s	\NoRun
		move.w	SYM_ENTRY.hVal(a0),d1
		beq.s	\NoRun
			bsr	push_END_TAG		; Must call push_END_TAG (Bad conception :(
			move.w	d1,d0			; Doesn't delete d1
			jsr	ScriptExec
\NoRun:	; Alloc Input Buffer
	lea	(14-SHELL_MAX_LINE-6)(a7),a7

ShellCommandLoop:	
	; Check Pen position
	move.w	SHELL_SAVE_Y_POS,d0		; The window modify the vertical position of the pen.
	cmp.w	CURRENT_POINT_Y,d0		; So we check if the current position is > than the previous.
	ble.s	\Continue			; By the way, clearscreen resets the previous value too.
		move.w	d0,CURRENT_POINT_Y	; If not, we set the current value to the previous saved one.
\Continue
	btst.b	#5,DeskTopWindow+WINDOW.Flags	; Check if an application has set the Dirty flag of the main window.
	bne.s	\ClrScr				; if so, clear the screen.
	cmpi.w	#SCR_HEIGHT-8,CURRENT_POINT_Y	; If the pen is outside the screen
	ble.s	\Continue2
\ClrScr		bsr	clrscr			; We clear the screen.
\Continue2		
	clr.w	(a7)
	bsr	ST_busy				; Idle mode
	bsr	ReInitGraphSystem		; Restore the normal way of rendering
	bsr	InstallVectors			; Reinstall vectors (Bug ?)
	bsr	GKeyFlush			; Clear key buffer
	st.b	SHELL_NG_DISPLAY		; Display the result of ng_execute
	move.l	a7,a4				; Input Buffer
	clr.b	(a4)+				; First byte must be 0

	; Ask command to the user.
\WhileInput	pea	Shell_str(pc)
		bsr	printf			; Display ':>'
		addq.l	#4,a7
		move.l	a4,a0			; Input Buffer 
		moveq	#SHELL_MAX_LINE,d3	; Length of Buffer	
		bsr	InputString		; Input the string inside the buffer
		tst.b	(a4)			; Check if something is in the buffer?
		beq.s	\WhileInput		; No => continue the input

	bsr.s	CopyToHistory			; Copy the command in the history

	lea	-60(a7),a7			; Error Stack Frame
	pea	(a7)				; Push Stack Frame
	bsr	ER_catch			; Catch all errors.
	tst.w	d0
	bne.s	\Error
		bsr	ShellExecuteCommand	; Translate and execute the Command
		bsr	ER_success
		bra.s	\Cont
\Error	jsr	find_error_message_reg
	pea	(a0)
	pea	CommandNotFound_str(pc)
	bsr	printf
	addq.l	#8,a7
\Cont	lea	64(a7),a7
	bra	ShellCommandLoop

; Copy the given string to the history table.
; In: a4 -> String
CopyToHistory:
	pea	((SHELL_HISTORY-1)*(SHELL_MAX_LINE+2)).w	; Size
	pea	SHELL_HISTORY_TAB				; From
	pea	SHELL_HISTORY_TAB+SHELL_MAX_LINE+2		; To 
	bsr	memmove
	pea	((SHELL_MAX_LINE+1)).w				; Size
	pea	(a4)						; From
	pea	SHELL_HISTORY_TAB				; To 
	bsr	memcpy
	lea	(4*6)(a7),a7
	rts
