'\"
'\" Copyright (c) 2001, Vince Darley
'\" 
'\" 
.so man.macros
.TH vfslib n 1.0 Vfslib "Tcl-only Virtual File Systems"
.BS
'\" Note:  do not modify the .sh NAME line immediately below!
.SH NAME
::vfslib \- Procedures to interact with virtual filesystems
.SH SYNOPSIS
.BS
.sp
\fBpackage require Tcl 8.4\fR
.sp
\fBpackage require vfs ?1.2.1?\fR
.sp
\fBpackage require vfs::zip ?1.0?\fR
.sp
\fBpackage require vfs::mk4 ?1.6?\fR
.sp
\fBpackage require vfs::tar ?0.9?\fR
.sp
\fBpackage require vfs::ftp ?1.0?\fR
.sp
\fBpackage require vfs::ns ?1.0?\fR
.sp
\fBpackage require vfs::webdav ?0.1?\fR
.sp
\fBpackage require vfs::http ?0.5?\fR
.sp
\fBpackage require vfs::urltype ?1.0?\fR
.sp
\fBvfs::zip::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::ftp::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::tar::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::http::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::mk4::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::ns::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::urltype::Mount\fR \fItype\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::vfs\fR package includes a library of Tcl code, implementing
a number of different virtual filesystems.  Each of these exists
as its own package, and can be accessed through \fBpackage require
vfs::NAME\fP.  The whole set of virtual filesystems is known informally
as 'vfslib'
.PP
.SH SUPPORTED VFS TYPES
.PP
The current supported types are ftp, tar, http, zip, mk4, ns, webdav.  In
addition there is the ability to mount any 'urltype' as a new volume,
provided an appropriate vfs is supported.  This means that you can treat
'ftp://', 'http://' and 'file://' urls as files.  To do this, simply
evaluate the command
.PP
\fIvfs::urltype::Mount ftp\fR
.PP
for instance.  Any access inside the new volume will result in an attempt
to require a package through 'package require vfs::${type}', which must
therefore exist, or errors will be thrown.
.PP
.SH LIMITATIONS
.PP
Most of the vfs types listed above have not been very well debugged
as yet.  Please test them!
.SH KEYWORDS
vfs, vfslib, filesystem, zip, tar, webdav, namespace, ftp, http, file


