/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.Pointer;

public class SimpleNioBuf
implements Buf {
    private final ByteBuffer byteBuf_;
    private final ByteBuffer dataBuf_;
    private boolean isBit64_;
    private boolean isBigendian_;

    public SimpleNioBuf(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        this.byteBuf_ = byteBuffer;
        this.dataBuf_ = byteBuffer.duplicate();
        this.setBit64(bl);
        this.setEncoding(bl2);
    }

    public long getLength() {
        return this.byteBuf_.capacity();
    }

    public int readUnsignedByte(Pointer pointer) {
        return this.byteBuf_.get(SimpleNioBuf.toInt(pointer.getAndIncrement(1))) & 0xFF;
    }

    public int readInt(Pointer pointer) {
        return this.byteBuf_.getInt(SimpleNioBuf.toInt(pointer.getAndIncrement(4)));
    }

    public long readOffset(Pointer pointer) {
        return this.isBit64_ ? this.byteBuf_.getLong(SimpleNioBuf.toInt(pointer.getAndIncrement(8))) : (long)this.byteBuf_.getInt(SimpleNioBuf.toInt(pointer.getAndIncrement(4)));
    }

    public String readAsciiString(Pointer pointer, int n) {
        return Bufs.readAsciiString(this.byteBuf_, SimpleNioBuf.toInt(pointer.getAndIncrement(n)), n);
    }

    public synchronized void setBit64(boolean bl) {
        this.isBit64_ = bl;
    }

    public synchronized void setEncoding(boolean bl) {
        this.dataBuf_.order(bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.isBigendian_ = bl;
    }

    public boolean isBigendian() {
        return this.isBigendian_;
    }

    public boolean isBit64() {
        return this.isBit64_;
    }

    public void readDataBytes(long l, int n, byte[] byArray) {
        Bufs.readBytes(this.dataBuf_, SimpleNioBuf.toInt(l), n, byArray);
    }

    public void readDataShorts(long l, int n, short[] sArray) {
        Bufs.readShorts(this.dataBuf_, SimpleNioBuf.toInt(l), n, sArray);
    }

    public void readDataInts(long l, int n, int[] nArray) {
        Bufs.readInts(this.dataBuf_, SimpleNioBuf.toInt(l), n, nArray);
    }

    public void readDataLongs(long l, int n, long[] lArray) {
        Bufs.readLongs(this.dataBuf_, SimpleNioBuf.toInt(l), n, lArray);
    }

    public void readDataFloats(long l, int n, float[] fArray) {
        Bufs.readFloats(this.dataBuf_, SimpleNioBuf.toInt(l), n, fArray);
    }

    public void readDataDoubles(long l, int n, double[] dArray) {
        Bufs.readDoubles(this.dataBuf_, SimpleNioBuf.toInt(l), n, dArray);
    }

    public InputStream createInputStream(long l) {
        ByteBuffer byteBuffer = this.byteBuf_.duplicate();
        byteBuffer.position((int)l);
        return Bufs.createByteBufferInputStream(byteBuffer);
    }

    public Buf fillNewBuf(long l, InputStream inputStream) throws IOException {
        int n;
        int n2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        for (n2 = SimpleNioBuf.toInt(l); n2 > 0; n2 -= n) {
            n = readableByteChannel.read(byteBuffer);
            if (n >= 0) continue;
            throw new EOFException();
        }
        return new SimpleNioBuf(byteBuffer, this.isBit64_, this.isBigendian_);
    }

    private static int toInt(long l) {
        int n = (int)l;
        if ((long)n != l) {
            throw new IllegalArgumentException("Pointer out of range: " + l + " >32 bits");
        }
        return n;
    }
}

