/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * ShapeTools/shape program - sighand.c
 *
 * Author: Axel Mahler (Axel.Mahler@cs.tu-berlin.de)
 *
 * $Header: sighand.c[8.0] Wed Jul  7 18:33:17 1993 axel@cs.tu-berlin.de frozen $
 */
#ifndef lint
static char *AtFSid = "$Header: sighand.c[8.0] Wed Jul  7 18:33:17 1993 axel@cs.tu-berlin.de frozen $";
#endif

#include "shape.h"

EXPORT void catch_sigs () {
/*
 * Setup signal handlers for various signals. Previous handlers
 * are saved. On receipt of a signal, the 
 * original handler for this signal will be invoked after specified
 * action has been taken.
 */
Sigret_t
  die2(), die8(), die10(), die11(), die15();

  signal (SIGINT, die2);
  signal (SIGFPE, die8);
  signal (SIGBUS, die10);
  signal (SIGSEGV, die11);
  signal (SIGTERM, die15);
}


Sigret_t die2 () {
  signal(SIGINT,SIG_IGN);
  errexit(23,"\0");
}

Sigret_t die8 () {
  signal(SIGINT,SIG_IGN);
  fprintf(stderr, "Oh! Oh! .... this was a floating exception -- goodbye.\n"); 
  af_cleanup ();
  cleanup_links(link_reg);
  exit (1);
}

Sigret_t die10 () {
  fprintf(stderr, "Oh! Oh! .... this was a buserror -- goodbye.\n");
  fprintf(stderr, "Dumping core.\n");
  af_cleanup ();
  cleanup_links(link_reg);
  kill (getpid(), SIGQUIT);
}

Sigret_t die11 () {
  signal(SIGINT,SIG_IGN);
  fprintf(stderr, 
	  "Oh! Oh! .... this was a segmentation violation -- goodbye.\n");
  fprintf(stderr, "Dumping core.\n");
  af_cleanup ();
  cleanup_links(link_reg);
  kill (getpid(), SIGQUIT);
}

Sigret_t die15 () {
  signal(SIGINT,SIG_IGN);
  af_cleanup();
  cleanup_links(link_reg);
  exit(1);
}

