/*
   Unix SMB/CIFS implementation.
   VFS module tester

   Copyright (C) Simo Sorce 2002
   Copyright (C) Eric Lorimer 2002

   Most of this code was ripped off of rpcclient.
   Copyright (C) Tim Potter 2000-2001

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

struct func_entry {
	char *name;
	int (*fn)(struct connection_struct *conn, const char *path);
};

struct vfs_state {
	struct connection_struct *conn;
	uint64_t mid;
	struct files_struct *files[1024];
	struct smb_Dir *currentdir;
	long currentdir_offset;
	void *data;
	size_t data_size;
};

struct smb_request *vfstest_get_smbreq(TALLOC_CTX *mem_ctx,
				       struct vfs_state *vfs);

struct cmd_set {
	const char *name;
	NTSTATUS (*fn)(struct vfs_state *vfs, TALLOC_CTX *mem_ctx, int argc, 
                       const char **argv);
	const char *description;
	const char *usage;
};

NTSTATUS cmd_test_chain(struct vfs_state *vfs, TALLOC_CTX *mem_ctx,
			int argc, const char **argv);
