# QIIME 2 Users

Check out the [User Docs](https://docs.qiime2.org) - there are many tutorials,
walkthroughs, and guides available. If you still need help, please visit us at
the [QIIME 2 Forum](https://forum.qiime2.org/c/user-support).

# QIIME 2 Developers

Check out the [Developer Docs](https://dev.qiime2.org) - there are many
tutorials, walkthroughs, and guides available. If you still need help, please
visit us at the [QIIME 2 Forum](https://forum.qiime2.org/c/dev-discussion).

# General Bug/Issue Triage Discussion

![rubric](./rubric.png?raw=true)

# Projects/Repositories in the QIIME 2 GitHub Organization

Sorted alphabetically by repo name.

- [busywork](https://github.com/qiime2/busywork/issues)
  | The CI automation engine that builds and distributes QIIME 2
- [conda-channel-resource](https://github.com/qiime2/conda-channel-resource/issues)
  | A Concourse resource for working with conda
- [data.qiime2.org](https://github.com/qiime2/data.qiime2.org/issues)
  | Web app for vanity URLs for QIIME 2 data assets
- [dev-docs](https://github.com/qiime2/dev-docs/issues)
  | The Developer Documentation
- [discourse-unhandled-tagger](https://github.com/qiime2/discourse-unhandled-tagger/issues)
  | A discourse plugin for handling queued/unqueued topics
- [docs](https://github.com/qiime2/docs/issues)
  | The User Documentation
- [environment-files](https://github.com/qiime2/environment-files/issues)
  | Rendered QIIME 2 environment files for conda
- [Keemei](https://github.com/qiime2/Keemei/issues)
  | Google Sheets Add-On for validating tabular data
- [linux-worker-docker](https://github.com/qiime2/linux-worker-docker/issues)
  | A docker image for linux-based busywork workers
- [logos](https://github.com/qiime2/logos/issues)
  | Official project logos
- [q2-alignment](https://github.com/qiime2/q2-alignment/issues)
  | The q2-alignment plugin
- [q2-composition](https://github.com/qiime2/q2-composition/issues)
  | The q2-composition plugin
- [q2-cutadapt](https://github.com/qiime2/q2-cutadapt/issues)
  | The q2-cutadapt plugin
- [q2-dada2](https://github.com/qiime2/q2-dada2/issues)
  | The q2-dada2 plugin
- [q2-deblur](https://github.com/qiime2/q2-deblur/issues)
  | The q2-deblur plugin
- [q2-demux](https://github.com/qiime2/q2-demux/issues)
  | The q2-demux plugin
- [q2-diversity](https://github.com/qiime2/q2-diversity/issues)
  | The q2-diversity plugin
- [q2-diversity-lib](https://github.com/qiime2/q2-diversity-lib/issues)
  | The q2-diversity-lib plugin
- [q2-emperor](https://github.com/qiime2/q2-emperor/issues)
  | The q2-emperor plugin
- [q2-feature-classifier](https://github.com/qiime2/q2-feature-classifier/issues)
  | The q2-feature-classifier plugin
- [q2-feature-table](https://github.com/qiime2/q2-feature-table/issues)
  | The q2-feature-table plugin
- [q2-fragment-insertion](https://github.com/qiime2/q2-fragment-insertion/issues)
  | The q2-fragment-insertion plugin
- [q2-gneiss](https://github.com/qiime2/q2-gneiss/issues)
  | The q2-gneiss plugin
- [q2-longitudinal](https://github.com/qiime2/q2-longitudinal/issues)
  | The q2-longitudinal plugin
- [q2-metadata](https://github.com/qiime2/q2-metadata/issues)
  | The q2-metadata plugin
- [q2-phylogeny](https://github.com/qiime2/q2-phylogeny/issues)
  | The q2-phylogeny plugin
- [q2-quality-control](https://github.com/qiime2/q2-quality-control/issues)
  | The q2-quality-control plugin
- [q2-quality-filter](https://github.com/qiime2/q2-quality-filter/issues)
  | The q2-quality-filter plugin
- [q2-sample-classifier](https://github.com/qiime2/q2-sample-classifier/issues)
  | The q2-sample-classifier plugin
- [q2-shogun](https://github.com/qiime2/q2-shogun/issues)
  | The q2-shogun plugin
- [q2-taxa](https://github.com/qiime2/q2-taxa/issues)
  | The q2-taxa plugin
- [q2-types](https://github.com/qiime2/q2-types/issues)
  | The q2-types plugin
- [q2-vsearch](https://github.com/qiime2/q2-vsearch/issues)
  | The q2-vsearch plugin
- [q2cli](https://github.com/qiime2/q2cli/issues)
  | The CLI interface
- [q2cwl](https://github.com/qiime2/q2cwl/issues)
  | The prototype CWL interface
- [q2galaxy](https://github.com/qiime2/q2galaxy/issues)
  | The prototype Galaxy interface
- [q2lint](https://github.com/qiime2/q2lint/issues)
  | An internal tool for ensuring header text and copyrights are present
- [q2studio](https://github.com/qiime2/q2studio/issues)
  | The prototype GUI interface
- [q2templates](https://github.com/qiime2/q2templates/issues)
  | A base template for use in official QIIME 2 plugins
- [q2view](https://github.com/qiime2/q2view/issues)
  | The read-only web interface at view.qiime2.org
- [qiime2.github.io](https://github.com/qiime2/qiime2.github.io/issues)
  | The QIIME 2 homepage at qiime2.org
- [qiime2](https://github.com/qiime2/qiime2/issues)
  | The QIIME 2 framework
- [template-repo](https://github.com/qiime2/template-repo/issues)
  | Centralized templates for repo assets
- [vm-playbooks](https://github.com/qiime2/vm-playbooks/issues)
  | Scripts for building QIIME 2 VMs
- [workshop-playbooks](https://github.com/qiime2/workshop-playbooks/issues)
  | Scripts for building QIIME 2 workshop clusters
- [workshops.qiime2.org](https://github.com/qiime2/workshops.qiime2.org/issues)
  | The web app that runs workshops.qiime2.org
