'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH DS2502 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2502
\- Add-Only Memory (1 kBit)
.TP
.B DS2502-E48, DS2502-UNW
\- 48-bit Node Address Chip, UniqueWare Add-Only Memory (1 kBit)
.TP
.B DS1982, DS1982U
\- Add-Only iButton (1 kBit), UniqueWare iButton (1 kBit)
.SH SYNOPSIS
EPROM add-only memory.
.PP
.B 09
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-3|ALL]
|
.so man3/standard_mini.3so
]]
.PP
.B 89
[.]XXXXXXXXXXXX[XX][/[
.B mac_e
|
.B mac_fw
|
.B memory
|
.B pages/page.[0-3|ALL]
|
.B project
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 09
DS2502 DS1982
.TP
.I 89
DS2502-UNW DS2502-E48 DS1982U
.SH SPECIAL PROPERTIES
.SS mac_e mac_fw
.I read-only, binary
.br
64 bit or 80 bit
.I media access control
number. Unique, and unrelated to the 1-wire address. It is apparently used for ethernet or FireWire addressing, respectively.
.SS memory
.I read-write, binary
.br
128 bytes of memory. Initially all bits are set to 1. Writing zero permanently alters the memory.
.SS pages/page.0 ... pages/page.3 pages/page.ALL
.I read-write, yes-no
.br
Memory is split into 4 pages of 32 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS project
.I read-only, binary
.br
32 bit
.I project
id. Constant 0x0000 for ethernet and  0x00001128 for firewire. See Datasheets.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2502 DS1982
The
.B DS2502 (3)
is used for write-once incremental storage. It's main advantage is for audit trails (i.e. a digital purse).
.PP
The
.B DS2502-E48
and
.B DS2502-UNW
are some of the
.I UniqueWare
class of devices. Some of the memory was preprogramed at the factory. See the datasheet for specifics.  The
.B DS2502
,
.B DS2505
, and
.B DS2506
differ in their function by the amount of on-board memory they possess. (The internal protocols are slightly different, but the
.I OWFS
system handles this automatically.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2502.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS2502-E48.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS2502-UNW-DS2506S-UNW.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1982-F3-DS1982-F5.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1982U-DS1986U.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
