/* $Id: Feat_qual_choice.cpp 436427 2014-05-28 13:24:42Z chenj $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  J. Chen
 *
 * File Description:
 *   GetQualFromFeatureAnyType
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Feat_qual_choice.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CFeat_qual_choice::~CFeat_qual_choice(void)
{
}

string CFeat_qual_choice :: x_GetLegalQualName(vector <EFeat_qual_legal>& v_qual, EFeat_qual_legal qual) const
{       
  ITERATE (vector <EFeat_qual_legal>, it, v_qual) {
    if (qual == *it) {
      string name = ENUM_METHOD_NAME(EFeat_qual_legal)()->FindName(qual, true);
      if (name == "name") {
           return ("region");
      }
      else if (name == "product") {
         return ("name");
      }
      else if (name == "gene") {
         return ("locus");
      }
      else if ( name == "locus-tag") {
          return("locus_tag");
      }
      return name;
    }
  }
  return kEmptyStr;
};

void CFeat_qual_choice :: x_GetTwoFieldSubfield(string& str, int subfield) const
{
  if (str.empty() || subfield > 2) {
      str = kEmptyStr;
  }
  if (subfield) {
    size_t pos = str.find(':');
    if (pos == string::npos) {
      if (subfield != 1) {
         str = kEmptyStr;
      }
    }
    else {
      if (subfield == 1) {
           str.substr(0, pos);
      }
      else {
        str = CTempString(str).substr(pos+1);
      }
    }
  }
};

string CFeat_qual_choice :: x_GetFirstGBQualMatch(const vector <CRef <CGb_qual> >& quals, const string& qual_name, int subfield, const CString_constraint& str_cons) const
{
  string str;
  ITERATE (vector <CRef <CGb_qual> >, it, quals) {
     if (NStr::EqualNocase( (*it)->GetQual(), qual_name)) {
        str = (*it)->GetVal();
        if (subfield) {
            x_GetTwoFieldSubfield(str, subfield);
        }
        if (str.empty() || !str_cons.Match(str)) {
           str = kEmptyStr;
        }
        else {
          break;
        }
     }
  }
  return str;
};

string CFeat_qual_choice :: GetFirstStringMatch(const list <string>& strs, const CString_constraint& str_cons)
{
   ITERATE (list <string>, sit, strs) {
     if ( !(*sit).empty() && str_cons.Match(*sit)) {
       return (*sit);
     }
   }
   return kEmptyStr;
};

string CFeat_qual_choice :: GetFirstStringMatch(const vector <string>& strs, const CString_constraint& str_cons)
{
   ITERATE (vector <string>, sit, strs) {
     if ( !(*sit).empty() && str_cons.Match(*sit)) {
        return (*sit);
     }
   }
   return kEmptyStr;
};

string CFeat_qual_choice :: x_GetFirstGBQualMatchConstraintName(const CSeq_feat& feat, const CString_constraint& str_cons) const
{
   string str;
   if (feat.CanGetQual()) {
     ITERATE (vector <CRef <CGb_qual> >, it, feat.GetQual()) {
        str = (*it)->GetVal();
        if (!str.empty() && str_cons.Match(str)) {
             return str;
        }
        else str = kEmptyStr;
     }
   }
   return str;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1741, CRC32: 81a34e90 */
