def create_iso3166_country_list_file
  cpp_file_name = "src/common/iso3166_country_list.cpp"
  iso3166_1     = JSON.parse(IO.readlines("/usr/share/iso-codes/json/iso_3166-1.json").join(''))
  rows          = iso3166_1["3166-1"].
    map do |entry|
    [ entry["alpha_2"].upcase.to_cpp_string,
      entry["alpha_3"].upcase.to_cpp_string,
      sprintf('%03s', entry["numeric"].gsub(%r{^0+}, '')),
      entry["name"].to_u8_cpp_string,
      (entry["official_name"] || '').to_u8_cpp_string,
    ]
  end

  entries = Mtx::IANALanguageSubtagRegistry.fetch_registry
  entries["region"].
    select { |region| %r{^\d+$}.match(region[:subtag]) }.
    each do |region|

    rows << [
      '""s', '""s',
      sprintf('%03s', region[:subtag].gsub(%r{^0+}, '')),
      region[:description].to_u8_cpp_string,
      '""s',
    ]
  end

  header = <<EOT
/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 3166 countries & UN M.49 regions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// ------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso3166_list" rake target.
// ------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso3166.h"

namespace mtx::iso3166 {

std::vector<region_t> const g_regions{
EOT

  footer = <<EOT
};

} // namespace mtx::iso3166
EOT

  rows    = rows.sort_by { |row| [ row[0], row[1], row[3] ].join('::') }
  content = header + format_table(rows, :column_suffix => ',', :row_prefix => "  { ", :row_suffix => "  },").join("\n") + "\n" + footer

  runq("write", cpp_file_name) { IO.write("#{$source_dir}/#{cpp_file_name}", content); 0 }
end
