
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileSymbolPlottingAttributes.h
    \brief Definition of SymbolPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef SymbolPlottingAttributes_H
#define SymbolPlottingAttributes_H

#include "magics.h"
#include "SymbolMode.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class SymbolPlottingAttributes 
{
public:
//  --  constructor
    SymbolPlottingAttributes();
    
//  --  destructor
    virtual ~SymbolPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool legend_;
	string unit_method_;
	string type_;
	string marker_mode_;
	string format_;
	bool text_blanking_;
	bool outline_;
	int outline_thickness_;
	bool connect_;
	bool automatic_connect_colour_;
	int connect_thickness_;
	bool legend_only_;
	unique_ptr<SymbolMode> mode_;
	unique_ptr<Colour> outline_colour_;
	LineStyle outline_style_;
	unique_ptr<Colour> connect_colour_;
	LineStyle connect_style_;
	 

private:
	friend ostream& operator<<(ostream& s,const SymbolPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

