/* SPDX-FileCopyrightText: 2023 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gtk/gtk.h>
#include "gtksourcestylescheme.h"

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_STYLE_SCHEME_CSS             (_gtk_source_style_scheme_css_get_type ())
#define GTK_SOURCE_STYLE_SCHEME_CSS(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_STYLE_SCHEME_CSS, GtkSourceStyleSchemeCss))
#define GTK_SOURCE_STYLE_SCHEME_CSS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_STYLE_SCHEME_CSS, GtkSourceStyleSchemeCssClass))
#define GTK_SOURCE_IS_STYLE_SCHEME_CSS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_STYLE_SCHEME_CSS))
#define GTK_SOURCE_IS_STYLE_SCHEME_CSS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_STYLE_SCHEME_CSS))
#define GTK_SOURCE_STYLE_SCHEME_CSS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_STYLE_SCHEME_CSS, GtkSourceStyleSchemeCssClass))

typedef struct _GtkSourceStyleSchemeCss         GtkSourceStyleSchemeCss;
typedef struct _GtkSourceStyleSchemeCssClass    GtkSourceStyleSchemeCssClass;
typedef struct _GtkSourceStyleSchemeCssPrivate  GtkSourceStyleSchemeCssPrivate;

struct _GtkSourceStyleSchemeCss
{
	GObject parent;

	GtkSourceStyleSchemeCssPrivate *priv;
};

struct _GtkSourceStyleSchemeCssClass
{
	GObjectClass parent_class;
};

G_GNUC_INTERNAL
GType		_gtk_source_style_scheme_css_get_type	(void) G_GNUC_CONST;

G_GNUC_INTERNAL
GtkSourceStyleSchemeCss *
		_gtk_source_style_scheme_css_new	(GtkSourceStyleScheme *scheme);

G_GNUC_INTERNAL
void		_gtk_source_style_scheme_css_apply	(GtkSourceStyleSchemeCss *scheme_css,
							 GtkWidget               *widget);

G_GNUC_INTERNAL
void		_gtk_source_style_scheme_css_unapply	(GtkSourceStyleSchemeCss *scheme_css,
							 GtkWidget               *widget);

G_END_DECLS
