
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMdiArea.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMdiArea>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QBrush>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMdiSubWindow>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMdiArea

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMdiArea::staticMetaObject);
}


// void QMdiArea::activateNextSubWindow()


static void _init_f_activateNextSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activateNextSubWindow_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->activateNextSubWindow ();
}


// void QMdiArea::activatePreviousSubWindow()


static void _init_f_activatePreviousSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activatePreviousSubWindow_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->activatePreviousSubWindow ();
}


// QMdiArea::WindowOrder QMdiArea::activationOrder()


static void _init_f_activationOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMdiArea::WindowOrder>::target_type > ();
}

static void _call_f_activationOrder_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMdiArea::WindowOrder>::target_type > ((qt_gsi::Converter<QMdiArea::WindowOrder>::target_type)qt_gsi::CppToQtAdaptor<QMdiArea::WindowOrder>(((QMdiArea *)cls)->activationOrder ()));
}


// QMdiSubWindow *QMdiArea::activeSubWindow()


static void _init_f_activeSubWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_activeSubWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->activeSubWindow ());
}


// QMdiSubWindow *QMdiArea::addSubWindow(QWidget *widget, QFlags<Qt::WindowType> flags)


static void _init_f_addSubWindow_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_addSubWindow_3702 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->addSubWindow (arg1, arg2));
}


// QBrush QMdiArea::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QMdiArea *)cls)->background ());
}


// void QMdiArea::cascadeSubWindows()


static void _init_f_cascadeSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cascadeSubWindows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->cascadeSubWindows ();
}


// void QMdiArea::closeActiveSubWindow()


static void _init_f_closeActiveSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeActiveSubWindow_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->closeActiveSubWindow ();
}


// void QMdiArea::closeAllSubWindows()


static void _init_f_closeAllSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeAllSubWindows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->closeAllSubWindows ();
}


// QMdiSubWindow *QMdiArea::currentSubWindow()


static void _init_f_currentSubWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_currentSubWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->currentSubWindow ());
}


// bool QMdiArea::documentMode()


static void _init_f_documentMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_documentMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea *)cls)->documentMode ());
}


// QSize QMdiArea::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiArea *)cls)->minimumSizeHint ());
}


// void QMdiArea::removeSubWindow(QWidget *widget)


static void _init_f_removeSubWindow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSubWindow_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->removeSubWindow (arg1);
}


// void QMdiArea::setActivationOrder(QMdiArea::WindowOrder order)


static void _init_f_setActivationOrder_2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActivationOrder_2432 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setActivationOrder (qt_gsi::QtToCppAdaptor<QMdiArea::WindowOrder>(arg1).cref());
}


// void QMdiArea::setActiveSubWindow(QMdiSubWindow *window)


static void _init_f_setActiveSubWindow_1915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<QMdiSubWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveSubWindow_1915 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMdiSubWindow *arg1 = gsi::arg_reader<QMdiSubWindow * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setActiveSubWindow (arg1);
}


// void QMdiArea::setBackground(const QBrush &background)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("background");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setBackground (arg1);
}


// void QMdiArea::setDocumentMode(bool enabled)


static void _init_f_setDocumentMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setDocumentMode (arg1);
}


// void QMdiArea::setOption(QMdiArea::AreaOption option, bool on)


static void _init_f_setOption_3058 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_3058 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setOption (qt_gsi::QtToCppAdaptor<QMdiArea::AreaOption>(arg1).cref(), arg2);
}


// void QMdiArea::setTabPosition(QTabWidget::TabPosition position)


static void _init_f_setTabPosition_2656 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabPosition_2656 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setTabPosition (qt_gsi::QtToCppAdaptor<QTabWidget::TabPosition>(arg1).cref());
}


// void QMdiArea::setTabShape(QTabWidget::TabShape shape)


static void _init_f_setTabShape_2300 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shape");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabShape_2300 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTabWidget::TabShape>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setTabShape (qt_gsi::QtToCppAdaptor<QTabWidget::TabShape>(arg1).cref());
}


// void QMdiArea::setTabsClosable(bool closable)


static void _init_f_setTabsClosable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("closable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabsClosable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setTabsClosable (arg1);
}


// void QMdiArea::setTabsMovable(bool movable)


static void _init_f_setTabsMovable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("movable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabsMovable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setTabsMovable (arg1);
}


// void QMdiArea::setViewMode(QMdiArea::ViewMode mode)


static void _init_f_setViewMode_2092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_2092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QMdiArea::ViewMode>(arg1).cref());
}


// QSize QMdiArea::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiArea *)cls)->sizeHint ());
}


// QList<QMdiSubWindow *> QMdiArea::subWindowList(QMdiArea::WindowOrder order)


static void _init_f_subWindowList_c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order", true, "QMdiArea::CreationOrder");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > (argspec_0);
  decl->set_return<QList<QMdiSubWindow *> > ();
}

static void _call_f_subWindowList_c2432 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMdiArea::WindowOrder>(heap, QMdiArea::CreationOrder), heap);
  ret.write<QList<QMdiSubWindow *> > ((QList<QMdiSubWindow *>)((QMdiArea *)cls)->subWindowList (qt_gsi::QtToCppAdaptor<QMdiArea::WindowOrder>(arg1).cref()));
}


// QTabWidget::TabPosition QMdiArea::tabPosition()


static void _init_f_tabPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ();
}

static void _call_f_tabPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ((qt_gsi::Converter<QTabWidget::TabPosition>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabPosition>(((QMdiArea *)cls)->tabPosition ()));
}


// QTabWidget::TabShape QMdiArea::tabShape()


static void _init_f_tabShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ();
}

static void _call_f_tabShape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ((qt_gsi::Converter<QTabWidget::TabShape>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabShape>(((QMdiArea *)cls)->tabShape ()));
}


// bool QMdiArea::tabsClosable()


static void _init_f_tabsClosable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabsClosable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea *)cls)->tabsClosable ());
}


// bool QMdiArea::tabsMovable()


static void _init_f_tabsMovable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabsMovable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea *)cls)->tabsMovable ());
}


// bool QMdiArea::testOption(QMdiArea::AreaOption opton)


static void _init_f_testOption_c2302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opton");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QMdiArea *)cls)->testOption (qt_gsi::QtToCppAdaptor<QMdiArea::AreaOption>(arg1).cref()));
}


// void QMdiArea::tileSubWindows()


static void _init_f_tileSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_tileSubWindows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea *)cls)->tileSubWindows ();
}


// QMdiArea::ViewMode QMdiArea::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMdiArea::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMdiArea::ViewMode>::target_type > ((qt_gsi::Converter<QMdiArea::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QMdiArea::ViewMode>(((QMdiArea *)cls)->viewMode ()));
}


// static QString QMdiArea::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMdiArea::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMdiArea () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("activateNextSubWindow", "@brief Method void QMdiArea::activateNextSubWindow()\n", false, &_init_f_activateNextSubWindow_0, &_call_f_activateNextSubWindow_0);
  methods += new qt_gsi::GenericMethod ("activatePreviousSubWindow", "@brief Method void QMdiArea::activatePreviousSubWindow()\n", false, &_init_f_activatePreviousSubWindow_0, &_call_f_activatePreviousSubWindow_0);
  methods += new qt_gsi::GenericMethod (":activationOrder", "@brief Method QMdiArea::WindowOrder QMdiArea::activationOrder()\n", true, &_init_f_activationOrder_c0, &_call_f_activationOrder_c0);
  methods += new qt_gsi::GenericMethod (":activeSubWindow", "@brief Method QMdiSubWindow *QMdiArea::activeSubWindow()\n", true, &_init_f_activeSubWindow_c0, &_call_f_activeSubWindow_c0);
  methods += new qt_gsi::GenericMethod ("addSubWindow", "@brief Method QMdiSubWindow *QMdiArea::addSubWindow(QWidget *widget, QFlags<Qt::WindowType> flags)\n", false, &_init_f_addSubWindow_3702, &_call_f_addSubWindow_3702);
  methods += new qt_gsi::GenericMethod (":background", "@brief Method QBrush QMdiArea::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
  methods += new qt_gsi::GenericMethod ("cascadeSubWindows", "@brief Method void QMdiArea::cascadeSubWindows()\n", false, &_init_f_cascadeSubWindows_0, &_call_f_cascadeSubWindows_0);
  methods += new qt_gsi::GenericMethod ("closeActiveSubWindow", "@brief Method void QMdiArea::closeActiveSubWindow()\n", false, &_init_f_closeActiveSubWindow_0, &_call_f_closeActiveSubWindow_0);
  methods += new qt_gsi::GenericMethod ("closeAllSubWindows", "@brief Method void QMdiArea::closeAllSubWindows()\n", false, &_init_f_closeAllSubWindows_0, &_call_f_closeAllSubWindows_0);
  methods += new qt_gsi::GenericMethod ("currentSubWindow", "@brief Method QMdiSubWindow *QMdiArea::currentSubWindow()\n", true, &_init_f_currentSubWindow_c0, &_call_f_currentSubWindow_c0);
  methods += new qt_gsi::GenericMethod (":documentMode", "@brief Method bool QMdiArea::documentMode()\n", true, &_init_f_documentMode_c0, &_call_f_documentMode_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QMdiArea::minimumSizeHint()\nThis is a reimplementation of QAbstractScrollArea::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod ("removeSubWindow", "@brief Method void QMdiArea::removeSubWindow(QWidget *widget)\n", false, &_init_f_removeSubWindow_1315, &_call_f_removeSubWindow_1315);
  methods += new qt_gsi::GenericMethod ("setActivationOrder|activationOrder=", "@brief Method void QMdiArea::setActivationOrder(QMdiArea::WindowOrder order)\n", false, &_init_f_setActivationOrder_2432, &_call_f_setActivationOrder_2432);
  methods += new qt_gsi::GenericMethod ("setActiveSubWindow|activeSubWindow=", "@brief Method void QMdiArea::setActiveSubWindow(QMdiSubWindow *window)\n", false, &_init_f_setActiveSubWindow_1915, &_call_f_setActiveSubWindow_1915);
  methods += new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QMdiArea::setBackground(const QBrush &background)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
  methods += new qt_gsi::GenericMethod ("setDocumentMode|documentMode=", "@brief Method void QMdiArea::setDocumentMode(bool enabled)\n", false, &_init_f_setDocumentMode_864, &_call_f_setDocumentMode_864);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QMdiArea::setOption(QMdiArea::AreaOption option, bool on)\n", false, &_init_f_setOption_3058, &_call_f_setOption_3058);
  methods += new qt_gsi::GenericMethod ("setTabPosition|tabPosition=", "@brief Method void QMdiArea::setTabPosition(QTabWidget::TabPosition position)\n", false, &_init_f_setTabPosition_2656, &_call_f_setTabPosition_2656);
  methods += new qt_gsi::GenericMethod ("setTabShape|tabShape=", "@brief Method void QMdiArea::setTabShape(QTabWidget::TabShape shape)\n", false, &_init_f_setTabShape_2300, &_call_f_setTabShape_2300);
  methods += new qt_gsi::GenericMethod ("setTabsClosable|tabsClosable=", "@brief Method void QMdiArea::setTabsClosable(bool closable)\n", false, &_init_f_setTabsClosable_864, &_call_f_setTabsClosable_864);
  methods += new qt_gsi::GenericMethod ("setTabsMovable|tabsMovable=", "@brief Method void QMdiArea::setTabsMovable(bool movable)\n", false, &_init_f_setTabsMovable_864, &_call_f_setTabsMovable_864);
  methods += new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QMdiArea::setViewMode(QMdiArea::ViewMode mode)\n", false, &_init_f_setViewMode_2092, &_call_f_setViewMode_2092);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QMdiArea::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("subWindowList", "@brief Method QList<QMdiSubWindow *> QMdiArea::subWindowList(QMdiArea::WindowOrder order)\n", true, &_init_f_subWindowList_c2432, &_call_f_subWindowList_c2432);
  methods += new qt_gsi::GenericMethod (":tabPosition", "@brief Method QTabWidget::TabPosition QMdiArea::tabPosition()\n", true, &_init_f_tabPosition_c0, &_call_f_tabPosition_c0);
  methods += new qt_gsi::GenericMethod (":tabShape", "@brief Method QTabWidget::TabShape QMdiArea::tabShape()\n", true, &_init_f_tabShape_c0, &_call_f_tabShape_c0);
  methods += new qt_gsi::GenericMethod (":tabsClosable", "@brief Method bool QMdiArea::tabsClosable()\n", true, &_init_f_tabsClosable_c0, &_call_f_tabsClosable_c0);
  methods += new qt_gsi::GenericMethod (":tabsMovable", "@brief Method bool QMdiArea::tabsMovable()\n", true, &_init_f_tabsMovable_c0, &_call_f_tabsMovable_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QMdiArea::testOption(QMdiArea::AreaOption opton)\n", true, &_init_f_testOption_c2302, &_call_f_testOption_c2302);
  methods += new qt_gsi::GenericMethod ("tileSubWindows", "@brief Method void QMdiArea::tileSubWindows()\n", false, &_init_f_tileSubWindows_0, &_call_f_tileSubWindows_0);
  methods += new qt_gsi::GenericMethod (":viewMode", "@brief Method QMdiArea::ViewMode QMdiArea::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QMdiArea::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMdiArea::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMdiArea::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QMdiSubWindow * > ("subWindowActivated(QMdiSubWindow *)", "subWindowActivated", gsi::arg("arg1"), "@brief Signal declaration for QMdiArea::subWindowActivated(QMdiSubWindow *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QMdiArea::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QMdiArea::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QMdiArea::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMdiArea::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

qt_gsi::QtNativeClass<QMdiArea> decl_QMdiArea (qtdecl_QAbstractScrollArea (), "QtWidgets", "QMdiArea_Native",
  methods_QMdiArea (),
  "@hide\n@alias QMdiArea");

GSI_QTWIDGETS_PUBLIC gsi::Class<QMdiArea> &qtdecl_QMdiArea () { return decl_QMdiArea; }

}


class QMdiArea_Adaptor : public QMdiArea, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMdiArea_Adaptor();

  //  [adaptor ctor] QMdiArea::QMdiArea(QWidget *parent)
  QMdiArea_Adaptor() : QMdiArea()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMdiArea::QMdiArea(QWidget *parent)
  QMdiArea_Adaptor(QWidget *parent) : QMdiArea(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMdiArea_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMdiArea::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMdiArea_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMdiArea::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QMdiArea::drawFrame(QPainter *)
  void fp_QMdiArea_drawFrame_1426 (QPainter *arg1) {
    QMdiArea::drawFrame(arg1);
  }

  //  [expose] bool QMdiArea::focusNextChild()
  bool fp_QMdiArea_focusNextChild_0 () {
    return QMdiArea::focusNextChild();
  }

  //  [expose] bool QMdiArea::focusPreviousChild()
  bool fp_QMdiArea_focusPreviousChild_0 () {
    return QMdiArea::focusPreviousChild();
  }

  //  [expose] bool QMdiArea::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMdiArea_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMdiArea::isSignalConnected(signal);
  }

  //  [expose] int QMdiArea::receivers(const char *signal)
  int fp_QMdiArea_receivers_c1731 (const char *signal) const {
    return QMdiArea::receivers(signal);
  }

  //  [expose] QObject *QMdiArea::sender()
  QObject * fp_QMdiArea_sender_c0 () const {
    return QMdiArea::sender();
  }

  //  [expose] int QMdiArea::senderSignalIndex()
  int fp_QMdiArea_senderSignalIndex_c0 () const {
    return QMdiArea::senderSignalIndex();
  }

  //  [expose] void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QMdiArea_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QMdiArea::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QMdiArea::setViewportMargins(const QMargins &margins)
  void fp_QMdiArea_setViewportMargins_2115 (const QMargins &margins) {
    QMdiArea::setViewportMargins(margins);
  }

  //  [expose] void QMdiArea::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QMdiArea_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QMdiArea::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [expose] QMargins QMdiArea::viewportMargins()
  QMargins fp_QMdiArea_viewportMargins_c0 () const {
    return QMdiArea::viewportMargins();
  }

  //  [emitter impl] void QMdiArea::customContextMenuRequested(const QPoint &pos)
  void emitter_QMdiArea_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QMdiArea::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QMdiArea::destroyed(QObject *)
  void emitter_QMdiArea_destroyed_1302(QObject *arg1)
  {
    emit QMdiArea::destroyed(arg1);
  }

  //  [adaptor impl] bool QMdiArea::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QMdiArea::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QMdiArea_Adaptor, bool>(&QMdiArea_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QMdiArea::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QMdiArea::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMdiArea::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMdiArea_Adaptor, int, int>(&QMdiArea_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMdiArea::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMdiArea::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMdiArea_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMdiArea_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMdiArea::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMdiArea::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMdiArea::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMdiArea_Adaptor, QSize>(&QMdiArea_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMdiArea::minimumSizeHint();
    }
  }

  //  [emitter impl] void QMdiArea::objectNameChanged(const QString &objectName)
  void emitter_QMdiArea_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMdiArea::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QMdiArea::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMdiArea::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMdiArea_Adaptor, QPaintEngine *>(&QMdiArea_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMdiArea::paintEngine();
    }
  }

  //  [adaptor impl] void QMdiArea::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMdiArea::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMdiArea_Adaptor, bool>(&QMdiArea_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMdiArea::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMdiArea::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMdiArea::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMdiArea_Adaptor, QSize>(&QMdiArea_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMdiArea::sizeHint();
    }
  }

  //  [emitter impl] void QMdiArea::subWindowActivated(QMdiSubWindow *)
  void emitter_QMdiArea_subWindowActivated_1915(QMdiSubWindow *arg1)
  {
    emit QMdiArea::subWindowActivated(arg1);
  }

  //  [emitter impl] void QMdiArea::windowIconChanged(const QIcon &icon)
  void emitter_QMdiArea_windowIconChanged_1787(const QIcon &icon)
  {
    emit QMdiArea::windowIconChanged(icon);
  }

  //  [emitter impl] void QMdiArea::windowIconTextChanged(const QString &iconText)
  void emitter_QMdiArea_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QMdiArea::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QMdiArea::windowTitleChanged(const QString &title)
  void emitter_QMdiArea_windowTitleChanged_2025(const QString &title)
  {
    emit QMdiArea::windowTitleChanged(title);
  }

  //  [adaptor impl] void QMdiArea::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QMdiArea::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMdiArea_Adaptor, QActionEvent *>(&QMdiArea_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QMdiArea::actionEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QMdiArea::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QMdiArea::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::childEvent(QChildEvent *childEvent)
  void cbs_childEvent_1701_0(QChildEvent *_childEvent)
  {
    QMdiArea::childEvent(_childEvent);
  }

  virtual void childEvent(QChildEvent *_childEvent)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMdiArea_Adaptor, QChildEvent *>(&QMdiArea_Adaptor::cbs_childEvent_1701_0, _childEvent);
    } else {
      QMdiArea::childEvent(_childEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QMdiArea::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMdiArea_Adaptor, QCloseEvent *>(&QMdiArea_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QMdiArea::closeEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QMdiArea::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMdiArea_Adaptor, QContextMenuEvent *>(&QMdiArea_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QMdiArea::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMdiArea::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMdiArea::customEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMdiArea::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMdiArea_Adaptor, const QMetaMethod &>(&QMdiArea_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMdiArea::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMdiArea::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMdiArea::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMdiArea_Adaptor, QDragEnterEvent *>(&QMdiArea_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMdiArea::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMdiArea::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMdiArea_Adaptor, QDragLeaveEvent *>(&QMdiArea_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMdiArea::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMdiArea::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMdiArea_Adaptor, QDragMoveEvent *>(&QMdiArea_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMdiArea::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMdiArea::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMdiArea_Adaptor, QDropEvent *>(&QMdiArea_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMdiArea::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QMdiArea::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QMdiArea_Adaptor, QEnterEvent *>(&QMdiArea_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QMdiArea::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QMdiArea::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMdiArea::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMdiArea_Adaptor, bool, QEvent *>(&QMdiArea_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMdiArea::event(_event);
    }
  }

  //  [adaptor impl] bool QMdiArea::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QMdiArea::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMdiArea_Adaptor, bool, QObject *, QEvent *>(&QMdiArea_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QMdiArea::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QMdiArea::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QMdiArea::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMdiArea_Adaptor, QFocusEvent *>(&QMdiArea_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QMdiArea::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QMdiArea::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMdiArea::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMdiArea_Adaptor, bool, bool>(&QMdiArea_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMdiArea::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMdiArea::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QMdiArea::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMdiArea_Adaptor, QFocusEvent *>(&QMdiArea_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QMdiArea::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QMdiArea::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMdiArea_Adaptor, QHideEvent *>(&QMdiArea_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QMdiArea::hideEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QMdiArea::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QMdiArea_Adaptor, QPainter *>(&QMdiArea_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QMdiArea::initPainter(painter);
    }
  }

  //  [adaptor impl] void QMdiArea::initStyleOption(QStyleOptionFrame *option)
  void cbs_initStyleOption_c2356_0(QStyleOptionFrame *option) const
  {
    QMdiArea::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionFrame *option) const
  {
    if (cb_initStyleOption_c2356_0.can_issue()) {
      cb_initStyleOption_c2356_0.issue<QMdiArea_Adaptor, QStyleOptionFrame *>(&QMdiArea_Adaptor::cbs_initStyleOption_c2356_0, option);
    } else {
      QMdiArea::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QMdiArea::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMdiArea::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMdiArea_Adaptor, QInputMethodEvent *>(&QMdiArea_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMdiArea::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QMdiArea::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMdiArea_Adaptor, QKeyEvent *>(&QMdiArea_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QMdiArea::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QMdiArea::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMdiArea_Adaptor, QKeyEvent *>(&QMdiArea_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QMdiArea::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QMdiArea::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QMdiArea::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMdiArea::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMdiArea_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMdiArea_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMdiArea::metric(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QMdiArea::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QMdiArea::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMdiArea_Adaptor, QMoveEvent *>(&QMdiArea_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QMdiArea::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QMdiArea::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QMdiArea::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QMdiArea_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QMdiArea_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QMdiArea::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QMdiArea::paintEvent(QPaintEvent *paintEvent)
  void cbs_paintEvent_1725_0(QPaintEvent *_paintEvent)
  {
    QMdiArea::paintEvent(_paintEvent);
  }

  virtual void paintEvent(QPaintEvent *_paintEvent)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMdiArea_Adaptor, QPaintEvent *>(&QMdiArea_Adaptor::cbs_paintEvent_1725_0, _paintEvent);
    } else {
      QMdiArea::paintEvent(_paintEvent);
    }
  }

  //  [adaptor impl] QPaintDevice *QMdiArea::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QMdiArea::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QMdiArea_Adaptor, QPaintDevice *, QPoint *>(&QMdiArea_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QMdiArea::redirected(offset);
    }
  }

  //  [adaptor impl] void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)
  void cbs_resizeEvent_1843_0(QResizeEvent *_resizeEvent)
  {
    QMdiArea::resizeEvent(_resizeEvent);
  }

  virtual void resizeEvent(QResizeEvent *_resizeEvent)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMdiArea_Adaptor, QResizeEvent *>(&QMdiArea_Adaptor::cbs_resizeEvent_1843_0, _resizeEvent);
    } else {
      QMdiArea::resizeEvent(_resizeEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QMdiArea::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QMdiArea_Adaptor, int, int>(&QMdiArea_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QMdiArea::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QMdiArea::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QMdiArea::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QMdiArea_Adaptor, QWidget *>(&QMdiArea_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QMdiArea::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QPainter *QMdiArea::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QMdiArea::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QMdiArea_Adaptor, QPainter *>(&QMdiArea_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QMdiArea::sharedPainter();
    }
  }

  //  [adaptor impl] void QMdiArea::showEvent(QShowEvent *showEvent)
  void cbs_showEvent_1634_0(QShowEvent *_showEvent)
  {
    QMdiArea::showEvent(_showEvent);
  }

  virtual void showEvent(QShowEvent *_showEvent)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMdiArea_Adaptor, QShowEvent *>(&QMdiArea_Adaptor::cbs_showEvent_1634_0, _showEvent);
    } else {
      QMdiArea::showEvent(_showEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QMdiArea::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMdiArea_Adaptor, QTabletEvent *>(&QMdiArea_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QMdiArea::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::timerEvent(QTimerEvent *timerEvent)
  void cbs_timerEvent_1730_0(QTimerEvent *_timerEvent)
  {
    QMdiArea::timerEvent(_timerEvent);
  }

  virtual void timerEvent(QTimerEvent *_timerEvent)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMdiArea_Adaptor, QTimerEvent *>(&QMdiArea_Adaptor::cbs_timerEvent_1730_0, _timerEvent);
    } else {
      QMdiArea::timerEvent(_timerEvent);
    }
  }

  //  [adaptor impl] bool QMdiArea::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QMdiArea::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QMdiArea_Adaptor, bool, QEvent *>(&QMdiArea_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QMdiArea::viewportEvent(event);
    }
  }

  //  [adaptor impl] QSize QMdiArea::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QMdiArea::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QMdiArea_Adaptor, QSize>(&QMdiArea_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QMdiArea::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QMdiArea::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMdiArea::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMdiArea_Adaptor, QWheelEvent *>(&QMdiArea_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMdiArea::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2356_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QMdiArea_Adaptor::~QMdiArea_Adaptor() { }

//  Constructor QMdiArea::QMdiArea(QWidget *parent) (adaptor class)

static void _init_ctor_QMdiArea_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QMdiArea_Adaptor> ();
}

static void _call_ctor_QMdiArea_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QMdiArea_Adaptor *> (new QMdiArea_Adaptor (arg1));
}


// void QMdiArea::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QMdiArea::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QMdiArea::childEvent(QChildEvent *childEvent)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("childEvent");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMdiArea::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QMdiArea::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_create_2208 (arg1, arg2, arg3);
}


// emitter void QMdiArea::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_customContextMenuRequested_1916 (arg1);
}


// void QMdiArea::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_destroy_1620 (arg1, arg2);
}


// emitter void QMdiArea::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_destroyed_1302 (arg1);
}


// void QMdiArea::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QMdiArea::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QMdiArea::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QMdiArea::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_drawFrame_1426 (arg1);
}


// void QMdiArea::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QMdiArea::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QMdiArea::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMdiArea::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QMdiArea::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QMdiArea::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_focusNextChild_0 ());
}


// bool QMdiArea::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QMdiArea::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QMdiArea::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_focusPreviousChild_0 ());
}


// bool QMdiArea::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QMdiArea::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QMdiArea::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QMdiArea::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QMdiArea::initStyleOption(QStyleOptionFrame *option)

static void _init_cbs_initStyleOption_c2356_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2356_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = args.read<QStyleOptionFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_initStyleOption_c2356_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2356_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_initStyleOption_c2356_0 = cb;
}


// void QMdiArea::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QMdiArea_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QMdiArea::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_isSignalConnected_c2394 (arg1));
}


// void QMdiArea::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QMdiArea::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QMdiArea::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QMdiArea::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiArea_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QMdiArea::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QMdiArea::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QMdiArea::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QMdiArea::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QMdiArea::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QMdiArea::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QMdiArea::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMdiArea_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QMdiArea::paintEvent(QPaintEvent *paintEvent)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paintEvent");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QMdiArea::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_receivers_c1731 (arg1));
}


// QPaintDevice *QMdiArea::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QMdiArea_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resizeEvent");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QMdiArea::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed QObject *QMdiArea::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_sender_c0 ());
}


// exposed int QMdiArea::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_senderSignalIndex_c0 ());
}


// exposed void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QMdiArea::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_setViewportMargins_2115 (arg1);
}


// void QMdiArea::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QMdiArea::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QMdiArea::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QMdiArea_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QMdiArea::showEvent(QShowEvent *showEvent)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("showEvent");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QMdiArea::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiArea_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// emitter void QMdiArea::subWindowActivated(QMdiSubWindow *)

static void _init_emitter_subWindowActivated_1915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMdiSubWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_subWindowActivated_1915 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMdiSubWindow *arg1 = gsi::arg_reader<QMdiSubWindow * >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_subWindowActivated_1915 (arg1);
}


// void QMdiArea::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QMdiArea::timerEvent(QTimerEvent *timerEvent)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerEvent");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QMdiArea::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_updateMicroFocus_2420 (arg1);
}


// bool QMdiArea::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QMdiArea::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_viewportMargins_c0 ());
}


// QSize QMdiArea::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiArea_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QMdiArea::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiArea_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QMdiArea::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_windowIconChanged_1787 (arg1);
}


// emitter void QMdiArea::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_windowIconTextChanged_2025 (arg1);
}


// emitter void QMdiArea::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiArea_Adaptor *)cls)->emitter_QMdiArea_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QMdiArea> &qtdecl_QMdiArea ();

static gsi::Methods methods_QMdiArea_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMdiArea::QMdiArea(QWidget *parent)\nThis method creates an object of class QMdiArea.", &_init_ctor_QMdiArea_Adaptor_1315, &_call_ctor_QMdiArea_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMdiArea::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMdiArea::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMdiArea::childEvent(QChildEvent *childEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMdiArea::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMdiArea::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QMdiArea::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMdiArea::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMdiArea::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMdiArea::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMdiArea::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMdiArea::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QMdiArea::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMdiArea::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMdiArea::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMdiArea::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMdiArea::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMdiArea::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QMdiArea::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMdiArea::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMdiArea::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QMdiArea::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QMdiArea::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMdiArea::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMdiArea::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QMdiArea::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QMdiArea::initStyleOption(QStyleOptionFrame *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0, &_set_callback_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMdiArea::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMdiArea::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMdiArea::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMdiArea::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMdiArea::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMdiArea::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMdiArea::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMdiArea::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMdiArea::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMdiArea::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QMdiArea::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMdiArea::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMdiArea::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMdiArea::paintEvent(QPaintEvent *paintEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMdiArea::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QMdiArea::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QMdiArea::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMdiArea::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMdiArea::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QMdiArea::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMdiArea::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@brief Virtual method void QMdiArea::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QMdiArea::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMdiArea::showEvent(QShowEvent *showEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMdiArea::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_subWindowActivated", "@brief Emitter for signal void QMdiArea::subWindowActivated(QMdiSubWindow *)\nCall this method to emit this signal.", false, &_init_emitter_subWindowActivated_1915, &_call_emitter_subWindowActivated_1915);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMdiArea::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMdiArea::timerEvent(QTimerEvent *timerEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QMdiArea::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QMdiArea::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QMdiArea::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QMdiArea::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMdiArea::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QMdiArea::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QMdiArea::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QMdiArea::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QMdiArea_Adaptor> decl_QMdiArea_Adaptor (qtdecl_QMdiArea (), "QtWidgets", "QMdiArea",
  methods_QMdiArea_Adaptor (),
  "@qt\n@brief Binding of QMdiArea");

}


//  Implementation of the enum wrapper class for QMdiArea::AreaOption
namespace qt_gsi
{

static gsi::Enum<QMdiArea::AreaOption> decl_QMdiArea_AreaOption_Enum ("QtWidgets", "QMdiArea_AreaOption",
    gsi::enum_const ("DontMaximizeSubWindowOnActivation", QMdiArea::DontMaximizeSubWindowOnActivation, "@brief Enum constant QMdiArea::DontMaximizeSubWindowOnActivation"),
  "@qt\n@brief This class represents the QMdiArea::AreaOption enum");

static gsi::QFlagsClass<QMdiArea::AreaOption > decl_QMdiArea_AreaOption_Enums ("QtWidgets", "QMdiArea_QFlags_AreaOption",
  "@qt\n@brief This class represents the QFlags<QMdiArea::AreaOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_AreaOption_Enum_in_parent (decl_QMdiArea_AreaOption_Enum.defs ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_AreaOption_Enum_as_child (decl_QMdiArea_AreaOption_Enum, "AreaOption");
static gsi::ClassExt<QMdiArea> decl_QMdiArea_AreaOption_Enums_as_child (decl_QMdiArea_AreaOption_Enums, "QFlags_AreaOption");

}


//  Implementation of the enum wrapper class for QMdiArea::ViewMode
namespace qt_gsi
{

static gsi::Enum<QMdiArea::ViewMode> decl_QMdiArea_ViewMode_Enum ("QtWidgets", "QMdiArea_ViewMode",
    gsi::enum_const ("SubWindowView", QMdiArea::SubWindowView, "@brief Enum constant QMdiArea::SubWindowView") +
    gsi::enum_const ("TabbedView", QMdiArea::TabbedView, "@brief Enum constant QMdiArea::TabbedView"),
  "@qt\n@brief This class represents the QMdiArea::ViewMode enum");

static gsi::QFlagsClass<QMdiArea::ViewMode > decl_QMdiArea_ViewMode_Enums ("QtWidgets", "QMdiArea_QFlags_ViewMode",
  "@qt\n@brief This class represents the QFlags<QMdiArea::ViewMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_ViewMode_Enum_in_parent (decl_QMdiArea_ViewMode_Enum.defs ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_ViewMode_Enum_as_child (decl_QMdiArea_ViewMode_Enum, "ViewMode");
static gsi::ClassExt<QMdiArea> decl_QMdiArea_ViewMode_Enums_as_child (decl_QMdiArea_ViewMode_Enums, "QFlags_ViewMode");

}


//  Implementation of the enum wrapper class for QMdiArea::WindowOrder
namespace qt_gsi
{

static gsi::Enum<QMdiArea::WindowOrder> decl_QMdiArea_WindowOrder_Enum ("QtWidgets", "QMdiArea_WindowOrder",
    gsi::enum_const ("CreationOrder", QMdiArea::CreationOrder, "@brief Enum constant QMdiArea::CreationOrder") +
    gsi::enum_const ("StackingOrder", QMdiArea::StackingOrder, "@brief Enum constant QMdiArea::StackingOrder") +
    gsi::enum_const ("ActivationHistoryOrder", QMdiArea::ActivationHistoryOrder, "@brief Enum constant QMdiArea::ActivationHistoryOrder"),
  "@qt\n@brief This class represents the QMdiArea::WindowOrder enum");

static gsi::QFlagsClass<QMdiArea::WindowOrder > decl_QMdiArea_WindowOrder_Enums ("QtWidgets", "QMdiArea_QFlags_WindowOrder",
  "@qt\n@brief This class represents the QFlags<QMdiArea::WindowOrder> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_WindowOrder_Enum_in_parent (decl_QMdiArea_WindowOrder_Enum.defs ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_WindowOrder_Enum_as_child (decl_QMdiArea_WindowOrder_Enum, "WindowOrder");
static gsi::ClassExt<QMdiArea> decl_QMdiArea_WindowOrder_Enums_as_child (decl_QMdiArea_WindowOrder_Enums, "QFlags_WindowOrder");

}

