/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

final class TDSChannel {
    private static final Logger logger;
    private final SQLServerConnection con;
    private TDSWriter tdsWriter;
    private Socket tcpSocket;
    private Socket socket;
    ProxySocket proxySocket = null;
    private boolean isClosed;
    private InputStream tcpInputStream;
    private OutputStream tcpOutputStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static Logger packetLogger;
    private final boolean isLoggingPackets = packetLogger.isLoggable(Level.FINEST);
    int numMsgsSent = 0;
    int numMsgsRcvd = 0;
    private static final String SEPARATOR;
    private static final String JAVA_HOME;
    private static final String JSSECACERTS;
    private static final String CACERTS;
    static final /* synthetic */ boolean $assertionsDisabled;

    final Logger getLogger() {
        return logger;
    }

    final String toLogString() {
        return "TDSChannel (" + this.con.toLogString() + ")";
    }

    final TDSWriter getWriter() {
        if (null == this.tdsWriter) {
            this.tdsWriter = new TDSWriter(this, this.con);
        }
        return this.tdsWriter;
    }

    final TDSReader getReader() {
        return new TDSReader(this, this.con);
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    final void setSendBufferSize(int n) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Setting TCP SEND buffer size:" + n);
            }
            this.tcpSocket.setSendBufferSize(n);
        }
        catch (SocketException socketException) {
            logger.fine(this.toLogString() + " Ignored error setting TCP SEND buffer size: " + socketException.getMessage());
        }
    }

    final void setRecvBufferSize(int n) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Setting TCP RECV buffer size:" + n);
            }
            this.tcpSocket.setReceiveBufferSize(n);
        }
        catch (SocketException socketException) {
            logger.fine(this.toLogString() + " Ignored error setting TCP RECV buffer size: " + socketException.getMessage());
        }
    }

    final boolean isLoggingPackets() {
        return this.isLoggingPackets;
    }

    TDSChannel(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.isClosed = false;
        this.tcpSocket = null;
        this.socket = null;
        this.tcpInputStream = null;
        this.tcpOutputStream = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    final void open(String string, int n, int n2) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + ": Opening TCP socket...");
        }
        if (0 == n2) {
            this.socket = this.tcpSocket = new Socket(string, n);
        } else {
            this.socket = this.tcpSocket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException();
            }
            this.tcpSocket.connect(inetSocketAddress, n2);
        }
        this.setSendBufferSize(4096);
        this.setRecvBufferSize(4096);
        this.tcpSocket.setTcpNoDelay(true);
        this.tcpSocket.setKeepAlive(true);
        this.inputStream = this.tcpInputStream = this.tcpSocket.getInputStream();
        this.outputStream = this.tcpOutputStream = this.tcpSocket.getOutputStream();
    }

    void disableSSL() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " Disabling SSL...");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing InputStream: " + iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing OutputStream: " + iOException.getMessage());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toLogString() + " Rewiring proxy streams for SSL socket close");
        }
        this.proxySocket.setStreams(byteArrayInputStream, byteArrayOutputStream);
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Closing SSL socket");
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing SSLSocket: " + iOException.getMessage());
        }
        this.proxySocket = null;
        this.inputStream = this.tcpInputStream;
        this.outputStream = this.tcpOutputStream;
        this.socket = this.tcpSocket;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " SSL disabled");
        }
    }

    private final void throwSSLConnectionFailed(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_sslFailed"));
        Object[] objectArray = new Object[]{string};
        this.con.terminate(5, messageFormat.format(objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void enableSSL(String string, int n) throws SQLServerException {
        Object object;
        TrustManager[] trustManagerArray;
        block63: {
            Object object2;
            String string2;
            block59: {
                block58: {
                    String string3;
                    String string4;
                    block64: {
                        block62: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine(this.toLogString() + " Enabling SSL...");
                            }
                            string4 = this.con.activeConnectionProperties.getProperty("trustStore");
                            string3 = this.con.activeConnectionProperties.getProperty("trustStorePassword");
                            string2 = this.con.activeConnectionProperties.getProperty("hostNameInCertificate");
                            if (!$assertionsDisabled && 0 != this.con.getRequestedEncryptionLevel() && 1 != this.con.getRequestedEncryptionLevel()) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && 0 != this.con.getNegotiatedEncryptionLevel() && 1 != this.con.getNegotiatedEncryptionLevel() && 3 != this.con.getNegotiatedEncryptionLevel()) {
                                throw new AssertionError();
                            }
                            trustManagerArray = null;
                            if (0 != this.con.getRequestedEncryptionLevel() && (1 != this.con.getRequestedEncryptionLevel() || !this.con.trustServerCertificate())) break block62;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine(this.toLogString() + " SSL handshake will trust any certificate");
                            }
                            trustManagerArray = new TrustManager[]{new PermissiveX509TrustManager(this)};
                            break block63;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toLogString() + " SSL handshake will validate server certificate");
                        }
                        object = null;
                        if (null != string4 || null != string3) break block64;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toLogString() + " Using system default trust store and password");
                        }
                        break block59;
                    }
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toLogString() + " Finding key store interface");
                        }
                        object = KeyStore.getInstance("JKS");
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toLogString() + " Error getting key store interface: " + exception.getMessage());
                        }
                        this.throwSSLConnectionFailed(exception.getMessage());
                    }
                    if (!$assertionsDisabled && null == object) {
                        throw new AssertionError();
                    }
                    object2 = this.loadTrustStore(string4);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toLogString() + " Loading key store");
                    }
                    ((KeyStore)object).load((InputStream)object2, null == string3 ? null : string3.toCharArray());
                    Object var11_16 = null;
                    this.con.activeConnectionProperties.remove("trustStorePassword");
                    if (null == object2) break block59;
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.FINE)) break block58;
                        logger.fine(this.toLogString() + " Ignoring error closing trust material InputStream...");
                    }
                }
                object2 = null;
                {
                    break block59;
                    catch (Exception exception) {
                        block60: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine(this.toLogString() + " Error loading key store: " + exception.getMessage());
                            }
                            this.throwSSLConnectionFailed(exception.getMessage());
                            Object var11_17 = null;
                            this.con.activeConnectionProperties.remove("trustStorePassword");
                            if (null == object2) break block59;
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (IOException iOException) {
                                if (!logger.isLoggable(Level.FINE)) break block60;
                                logger.fine(this.toLogString() + " Ignoring error closing trust material InputStream...");
                            }
                        }
                        object2 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    this.con.activeConnectionProperties.remove("trustStorePassword");
                    if (null != object2) {
                        block61: {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (IOException iOException) {
                                if (!logger.isLoggable(Level.FINE)) break block61;
                                logger.fine(this.toLogString() + " Ignoring error closing trust material InputStream...");
                            }
                        }
                        object2 = null;
                    }
                    throw throwable;
                }
            }
            object2 = null;
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toLogString() + " Locating X.509 trust manager factory");
                }
                object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            catch (Exception exception) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.toLogString() + " Error locating X.509 trust manager factory: " + exception.getMessage());
                }
                this.throwSSLConnectionFailed(exception.getMessage());
            }
            if (!$assertionsDisabled && null == object2) {
                throw new AssertionError();
            }
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toLogString() + " Getting trust manager");
                }
                ((TrustManagerFactory)object2).init((KeyStore)object);
            }
            catch (Exception exception) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.toLogString() + " Error initializing trust manager factory with trust material: " + exception.getMessage());
                }
                this.throwSSLConnectionFailed(exception.getMessage());
            }
            trustManagerArray = ((TrustManagerFactory)object2).getTrustManagers();
            trustManagerArray = null != string2 ? new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], string2)} : new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], this.tcpSocket.getInetAddress().getCanonicalHostName())};
        }
        object = null;
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Getting SSLv3 or better SSL context");
            }
            object = SSLContext.getInstance("SSLv3");
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error getting SSLv3 or better SSL context: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        if (!$assertionsDisabled && null == object) {
            throw new AssertionError();
        }
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Initializing SSL context");
            }
            ((SSLContext)object).init(null, trustManagerArray, null);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error initializing SSL context: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        this.proxySocket = new ProxySocket(this);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Creating SSL socket");
            }
            this.socket = ((SSLContext)object).getSocketFactory().createSocket(this.proxySocket, string, n, false);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error creating SSL socket: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Starting SSL handshake");
            }
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(this.toLogString() + " SSL handshake failed: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toLogString() + " Rewiring proxy streams after handshake");
        }
        this.proxySocket.setStreams(this.inputStream, this.outputStream);
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Getting SSL InputStream");
            }
            this.inputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error getting SSL InputStream: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toLogString() + " Getting SSL OutputStream");
            }
            this.outputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error getting SSL OutputStream: " + exception.getMessage());
            }
            this.throwSSLConnectionFailed(exception.getMessage());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " SSL enabled");
        }
    }

    final InputStream loadTrustStore(String string) {
        FileInputStream fileInputStream;
        block17: {
            block18: {
                fileInputStream = null;
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toLogString() + " Opening specified trust store: " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toLogString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                string = System.getProperty("javax.net.ssl.trustStore");
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toLogString() + " Opening default trust store (from javax.net.ssl.trustStore): " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toLogString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toLogString() + " Opening default trust store: " + JSSECACERTS);
                    }
                    fileInputStream = new FileInputStream(JSSECACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINEST)) break block18;
                    logger.finest(this.toLogString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
            if (null == fileInputStream) {
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toLogString() + " Opening default trust store: " + CACERTS);
                    }
                    fileInputStream = new FileInputStream(CACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.fine(this.toLogString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
        }
        return fileInputStream;
    }

    final int read(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " read failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
            return 0;
        }
    }

    final void write(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            this.outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " write failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void flush() throws SQLServerException {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " flush failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void close() {
        if (null != this.proxySocket) {
            this.disableSSL();
        }
        if (null != this.inputStream) {
            block13: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toLogString() + ": Closing inputStream...");
                }
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block13;
                    logger.log(Level.FINE, this.toLogString() + ": Ignored error closing inputStream", iOException);
                }
            }
            this.inputStream = null;
        }
        if (null != this.outputStream) {
            block14: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toLogString() + ": Closing outputStream...");
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block14;
                    logger.log(Level.FINE, this.toLogString() + ": Ignored error closing outputStream", iOException);
                }
            }
            this.outputStream = null;
        }
        if (null != this.tcpSocket) {
            block15: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.toLogString() + ": Closing TCP socket...");
                }
                try {
                    this.tcpSocket.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block15;
                    logger.log(Level.FINE, this.toLogString() + ": Ignored error closing socket", iOException);
                }
            }
            this.tcpSocket = null;
        }
        this.isClosed = true;
    }

    void logPacket(byte[] byArray, int n, int n2, String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4 * n2 + 4 * (1 + n2 / 16) + 80);
        stringBuffer.append(this.tcpSocket.getLocalAddress().toString() + ":" + this.tcpSocket.getLocalPort() + " " + string + "\r\n");
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 16 && n3 < n2; ++n5, ++n3) {
                n4 = (byArray[n + n3] + 256) % 256;
                cArray4[3 * n5] = cArray[n4 / 16];
                cArray4[3 * n5 + 1] = cArray[n4 % 16];
                cArray4[50 + n5] = cArray2[n4];
            }
            for (n4 = n5; n4 < 16; ++n4) {
                cArray4[3 * n4] = 32;
                cArray4[3 * n4 + 1] = 32;
            }
            stringBuffer.append(cArray4, 0, 50 + n5);
            if (n3 == n2) break;
            stringBuffer.append("\r\n");
        }
        packetLogger.finest(stringBuffer.toString());
    }

    static {
        $assertionsDisabled = !TDSChannel.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSChannel");
        packetLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.DATA");
        SEPARATOR = System.getProperty("file.separator");
        JAVA_HOME = System.getProperty("java.home");
        JSSECACERTS = JAVA_HOME + SEPARATOR + "lib" + SEPARATOR + "security" + SEPARATOR + "jssecacerts";
        CACERTS = JAVA_HOME + SEPARATOR + "lib" + SEPARATOR + "security" + SEPARATOR + "cacerts";
    }

    private final class HostNameOverrideX509TrustManager
    implements X509TrustManager {
        private final Logger logger;
        private final String logContext;
        private final X509TrustManager defaultTrustManager;
        private String hostName;

        HostNameOverrideX509TrustManager(TDSChannel tDSChannel2, X509TrustManager x509TrustManager, String string) {
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toLogString() + " (HostNameOverrideX509TrustManager):";
            this.defaultTrustManager = x509TrustManager;
            this.hostName = string.toLowerCase();
        }

        private String parseCommonName(String string) {
            int n = string.indexOf("cn=");
            if (n == -1) {
                return null;
            }
            string = string.substring(n + 3);
            for (n = 0; n < string.length() && string.charAt(n) != ','; ++n) {
            }
            String string2 = string.substring(0, n);
            if (string2.length() > 1 && '\"' == string2.charAt(0)) {
                string2 = '\"' == string2.charAt(string2.length() - 1) ? string2.substring(1, string2.length() - 1) : null;
            }
            return string2;
        }

        private void validateServerNameInCertificate(String string) throws CertificateException {
            String string2;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Validating the server name:" + this.hostName);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " The DN name in certificate:" + string);
            }
            if (null == (string2 = this.parseCommonName(string))) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.logContext + " Failed to parse the subject name from the certificate or certificate subject name is empty.");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (!string2.startsWith(this.hostName)) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.logContext + " The name in certificate does not start with the server name.");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string2)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (this.hostName.length() != string2.length() && '.' != string2.charAt(this.hostName.length())) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.logContext + " The name in certificate does not start with the server name and end in a period(.).");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string2)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.logContext + " The name in certificate:" + string2 + " validated.");
            }
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding ClientTrusted.");
            }
            this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding Trusting server certificate");
            }
            this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " default serverTrusted succeeded proceeding with server name validation");
            }
            this.validateServerNameInCertificate(x509CertificateArray[0].getSubjectX500Principal().getName("canonical"));
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }
    }

    private final class PermissiveX509TrustManager
    implements X509TrustManager {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;

        PermissiveX509TrustManager(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toLogString() + " (PermissiveX509TrustManager):";
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.logContext + " Trusting client certificate (!)");
            }
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.logContext + " Trusting server certificate");
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private class ProxySocket
    extends Socket {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;
        private final ProxyInputStream proxyInputStream;
        private final ProxyOutputStream proxyOutputStream;

        ProxySocket(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toLogString() + " (ProxySocket):";
            SSLHandshakeOutputStream sSLHandshakeOutputStream = new SSLHandshakeOutputStream(tDSChannel2);
            SSLHandshakeInputStream sSLHandshakeInputStream = new SSLHandshakeInputStream(tDSChannel2, sSLHandshakeOutputStream);
            this.proxyOutputStream = new ProxyOutputStream(sSLHandshakeOutputStream);
            this.proxyInputStream = new ProxyInputStream(sSLHandshakeInputStream);
        }

        void setStreams(InputStream inputStream, OutputStream outputStream) {
            this.proxyInputStream.setFilteredStream(inputStream);
            this.proxyOutputStream.setFilteredStream(outputStream);
        }

        public InputStream getInputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting input stream");
            }
            return this.proxyInputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting output stream");
            }
            return this.proxyOutputStream;
        }

        public InetAddress getInetAddress() {
            return this.tdsChannel.tcpSocket.getInetAddress();
        }

        public boolean getKeepAlive() throws SocketException {
            return this.tdsChannel.tcpSocket.getKeepAlive();
        }

        public InetAddress getLocalAddress() {
            return this.tdsChannel.tcpSocket.getLocalAddress();
        }

        public int getLocalPort() {
            return this.tdsChannel.tcpSocket.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.tdsChannel.tcpSocket.getLocalSocketAddress();
        }

        public boolean getOOBInline() throws SocketException {
            return this.tdsChannel.tcpSocket.getOOBInline();
        }

        public int getPort() {
            return this.tdsChannel.tcpSocket.getPort();
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getReceiveBufferSize();
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.tdsChannel.tcpSocket.getRemoteSocketAddress();
        }

        public boolean getReuseAddress() throws SocketException {
            return this.tdsChannel.tcpSocket.getReuseAddress();
        }

        public int getSendBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getSendBufferSize();
        }

        public int getSoLinger() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoLinger();
        }

        public int getSoTimeout() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoTimeout();
        }

        public boolean getTcpNoDelay() throws SocketException {
            return this.tdsChannel.tcpSocket.getTcpNoDelay();
        }

        public int getTrafficClass() throws SocketException {
            return this.tdsChannel.tcpSocket.getTrafficClass();
        }

        public boolean isBound() {
            return true;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isConnected() {
            return true;
        }

        public boolean isInputShutdown() {
            return false;
        }

        public boolean isOutputShutdown() {
            return false;
        }

        public String toString() {
            return this.tdsChannel.tcpSocket.toString();
        }

        public void bind(SocketAddress socketAddress) throws IOException {
            throw new IOException();
        }

        public void connect(SocketAddress socketAddress) throws IOException {
            throw new IOException();
        }

        public void connect(SocketAddress socketAddress, int n) throws IOException {
            throw new IOException();
        }

        public SocketChannel getChannel() {
            return null;
        }

        public void close() throws IOException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.logContext + " Ignoring close");
            }
        }

        public void setReceiveBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setReceiveBufferSize size:" + n);
            }
        }

        public void setSendBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setSendBufferSize size:" + n);
            }
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setReuseAddress");
            }
        }

        public void setSoLinger(boolean bl, int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setSoLinger");
            }
        }

        public void setSoTimeout(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setSoTimeout");
            }
        }

        public void setTcpNoDelay(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setTcpNoDelay");
            }
        }

        public void setTrafficClass(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setTrafficClass");
            }
        }

        public void shutdownInput() throws IOException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring shutdownInput");
            }
        }

        public void shutdownOutput() throws IOException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring shutdownOutput");
            }
        }

        public void sendUrgentData(int n) throws IOException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring sendUrgentData");
            }
        }

        public void setKeepAlive(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setKeepAlive");
            }
        }

        public void setOOBInline(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(TDSChannel.this.toLogString() + " Ignoring setOOBInline");
            }
        }
    }

    final class ProxyOutputStream
    extends OutputStream {
        private OutputStream filteredStream;

        ProxyOutputStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        final void setFilteredStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Closing");
            }
            this.filteredStream.close();
        }

        public void flush() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Flushing");
            }
            this.filteredStream.flush();
        }

        public void write(byte[] byArray) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Writing " + byArray.length + " bytes");
            }
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Writing " + n2 + " bytes");
            }
            this.filteredStream.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Writing single byte");
            }
            this.filteredStream.write(n);
        }
    }

    private final class ProxyInputStream
    extends InputStream {
        private InputStream filteredStream;

        ProxyInputStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        final void setFilteredStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        public long skip(long l) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Skipping " + l + " bytes");
            }
            long l2 = this.filteredStream.skip(l);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Skipped " + l + " bytes");
            }
            return l2;
        }

        public int available() throws IOException {
            int n = this.filteredStream.available();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " " + n + " bytes available");
            }
            return n;
        }

        public int read() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Reading next byte");
            }
            return this.filteredStream.read();
        }

        public int read(byte[] byArray) throws IOException {
            int n = 0;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Reading " + byArray.length + " bytes");
            }
            try {
                n = this.filteredStream.read(byArray);
            }
            catch (IOException iOException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(TDSChannel.this.toLogString() + " " + iOException.getMessage());
                }
                throw iOException;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Read " + n + " bytes");
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Reading " + n2 + " bytes");
            }
            try {
                n3 = this.filteredStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(TDSChannel.this.toLogString() + " " + iOException.getMessage());
                }
                throw iOException;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Read " + n3 + " bytes");
            }
            return n3;
        }

        public boolean markSupported() {
            boolean bl = this.filteredStream.markSupported();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Returning markSupported: " + bl);
            }
            return bl;
        }

        public void mark(int n) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Marking next " + n + " bytes");
            }
            this.filteredStream.mark(n);
        }

        public void reset() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Resetting to previous mark");
            }
            this.filteredStream.reset();
        }

        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(TDSChannel.this.toLogString() + " Closing");
            }
            this.filteredStream.close();
        }
    }

    private class SSLHandshakeOutputStream
    extends OutputStream {
        private final TDSWriter tdsWriter;
        private boolean messageStarted;
        private final Logger logger;
        private final String logContext;
        private final byte[] singleByte = new byte[1];
        static final /* synthetic */ boolean $assertionsDisabled;

        SSLHandshakeOutputStream(TDSChannel tDSChannel2) {
            this.tdsWriter = tDSChannel2.getWriter();
            this.messageStarted = false;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toLogString() + " (SSLHandshakeOutputStream):";
        }

        public void flush() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Ignored a request to flush the stream");
            }
        }

        void endMessage() throws SQLServerException {
            if (!$assertionsDisabled && !this.messageStarted) {
                throw new AssertionError();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Finishing TDS message");
            }
            this.tdsWriter.endMessage();
            this.messageStarted = false;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                if (!this.messageStarted) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.logContext + " Starting new TDS packet...");
                    }
                    this.tdsWriter.startMessage((byte)18);
                    this.messageStarted = true;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Writing " + n2 + " bytes...");
                }
                this.tdsWriter.writeBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                throw new IOException(sQLServerException.getMessage());
            }
        }

        public void write(int n) throws IOException {
            this.singleByte[0] = (byte)(n & 0xFF);
            this.write(this.singleByte, 0, this.singleByte.length);
        }

        static {
            $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$TDSChannel == null ? (class$com$microsoft$sqlserver$jdbc$TDSChannel = TDSChannel.class$("com.microsoft.sqlserver.jdbc.TDSChannel")) : class$com$microsoft$sqlserver$jdbc$TDSChannel).desiredAssertionStatus();
        }
    }

    private class SSLHandshakeInputStream
    extends InputStream {
        private final TDSReader tdsReader;
        private final SSLHandshakeOutputStream sslHandshakeOutputStream;
        private final Logger logger;
        private final String logContext;
        private final byte[] oneByte = new byte[1];
        static final /* synthetic */ boolean $assertionsDisabled;

        SSLHandshakeInputStream(TDSChannel tDSChannel2, SSLHandshakeOutputStream sSLHandshakeOutputStream) {
            this.tdsReader = tDSChannel2.getReader();
            this.sslHandshakeOutputStream = sSLHandshakeOutputStream;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toLogString() + " (SSLHandshakeInputStream):";
        }

        private final void ensureSSLPayload() throws IOException {
            if (0 == this.tdsReader.available()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " No handshake response bytes available. Flushing SSL handshake output stream.");
                }
                try {
                    this.sslHandshakeOutputStream.endMessage();
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.fine(this.logContext + " Ending TDS message threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Reading first packet of SSL handshake response");
                }
                try {
                    this.tdsReader.readPacket(this.tdsReader.getConnection().isYukonOrLater() ? 18 : 4);
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.fine(this.logContext + " Reading response packet threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
            }
        }

        public long skip(long l) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Skipping " + l + " bytes...");
            }
            if (l <= 0L) {
                return 0L;
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.skip((int)l);
            }
            catch (SQLServerException sQLServerException) {
                sQLServerException.printStackTrace();
                throw new IOException(sQLServerException.getMessage());
            }
            return l;
        }

        public int read() throws IOException {
            int n;
            while (0 == (n = this.read(this.oneByte, 0, this.oneByte.length))) {
            }
            if (!$assertionsDisabled && 1 != n && -1 != n) {
                throw new AssertionError();
            }
            return 1 == n ? this.oneByte[0] : -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Reading " + n2 + " bytes...");
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.readBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                throw new IOException(sQLServerException.getMessage());
            }
            return n2;
        }

        static {
            $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$TDSChannel == null ? (class$com$microsoft$sqlserver$jdbc$TDSChannel = TDSChannel.class$("com.microsoft.sqlserver.jdbc.TDSChannel")) : class$com$microsoft$sqlserver$jdbc$TDSChannel).desiredAssertionStatus();
        }
    }
}

