/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//  Purpose:
//     Intel(R) Cryptography Primitives Library
//     Unsigned internal BNU32 misc functionality
//
//  Contents:
//     cpToOctStr_BNU32()
//
*/

#include "owncp.h"
#include "pcpbnuimpl.h"
#include "pcpbnumisc.h"
#include "pcpbnu32misc.h"

/*F*
//    Name: cpFromOctStr_BNU32
//
// Purpose: Convert Oct String into BNU representation.
//
// Returns:
//          size of BNU in BNU_CHUNK_T chunks
//
// Parameters:
//    pOctStr     pointer to the source octet string
//    strLen      octet string length
//    pBNU        pointer to the target BN
//
*F*/

IPP_OWN_DEFN(cpSize, cpFromOctStr_BNU32, (Ipp32u * pBNU, const Ipp8u* pOctStr, cpSize strLen))
{
    cpSize bnuSize = 0;
    *pBNU          = 0;

    /* start from the end of string */
    for (; strLen >= 4; bnuSize++, strLen -= 4) {
        /* pack 4 bytes into single Ipp32u value*/
        *pBNU++ = (Ipp32u)((pOctStr[strLen - 4] << (8 * 3)) + (pOctStr[strLen - 3] << (8 * 2)) +
                           (pOctStr[strLen - 2] << (8 * 1)) + pOctStr[strLen - 1]);
    }

    /* convert the beginning of the string */
    if (strLen) {
        Ipp32u x;
        for (x = 0; strLen > 0; strLen--) {
            Ipp32u d = *pOctStr++;
            x        = x * 256 + d;
        }
        *pBNU++ = x;
        bnuSize++;
    }

    return bnuSize ? bnuSize : 1;
}
