/*
 ==============================================================================
 This file is part of the IEM plug-in suite.
 Author: Daniel Rudrich
 Copyright (c) 2018 - Institute of Electronic Music and Acoustics (IEM)
 https://iem.at

 The IEM plug-in suite is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation,  either version 3 of the License,  or
 (at your option) any later version.

 The IEM plug-in suite is distributed in the hope that it will be useful,  but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this software.  If not,  see <http://www.gnu.org/licenses/>.
 ==============================================================================
 */

/*
 This data originates from https://matplotlib.org/examples/color/colormaps_reference.html.
 The following rgb color data is cropped and stretched.
 */

#pragma once

 const float heatmap[256][4]= {{5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 0.0000000000000000e+00},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 5.4901960784313726e-03},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.0980392156862745e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.6470588235294119e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.1960784313725491e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.7450980392156866e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 3.2941176470588238e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 3.8431372549019613e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 4.3921568627450981e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 4.9411764705882356e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 5.4901960784313732e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 6.0392156862745107e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 6.5882352941176475e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 7.1372549019607850e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 7.6862745098039226e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 8.2352941176470601e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 8.7843137254901962e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 9.3333333333333338e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 9.8823529411764713e-02},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.0431372549019609e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.0980392156862746e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.1529411764705884e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.2078431372549021e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.2627450980392158e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.3176470588235295e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.3725490196078433e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.4274509803921570e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.4823529411764708e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.5372549019607845e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.5921568627450983e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.6470588235294120e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.7019607843137258e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.7568627450980392e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.8117647058823533e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.8666666666666668e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.9215686274509808e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 1.9764705882352943e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.0156862745098042e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.0431372549019611e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.0705882352941177e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.0980392156862746e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.1254901960784317e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.1529411764705886e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.1803921568627455e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.2078431372549023e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.2352941176470592e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.2627450980392155e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.2901960784313727e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.3176470588235296e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.3450980392156864e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.3725490196078433e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.4000000000000002e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.4274509803921568e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.4549019607843137e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.4823529411764705e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.5098039215686274e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.5372549019607843e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.5647058823529412e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.5921568627450980e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.6196078431372549e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.6470588235294118e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.6745098039215687e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.7019607843137255e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.7294117647058824e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.7568627450980393e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.7843137254901962e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.8117647058823531e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.8392156862745094e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.8666666666666668e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.8941176470588231e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.9215686274509806e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.9490196078431369e-01},
                                     {5.2941176470588236e-01, 8.0784313725490198e-01, 9.2156862745098034e-01, 2.9764705882352943e-01},
                                     {5.2799054209919261e-01, 8.0710649750096120e-01, 9.1825659361783929e-01, 3.0274509803921568e-01},
                                     {5.1804198385236444e-01, 8.0195001922337550e-01, 8.9507235678585129e-01, 3.2196078431372566e-01},
                                     {5.0809342560553628e-01, 7.9679354094579002e-01, 8.7188811995386362e-01, 3.4117647058823541e-01},
                                     {4.9814486735870811e-01, 7.9163706266820444e-01, 8.4870388312187606e-01, 3.6039215686274512e-01},
                                     {4.8819630911188000e-01, 7.8648058439061896e-01, 8.2551964628988839e-01, 3.7960784313725487e-01},
                                     {4.7824775086505183e-01, 7.8132410611303349e-01, 8.0233540945790061e-01, 3.9882352941176491e-01},
                                     {4.6829919261822373e-01, 7.7616762783544790e-01, 7.7915117262591294e-01, 4.1803921568627461e-01},
                                     {4.5835063437139562e-01, 7.7101114955786232e-01, 7.5596693579392538e-01, 4.3725490196078437e-01},
                                     {4.4840207612456751e-01, 7.6585467128027673e-01, 7.3278269896193771e-01, 4.5647058823529407e-01},
                                     {4.3845351787773928e-01, 7.6069819300269126e-01, 7.0959846212994981e-01, 4.7568627450980416e-01},
                                     {4.2850495963091112e-01, 7.5554171472510567e-01, 6.8641422529796214e-01, 4.9490196078431387e-01},
                                     {4.1855640138408301e-01, 7.5038523644752031e-01, 6.6322998846597458e-01, 5.1411764705882357e-01},
                                     {4.0860784313725496e-01, 7.4522875816993472e-01, 6.4004575163398691e-01, 5.3333333333333333e-01},
                                     {3.9865928489042668e-01, 7.4007227989234903e-01, 6.1686151480199902e-01, 5.5254901960784331e-01},
                                     {3.8871072664359857e-01, 7.3491580161476344e-01, 5.9367727797001135e-01, 5.7176470588235306e-01},
                                     {3.7876216839677046e-01, 7.2975932333717797e-01, 5.7049304113802379e-01, 5.9098039215686282e-01},
                                     {3.6881361014994235e-01, 7.2460284505959249e-01, 5.4730880430603612e-01, 6.1019607843137247e-01},
                                     {3.5886505190311407e-01, 7.1944636678200680e-01, 5.2412456747404812e-01, 6.2941176470588256e-01},
                                     {3.4891649365628596e-01, 7.1428988850442132e-01, 5.0094033064206056e-01, 6.4862745098039221e-01},
                                     {3.3896793540945785e-01, 7.0913341022683585e-01, 4.7775609381007289e-01, 6.6784313725490208e-01},
                                     {3.2901937716262974e-01, 7.0397693194925037e-01, 4.5457185697808533e-01, 6.8705882352941172e-01},
                                     {3.1907081891580152e-01, 6.9882045367166468e-01, 4.3138762014609738e-01, 7.0627450980392181e-01},
                                     {3.0912226066897341e-01, 6.9366397539407920e-01, 4.0820338331410977e-01, 7.2549019607843146e-01},
                                     {2.9917370242214530e-01, 6.8850749711649373e-01, 3.8501914648212221e-01, 7.4470588235294122e-01},
                                     {2.8922514417531719e-01, 6.8335101883890814e-01, 3.6183490965013460e-01, 7.6392156862745098e-01},
                                     {2.7927658592848892e-01, 6.7819454056132256e-01, 3.3865067281814654e-01, 7.8313725490196107e-01},
                                     {2.6932802768166081e-01, 6.7303806228373697e-01, 3.1546643598615898e-01, 8.0235294117647071e-01},
                                     {2.5937946943483270e-01, 6.6788158400615139e-01, 2.9228219915417136e-01, 8.2156862745098047e-01},
                                     {2.4943091118800462e-01, 6.6272510572856591e-01, 2.6909796232218375e-01, 8.4078431372549023e-01},
                                     {2.3948235294117637e-01, 6.5756862745098033e-01, 2.4591372549019583e-01, 8.6000000000000021e-01},
                                     {2.2953379469434826e-01, 6.5241214917339485e-01, 2.2272948865820824e-01, 8.7921568627450997e-01},
                                     {2.1958523644752015e-01, 6.4725567089580927e-01, 1.9954525182622063e-01, 8.9843137254901961e-01},
                                     {2.0963667820069207e-01, 6.4209919261822368e-01, 1.7636101499423301e-01, 9.1764705882352937e-01},
                                     {1.9968811995386376e-01, 6.3694271434063809e-01, 1.5317677816224501e-01, 9.3686274509803946e-01},
                                     {1.8973956170703571e-01, 6.3178623606305262e-01, 1.2999254133025739e-01, 9.5607843137254922e-01},
                                     {1.7979100346020757e-01, 6.2662975778546715e-01, 1.0680830449826978e-01, 9.7529411764705887e-01},
                                     {1.6984244521337946e-01, 6.2147327950788156e-01, 8.3624067666282179e-02, 9.9450980392156862e-01},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.6700000000000001e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 1.0000000000000000e+00},
                                     {1.7196470588235294e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.9843137254901959e-01},
                                     {1.8934117647058815e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.9294117647058822e-01},
                                     {2.0671764705882387e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.8745098039215673e-01},
                                     {2.2409411764705911e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.8196078431372535e-01},
                                     {2.4147058823529433e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.7647058823529398e-01},
                                     {2.5884705882352954e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.7098039215686271e-01},
                                     {2.7622352941176481e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.6549019607843145e-01},
                                     {2.9360000000000008e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.6000000000000008e-01},
                                     {3.1097647058823524e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.5450980392156870e-01},
                                     {3.2835294117647046e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.4901960784313732e-01},
                                     {3.4572941176470617e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.4352941176470584e-01},
                                     {3.6310588235294139e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.3803921568627446e-01},
                                     {3.8048235294117660e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.3254901960784309e-01},
                                     {3.9785882352941193e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.2705882352941171e-01},
                                     {4.1523529411764709e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.2156862745098045e-01},
                                     {4.3261176470588236e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.1607843137254918e-01},
                                     {4.4998823529411758e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.1058823529411770e-01},
                                     {4.6736470588235279e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.0509803921568643e-01},
                                     {4.8474117647058845e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.9960784313725484e-01},
                                     {5.0211764705882367e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.9411764705882346e-01},
                                     {5.1949411764705888e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.8862745098039220e-01},
                                     {5.3687058823529421e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.8313725490196082e-01},
                                     {5.5424705882352943e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.7764705882352945e-01},
                                     {5.7162352941176464e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.7215686274509807e-01},
                                     {5.8899999999999986e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.6666666666666670e-01},
                                     {6.0637647058823518e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.6117647058823543e-01},
                                     {6.2375294117647073e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.5568627450980383e-01},
                                     {6.4112941176470606e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.5019607843137257e-01},
                                     {6.5850588235294127e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.4470588235294120e-01},
                                     {6.7588235294117649e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.3921568627450982e-01},
                                     {6.9325882352941171e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.3372549019607844e-01},
                                     {7.1063529411764692e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.2823529411764718e-01},
                                     {7.2801176470588214e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.2274509803921581e-01},
                                     {7.4538823529411735e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.1725490196078443e-01},
                                     {7.6276470588235312e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.1176470588235294e-01},
                                     {7.8014117647058834e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.0627450980392157e-01},
                                     {7.9751764705882355e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.0078431372549019e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.0470588235294116e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.1019607843137254e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.1568627450980391e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.2117647058823529e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.2666666666666666e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.3215686274509815e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.3764705882352952e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.4313725490196090e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.4862745098039216e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.5411764705882354e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.5960784313725491e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.6509803921568640e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.7058823529411766e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.7607843137254915e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.8156862745098041e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.8705882352941179e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.9254901960784316e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 8.9803921568627454e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.0352941176470591e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.0901960784313718e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.1450980392156866e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.2000000000000015e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.2549019607843142e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.3098039215686290e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.3647058823529417e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.4196078431372554e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.4745098039215692e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.5294117647058818e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.5843137254901956e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.6392156862745115e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.6941176470588242e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.7490196078431379e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.8039215686274517e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.8588235294117654e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.9137254901960792e-01},
                                     {8.0000000000000004e-01, 6.2000000000000000e-01, 7.6999999999999999e-02, 9.9686274509803918e-01},
                                     {8.0235294117647060e-01, 6.1270588235294121e-01, 7.6094117647058826e-02, 1.0000000000000000e+00},
                                     {8.0784313725490209e-01, 5.9568627450980349e-01, 7.3980392156862695e-02, 1.0000000000000000e+00},
                                     {8.1333333333333346e-01, 5.7866666666666633e-01, 7.1866666666666620e-02, 1.0000000000000000e+00},
                                     {8.1882352941176484e-01, 5.6164705882352917e-01, 6.9752941176470559e-02, 1.0000000000000000e+00},
                                     {8.2431372549019621e-01, 5.4462745098039189e-01, 6.7639215686274484e-02, 1.0000000000000000e+00},
                                     {8.2980392156862748e-01, 5.2760784313725484e-01, 6.5525490196078423e-02, 1.0000000000000000e+00},
                                     {8.3529411764705896e-01, 5.1058823529411757e-01, 6.3411764705882348e-02, 1.0000000000000000e+00},
                                     {8.4078431372549023e-01, 4.9356862745098040e-01, 6.1298039215686280e-02, 1.0000000000000000e+00},
                                     {8.4627450980392160e-01, 4.7654901960784324e-01, 5.9184313725490205e-02, 1.0000000000000000e+00},
                                     {8.5176470588235309e-01, 4.5952941176470558e-01, 5.7070588235294074e-02, 1.0000000000000000e+00},
                                     {8.5725490196078447e-01, 4.4250980392156836e-01, 5.4956862745098006e-02, 1.0000000000000000e+00},
                                     {8.6274509803921573e-01, 4.2549019607843119e-01, 5.2843137254901938e-02, 1.0000000000000000e+00},
                                     {8.6823529411764711e-01, 4.0847058823529397e-01, 5.0729411764705863e-02, 1.0000000000000000e+00},
                                     {8.7372549019607848e-01, 3.9145098039215676e-01, 4.8615686274509795e-02, 1.0000000000000000e+00},
                                     {8.7921568627450986e-01, 3.7443137254901959e-01, 4.6501960784313720e-02, 1.0000000000000000e+00},
                                     {8.8470588235294123e-01, 3.5741176470588248e-01, 4.4388235294117659e-02, 1.0000000000000000e+00},
                                     {8.9019607843137250e-01, 3.4039215686274527e-01, 4.2274509803921591e-02, 1.0000000000000000e+00},
                                     {8.9568627450980398e-01, 3.2337254901960749e-01, 4.0160784313725446e-02, 1.0000000000000000e+00},
                                     {9.0117647058823536e-01, 3.0635294117647038e-01, 3.8047058823529385e-02, 1.0000000000000000e+00},
                                     {9.0666666666666673e-01, 2.8933333333333322e-01, 3.5933333333333317e-02, 1.0000000000000000e+00},
                                     {9.1215686274509811e-01, 2.7231372549019600e-01, 3.3819607843137242e-02, 1.0000000000000000e+00},
                                     {9.1764705882352948e-01, 2.5529411764705878e-01, 3.1705882352941174e-02, 1.0000000000000000e+00},
                                     {9.2313725490196075e-01, 2.3827450980392162e-01, 2.9592156862745102e-02, 1.0000000000000000e+00},
                                     {9.2862745098039212e-01, 2.2125490196078443e-01, 2.7478431372549034e-02, 1.0000000000000000e+00},
                                     {9.3411764705882350e-01, 2.0423529411764724e-01, 2.5364705882352963e-02, 1.0000000000000000e+00},
                                     {9.3960784313725498e-01, 1.8721568627450955e-01, 2.3250980392156832e-02, 1.0000000000000000e+00},
                                     {9.4509803921568636e-01, 1.7019607843137236e-01, 2.1137254901960761e-02, 1.0000000000000000e+00},
                                     {9.5058823529411773e-01, 1.5317647058823516e-01, 1.9023529411764689e-02, 1.0000000000000000e+00},
                                     {9.5607843137254900e-01, 1.3615686274509797e-01, 1.6909803921568618e-02, 1.0000000000000000e+00},
                                     {9.6156862745098037e-01, 1.1913725490196077e-01, 1.4796078431372548e-02, 1.0000000000000000e+00},
                                     {9.6705882352941175e-01, 1.0211764705882365e-01, 1.2682352941176485e-02, 1.0000000000000000e+00},
                                     {9.7254901960784312e-01, 8.5098039215686455e-02, 1.0568627450980415e-02, 1.0000000000000000e+00},
                                     {9.7803921568627450e-01, 6.8078431372549264e-02, 8.4549019607843435e-03, 1.0000000000000000e+00},
                                     {9.8352941176470599e-01, 5.1058823529411580e-02, 6.3411764705882129e-03, 1.0000000000000000e+00},
                                     {9.8901960784313725e-01, 3.4039215686274389e-02, 4.2274509803921414e-03, 1.0000000000000000e+00},
                                     {9.9450980392156862e-01, 1.7019607843137195e-02, 2.1137254901960707e-03, 1.0000000000000000e+00},
                                     {1.0000000000000000e+00, 0.0000000000000000e+00, 0.0000000000000000e+00, 1.0000000000000000e+00}
  };
