package org.apache.maven.doxia.sink.impl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.Writer;

import org.apache.maven.doxia.sink.Sink;

/**
 * An abstract <code>SinkFactory</code> for XML markup syntax. <code>UTF-8</code> is used
 * when no encoding is specified.
 *
 * @author <a href="mailto:vincent.siveton@gmail.com">Vincent Siveton</a>
 * @version $Id: AbstractXmlSinkFactory.java 1726411 2016-01-23 16:34:09Z hboutemy $
 * @since 1.1
 */
public abstract class AbstractXmlSinkFactory
    extends AbstractTextSinkFactory
{
    /**
     * Create a text Sink for a given encoding and for a given language identifier.
     *
     * @param writer The writer for the sink output, never <code>null</code>.
     * @param encoding The character encoding used by the writer.
     * @param languageId language identifier for the root element as defined by
     * <a href="ftp://ftp.isi.edu/in-notes/bcp/bcp47.txt">IETF BCP 47</a>, Tags for the Identification of Languages;
     * in addition, the empty string may be specified.
     * @return a Sink for XML output in the given encoding.
     * @see <a href="http://www.w3.org/TR/REC-xml/#sec-lang-tag">http://www.w3.org/TR/REC-xml/#sec-lang-tag</a>
     */
    protected abstract Sink createSink( Writer writer, String encoding, String languageId );
}
