/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A1, UP_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A2, UP_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A3, UP_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A4, UP_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A5, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A6, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A7, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A8, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A9, DN_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A10, DN_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_A11, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A12, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A15, UP_20K, DEEP, NF1),
	PAD_CFG_TERM_GPO(GPP_A16, 0, UP_20K, DEEP),
	PAD_CFG_GPO(GPP_A17, 1, PLTRST),
	PAD_CFG_GPO(GPP_A18, 0, PLTRST),
	PAD_CFG_TERM_GPO(GPP_A19, 0, UP_20K, DEEP),
	PAD_CFG_GPO(GPP_A20, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_A21, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A22, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_GPO(GPP_B0, 0, PLTRST),
	PAD_CFG_GPO(GPP_B1, 0, PLTRST),
	PAD_CFG_NF(GPP_B2, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_B3, 0, PLTRST),
	PAD_CFG_GPO(GPP_B4, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_B5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_B6, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_B7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_B9, 0, PLTRST),
	PAD_CFG_NF(GPP_B10, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_B11, 0, PLTRST),
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B14, DN_20K, PLTRST, NF1),
	PAD_CFG_GPO(GPP_B15, 0, PLTRST),
	PAD_CFG_GPO(GPP_B16, 0, PLTRST),
	PAD_CFG_GPO(GPP_B17, 0, PLTRST),
	PAD_CFG_NF(GPP_B18, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_B19, 0, PLTRST),
	PAD_CFG_GPI_DUAL_ROUTE(GPP_B20, NONE, PLTRST, OFF, NONE, NMI, SMI),
	PAD_CFG_GPO(GPP_B21, 0, PLTRST),
	PAD_CFG_NF(GPP_B22, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_B23, DN_20K, PLTRST, NF1),

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C2, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C5, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_C8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_C9, 0, PLTRST),
	PAD_CFG_GPO(GPP_C10, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_C11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_C12, 1, PLTRST),
	PAD_CFG_GPO(GPP_C13, 1, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_C14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_C15, 1, PLTRST),
	PAD_CFG_GPO(GPP_C16, 0, PLTRST),
	PAD_CFG_GPO(GPP_C17, 0, PLTRST),
	PAD_CFG_GPO(GPP_C18, 0, PLTRST),
	PAD_CFG_GPO(GPP_C19, 0, PLTRST),
	PAD_CFG_GPO(GPP_C20, 0, PLTRST),
	PAD_CFG_GPO(GPP_C21, 0, PLTRST),
	PAD_CFG_GPO(GPP_C22, 0, PLTRST),
	PAD_CFG_GPO(GPP_C23, 0, PLTRST),

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_GPO(GPP_D0, 0, PLTRST),
	PAD_CFG_GPO(GPP_D1, 1, PLTRST),
	PAD_CFG_NF(GPP_D2, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_D3, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_D4, 1, RSMRST),
	PAD_CFG_GPO(GPP_D5, 0, RSMRST),
	PAD_CFG_GPO(GPP_D6, 0, RSMRST),
	PAD_CFG_GPO(GPP_D7, 0, RSMRST),
	PAD_CFG_GPO(GPP_D8, 0, RSMRST),
	PAD_CFG_GPO(GPP_D9, 0, RSMRST),
	PAD_CFG_GPO(GPP_D10, 0, RSMRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_D11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_D16, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_D17, NONE, PLTRST, LEVEL, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_D19, 0, PLTRST),
	PAD_CFG_GPO(GPP_D20, 0, PLTRST),
	PAD_CFG_GPO(GPP_D21, 0, PLTRST),
	PAD_CFG_GPO(GPP_D22, 0, PLTRST),
	PAD_CFG_GPO(GPP_D23, 0, PLTRST),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_TERM_GPO(GPP_E0, 0, UP_20K, PLTRST),
	PAD_CFG_TERM_GPO(GPP_E1, 0, UP_20K, PLTRST),
	PAD_CFG_TERM_GPO(GPP_E2, 0, UP_20K, PLTRST),
	PAD_CFG_GPO(GPP_E3, 0, PLTRST),
	PAD_CFG_GPO(GPP_E4, 0, PLTRST),
	PAD_CFG_GPO(GPP_E5, 0, PLTRST),
	PAD_CFG_GPO(GPP_E6, 0, PLTRST),
	PAD_CFG_GPO(GPP_E7, 0, PLTRST),
	PAD_CFG_NF(GPP_E8, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E10, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E11, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF1),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_GPO(GPP_F0, 0, PLTRST),
	PAD_CFG_NF(GPP_F1, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_F2, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_F3, 0, PLTRST),
	PAD_CFG_GPO(GPP_F4, 0, PLTRST),
	PAD_CFG_NF(GPP_F5, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_F6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_F7, 0, DEEP),
	PAD_CFG_GPO(GPP_F8, 0, PLTRST),
	PAD_CFG_GPO(GPP_F9, 0, PLTRST),
	PAD_CFG_NF(GPP_F10, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_F11, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_F12, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_F13, NONE, PLTRST, NF1),
	PAD_CFG_GPI_APIC_HIGH(GPP_F14, NONE, DEEP),
	PAD_CFG_NF(GPP_F15, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F18, NONE, PLTRST, NF1),
	PAD_CFG_GPO(GPP_F19, 0, PLTRST),
	PAD_CFG_GPO(GPP_F20, 0, PLTRST),
	PAD_CFG_GPO(GPP_F21, 0, PLTRST),
	PAD_CFG_GPO(GPP_F22, 1, PLTRST),
	PAD_CFG_GPO(GPP_F23, 0, PLTRST),

	/* ------- GPIO Group GPP_G ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_G0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G1, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_G3, 0, PLTRST),
	PAD_CFG_GPO(GPP_G4, 0, PLTRST),
	PAD_CFG_GPO(GPP_G5, 0, PLTRST),
	PAD_CFG_GPO(GPP_G6, 0, PLTRST),
	PAD_CFG_GPO(GPP_G7, 0, PLTRST),
	PAD_CFG_GPO(GPP_G8, 0, PLTRST),
	PAD_CFG_GPO(GPP_G9, 0, PLTRST),
	PAD_CFG_GPO(GPP_G10, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_G11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G17, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_G18, 1, PLTRST),
	PAD_CFG_GPI_SCI(GPP_G19, NONE, PLTRST, LEVEL, INVERT),
	PAD_CFG_GPO(GPP_G20, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_G21, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_G22, 0, PLTRST),
	PAD_CFG_GPO(GPP_G23, 0, PLTRST),

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPO(GPP_H0, 0, PLTRST),
	PAD_CFG_GPO(GPP_H1, 0, RSMRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_H2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_H3, 0, PLTRST),
	PAD_CFG_GPO(GPP_H4, 0, PLTRST),
	PAD_CFG_GPO(GPP_H5, 0, PLTRST),
	PAD_CFG_GPO(GPP_H6, 0, PLTRST),
	PAD_CFG_GPO(GPP_H7, 0, PLTRST),
	PAD_CFG_GPO(GPP_H8, 0, PLTRST),
	PAD_CFG_GPO(GPP_H9, 0, PLTRST),
	PAD_CFG_GPO(GPP_H10, 1, PLTRST),
	PAD_CFG_GPO(GPP_H11, 1, PLTRST),
	PAD_CFG_GPO(GPP_H12, 0, PLTRST),
	PAD_CFG_GPO(GPP_H13, 0, PLTRST),
	PAD_CFG_GPO(GPP_H14, 0, PLTRST),
	PAD_CFG_GPO(GPP_H15, 1, PLTRST),
	PAD_CFG_GPO(GPP_H16, 0, PLTRST),
	PAD_CFG_GPO(GPP_H17, 0, PLTRST),
	PAD_CFG_GPO(GPP_H18, 1, PLTRST),
	PAD_CFG_GPO(GPP_H19, 0, PLTRST),
	PAD_CFG_GPO(GPP_H20, 0, PLTRST),
	PAD_CFG_GPO(GPP_H21, 0, PLTRST),
	PAD_CFG_GPO(GPP_H22, 0, PLTRST),
	PAD_CFG_GPO(GPP_H23, 0, PLTRST),

	/* ------- GPIO Community 2 ------- */

	/* -------- GPIO Group GPD -------- */
	PAD_CFG_NF(GPD0, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPD1, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD2, DN_20K, PWROK, NF1),
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1),
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),
	PAD_CFG_GPO(GPD7, 0, PWROK),
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),
	PAD_CFG_GPO(GPD9, 0, PWROK),
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD11, NONE, PWROK, NF1),

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_NF(GPP_I0, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_I1, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_I2, NONE, PLTRST, NF1),
	PAD_CFG_GPI_DUAL_ROUTE(GPP_I3, NONE, PLTRST, OFF, NONE, SMI, NMI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I4, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_I5, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_I6, DN_20K, PLTRST, OFF, ACPI),
	PAD_CFG_NF(GPP_I7, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_I8, DN_20K, PLTRST, NF1),
	PAD_CFG_NF(GPP_I9, NONE, PLTRST, NF1),
	PAD_CFG_NF(GPP_I10, DN_20K, PLTRST, NF1),
};

#endif /* CFG_GPIO_H */
