JSON RPC plugin for CloudCompare
================================

This plugin executes commands/actions via RPC from a different proccess/computer
The plugin opens a TCP-server port when activated.
The RPC communication is done via Websocket http JSON transfers.

Currently implemented commands:
- open: opens a file from filesystem
- clear: clears all clouds

This plugin is published under GNU General Public License v3.0 or later.

howto build
-----------

Currently the plugin is a subrepository of CloudCompare and can be cloned alltogether.

0. install prerequisites

this is tested on Ubuntu 18.04 and should work on 20.04, 20.10 as well

```
sudo apt install build-essential cmake cmake-qt-gui extra-cmake-modules git 
sudo apt install qtbase5-dev qtbase5-gles-dev qt5-default qttools5-dev-tools qttools5-dev libqtsvg5-dev libqt5websockets5-dev
sudo apt install libgdal-dev
```

1. clone CloudCompare

```
mkdir cc
cd cc
git clone --recursive https://github.com/CloudCompare/CloudCompare.git
```

2. build CloudCompare

you have to select the PLUGIN > PLUGIN_STANDARD_QJSONRPC 

```
cd cc/CloudCompare
mkdir build
cd build
cmake-gui ..
make -j
sudo make install
```

howto use
---------

Below a python script to open a file from filesystem:

```
#!/usr/bin/env python3

import asyncio
import websockets

async def hello():
    uri = "ws://localhost:6001"
    async with websockets.connect(uri) as websocket:
        await websocket.send('{"jsonrpc": "2.0", "method": "open", \
                "params": { \
                    "filename": "/home/adib/Dokumente/teapot.ply", \
                    "filter":"PLY mesh (*.ply)", \
                    "silent":true, \
                    "transformation": [-0.5732937009507673, 0.8193193174792813, 0.007084582014166903, -161.35002666963268, \
                        -0.8193308300123949, -0.5733179603522832, 0.001873784980341508, 320.67951255557966, \
                        0.005596946702519333, -0.004730387192182964, 0.9999731500865392, -230.60935194531334, \
                        0.0, 0.0, 0.0, 1.0]}, \
                "id": 4}')
        result = await websocket.recv()
        print("result: ", result)

asyncio.get_event_loop().run_until_complete(hello())
```

interface
---------

```
- open - opens a file from filesystem
  filename: string, filename on the filesystem
  filter: string, optional, filter identificator, if not given then CloudCompare identifies fileformat based on extension
  silent: bool, optional, if true, then filterdialog is suppressed
  transformation: list of float (16values), optional, after import this transformation matrix is applied to the object,
  name: specify caption name in CC object treeview
  parent: specify position in CC object treeview, parent  names are separated by "/"
- clear - clear all objects
- version - return version number of plugin
```

debugging
---------

I use QtCreator for developement.
In order to load the plugin during debugging it must placed in a folder that is looked up.
- /usr/lib/cloudcompare/plugins
- /home/username/.local/share/CCCorp/CloudCompare/plugins
- /usr/local/share/CCCorp/CloudCompare/plugins
- /usr/share/CCCorp/CloudCompare/plugins
- /var/lib/snapd/desktop/CCCorp/CloudCompare/plugins

I set a link in the .local/share folder to the recent compiled version:

```
ln -s build-CloudCompare-Desktop-Debug/plugins/core/Standard/qJSonRPCPlugin/libQJSON_RPC_PLUGINd.so ~/.local/share/CCCorp/CloudCompare/plugins/libQJSON_RPC_PLUGINd.so
```

contact
-------

Remarks, wishes, etc. are welcome
thAdib theAdib@gmail.com

