#pragma once
#include <QObject>
#include <QSize>
#include <QVariant>

#include "enums.hpp"
#include "qwayland-wlr-output-management-unstable-v1.h"

namespace bd::Outputs::Wlr {
  class Mode : public QObject, public QtWayland::zwlr_output_mode_v1 {
      Q_OBJECT

    public:
      Mode(::zwlr_output_mode_v1* mode);

      std::optional<::zwlr_output_mode_v1*> getWlrMode();

    signals:
      void propertyChanged(MetaModeProperty::Property property, const QVariant& value);
      void modeFinished();

    protected:
      void zwlr_output_mode_v1_size(int32_t width, int32_t height) override;
      void zwlr_output_mode_v1_refresh(int32_t refresh) override;
      void zwlr_output_mode_v1_preferred() override;
//      void zwlr_output_mode_v1_finished() override;

  };
}
