#ifndef AVIREADSTREAM_H
#define AVIREADSTREAM_H

#include "Cache.h"
#include "ReadHandlers.h"

AVM_BEGIN_NAMESPACE;

class AviReadHandler;

class AviReadStream : public IMediaReadStream
{
friend class AviReadHandler;
public:
    AviReadStream(AviReadHandler* handler, const AVIStreamHeader& hdr,
		  uint_t id, const void* format, size_t fsize);
    virtual ~AviReadStream();
    virtual double CacheSize() const;
    virtual void ClearCache();
    virtual size_t GetFormat(void *format = 0, size_t size = 0) const;
    virtual double GetFrameTime() const { return 1. / m_dFrameRate; }
    virtual size_t GetHeader(void* header, size_t size) const;
    virtual framepos_t GetLength() const;
    virtual double GetLengthTime() const;
    virtual bool IsKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetNextKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetNearestKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetPrevKeyFrame(framepos_t frame = ERR) const;
    virtual size_t GetSampleSize() const { return m_Header.dwSampleSize; }
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual IStream::StreamType GetType() const;
    virtual StreamPacket* ReadPacket();
    virtual int Seek(framepos_t pos);
    virtual int SeekTime(double time);
    virtual int SkipFrame() { return Seek(m_uiPosition + 1); }
    virtual int SkipTo(double pos) { return SeekTime(pos); }

    virtual int FixAvgBytes(uint_t bps);

    void fixHeader();
protected:
    framepos_t find(framepos_t frame) const;
    framepos_t getFramePos(framepos_t frame) const {
	if (frame == ERR)
	    frame = m_uiPosition;
	return (frame <= m_Header.dwStart) ? 0 : frame - m_Header.dwStart;
    }

    void addChunk(off_t off, size_t len, bool iskf);
    AviReadHandler* m_pHandler;
    mutable StreamInfo m_StreamInfo;
    uint_t m_iId;
    framepos_t m_uiChunk;
    framepos_t m_uiPosition;
    AVIStreamHeader m_Header;
    union {
	char* m_pcFormat;
	WAVEFORMATEX* m_WAVEFORMATEX;
        BITMAPINFOHEADER* m_BITMAPINFOHEADER;
    };
    size_t m_uiFormatSize;
    double m_dFrameRate;
    uint_t m_uiStart;
    framepos_t m_uiLength;
    double m_dLengthTime;

    // chunk data for Avi Index
    avm::vector<uint32_t> m_Offsets;
    avm::vector<framepos_t> m_Positions; // needed for audio streams
    size_t m_uiStreamSize;
    framepos_t m_uiAlignedSize;
    uint_t m_uiKeyChunks;
    size_t m_uiKeySize;
    size_t m_uiKeyMaxSize;
    size_t m_uiKeyMinSize;
    // delta chunks m_Offsets - m_uiKeyChunks
    size_t m_uiDeltaSize;
    size_t m_uiDeltaMaxSize;
    size_t m_uiDeltaMinSize;
};

AVM_END_NAMESPACE;

#endif // AVIREADSTREAM_H
