       SUBROUTINE SST02I(WIN,WOUT,NSIZIN,NSIZOT,ISCR,SPTYPE)
C
C THIS ROUTINE ACCEPTS A SYMMETRY PACKED FOUR-INDEX LIST AND RETURNS
C   THE SAME LIST BUT WITH AN ALTERNATIVE SCHEME FOR SYMMETRY PACKING.
C
C THE LIST (A,b;I,j) IS PRESUMED TO BE PACKED AI-bj OR ai-BJ.  
C   THIS ROUTINE RETURNS THE LIST PACKED AS Ab;Ij.  IN A SENSE,
C   THIS ROUTINE FUNCTIONS AS THE INVERSE OF SST002, HENCE ITS NAME.
C
C INPUT: 
C           WIN  - THE SYMMETRY PACKED AB-IJ LIST.
C         NSIZIN - THE TOTAL SIZE OF THE SYM. PACKED INPUT VECTOR.
C         NSIZOT - THE TOTAL SIZE OF THE SYM. PACKED OUTPUT VECTOR.
C         SPTYPE - THE SPIN TYPE FOR THE INPUT LIST
C
C                        'AABB' FOR (AI-bj).
C                        'BBAA' FOR (bj-AI).
C
C OUTPUT: 
C          WOUT  - THE SYMMETRY PACKED Ab-Ij LIST.
C       
C SCRATCH:
C         ISCR   - SCRATCH AREA TO HOLD THE SYMMETRY VECTORS AND INVERSE
C                   SYMMETRY VECTORS WHICH ARE NEEDED. 
C                   (SIZE: NVRTA*NVRTB+NOCCA*NOCCB+NVRTA*NOCCB+
C                          NVRTA*NOCCA+NVRTB*NOCCB)
C         
CEND
      IMPLICIT INTEGER (A-Z)
      CHARACTER*4 REORTP,SPTYPE
      DOUBLE PRECISION WIN(NSIZIN),WOUT(NSIZOT),ISCR(*)
      DIMENSION IOFFTAR(8)
      COMMON/MACHSP/IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      COMMON/SYMINF/NSTART,NIRREP,IRREP0(255,2),DIRPRD(8,8)
      COMMON/SYMPOP/IRPDPD(8,22),ISYTYP(2,500),ID(18)
      COMMON/SYM/POP(8,2),VRT(8,2),NT(2),NFMI(2),NFEA(2)
C
      IRREPX=1
C
      IF(SPTYPE.EQ.'BBAA')THEN
C
C CALCULATE SOME OFFSETS
C
       IOFFTAR(1)=1
       DO 5 IRREPR=1,NIRREP-1
        IRREPL=DIRPRD(IRREPX,IRREPR)
        DISSIZ=IRPDPD(IRREPL,10)
        NUMDIS=IRPDPD(IRREPR,9)
        IOFFTAR(IRREPR+1)=IOFFTAR(IRREPR)+DISSIZ*NUMDIS
5      CONTINUE
       IOFF1=1
       DO 10 IRREPR=1,NIRREP
        IRREPL=DIRPRD(IRREPX,IRREPR)
        NUMDIS=IRPDPD(IRREPR,9)
        DISSIZ=IRPDPD(IRREPL,10)
        CALL TRANSP(WIN(IOFF1),WOUT(IOFFTAR(IRREPL)),NUMDIS,DISSIZ)
        IOFF1=IOFF1+NUMDIS*DISSIZ
10     CONTINUE
       TOTSIZ=IOFF1-1
       CALL SCOPY(TOTSIZ,WOUT,1,WIN,1)
      ENDIF
C
      CALL SSTGEN(WIN,WOUT,NSIZIN,VRT(1,1),POP(1,1),VRT(1,2),POP(1,2),
     &            ISCR,IRREPX,'1324')
C
      RETURN
      END
