#!/bin/bash

# explain script here

# default thresholds go here
warnd=_____
critd=_____

# describe your check for output and perf
description=" _____ _____ "
itemname="____"

function usage () {
cat <<-USAGE
    Usage: $0 -w <warn> -c <crit> -d -h
    Nagios/Icinga check for $description 
    Performance data for $itemname is also generated
    -w <warn>: warning threshold, default is $warnd
    -c <crit>: critical threshold, default is $critd
    -d: Set debug flag on
    -h: This help message
    To change default thresholds, edit the variables, otherwise pass them in as arguments
USAGE
}

# getops define them here, and put in usage
while getopts "w:c:dh" OPT; do
    case "$OPT" in
        w) warn="$OPTARG" ;;
        c) crit="$OPTARG" ;;
        d) debug==true ;; 
        h) usage
           exit 3                                     ;;
        *) echo "Unrecognized option: $OPT" >&2
           echo >&2
           usage
           exit 3                                   ;;
    esac
done

## use defaults if we didn't pass in thresholds
if [[ x"$warn" == x"" ]]; then
    	warn="$warnd"
fi

if [[ x"$crit" == x"" ]]; then
    	crit="$critd"
fi

# data grab and parse goes here
result=$( _____  )
rcode=${?}

# check to see if we have a value at all
if [[ x"$result" == x"" ]]; then
	echo "UNKNOWN: _____________ doesn't return a value, code is $rcode"
	exit 3
fi 

# now do the return, order matters here, note the exits
# shellcheck disable=SC2086
if [ $result -ge $crit ] ; then
	echo "CRITICAL: $result $description | $itemname=$result;$warn;$crit;0"
	code=2
elif [ $result -ge $warn ] ; then
    echo "WARNING: $result $description | $itemname=$result;$warn;$crit;0"
    code=1
elif [ $result -lt $warn ] ; then
    echo "OK: $result $description | $itemname=$result;$warn;$crit;0"
    code=0
else
	echo "UNKNOWN: ______ doesn't return a valid value for $description, or something else is wrong"
	code=3
fi

if [[ $passive -eq "1" ]] ; then
    if [[ $debug ]]; then
        echo "Submitting passive results"
    fi

    for nagios_server in $(tr ',' ' ' <<< "$nagios_servers")
    do 
        echo "$server~$itemname~$code~$output" | /usr/sbin/send_nsca -d "~" -H $nagios_server
        if [[ $debug ]]; then
            echo "Passive result sent to $nagios_server: $server~$itemname~$code~$output"
        fi
    done
    exit 0
fi

## unless the passives have gone and exited, we get to here
if [[ $debug ]]; then
    echo "Active result sent: $output $code for $server $itemname"
fi

echo "$output"
exit $code

