#!/bin/bash

# wallet acl tests 
# (root) purpleperil:~> 
#

#### Note: command must be run by an account or service principal with remctl wallet access

# default thresholds go here
acld=

nagios_servers=""
passive=0
#critd=_____
# fixed conditionals

# describe your check for output and perf - varies per test
description=""
itemname="wallet_acls"

function usage () {
cat <<-USAGE
    Usage: $0 -s <wallet-server> [-t <test>] [-p <nagios_servers>] -d -h
    Nagios/Icinga check for $description 
    -s <wallet server>: wallet server name is required
    -t <test>: acl to check. Default is ADMIN check
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers>
    -d: Set debug flag on
    -h: this help message
USAGE
}

# getops define them here, and put in usage
while getopts "s:t:p:dh" OPT; do
    case "$OPT" in
        s) server="$OPTARG" ;;
        t) test="$OPTARG" ;;
        p) nagios_servers="$OPTARG" ;;
        d) debug=true ;;
        h) usage
           exit 3                                     ;;
        *) echo "Unrecognized option: $OPT" >&2
           echo >&2
           usage
           exit 3                                   ;;
    esac
done

## use defaults if we didn't pass in thresholds
if [[ x"$acl" == x"" ]]; then
    acl="$acld"
fi

if [[ x"$server" == x"" ]]; then
    usage
    echo; echo "UNKNOWN: server is required"
    exit 3
fi

if [[ x"$nagios_servers" != x"" ]]; then
    passive=1
fi

# data grab and parse goes here
result=$( )
code=$( echo $? )

if [ $debug ]; then
    echo "Actual raw results:"
    echo "result = \"$result\", exit code = $code, passive is \"$passive\""
fi

# now do the return, order matters here, note the exits
if [[ x$code == x"255" ]] ; then
	output="CRITICAL: Access Denied for $description "
    code=2
elif [[ x"$result" == x"" ]] && [[ $code -eq "0" ]] ; then
	output="WARNING: \"remctl $server wallet-report objects acl $acl\" doesn't return a value"
    code=1
elif [[ x$result != x"" ]] ; then
    output="OK: $description; $acl is an acl for $result "
    code=0
else
	output="UNKNOWN: $item doesn't return a valid value for $description, or something else is wrong: $result ($code)"
    code=3
fi

if [[ $passive -eq "1" ]] ; then
    if [[ $debug ]]; then
        echo "Submitting passive results"
    fi

    for nagios_server in $(tr ',' ' ' <<< "$nagios_servers")
    do 
        echo "$server~$itemname~$code~$output" | /usr/sbin/send_nsca -d "~" -H $nagios_server
        if [[ $debug ]]; then
            echo "Passive result sent to $nagios_server: $server~$itemname~$code~$output"
        fi
    done
    exit 0
fi

## unless the passives have gone and exited, we get to here
if [[ $debug ]]; then
    echo "Active result sent: $output $code for $server $itemname"
fi

echo $output
exit $code
