# Wallet Monitoring

This is the package containing both the active and passive monitors for wallet. The related JIRA ticket is KERB-332.

Additional documentation can be found at https://ikiwiki.stanford.edu/service/wallet/testing/

## Languages

These scripts are in either shell or perl, and are designed to work with Nagios (or nagios compatible 
monitoring tools)

## Where it installs

Most of the scripts live in /usr/lib/nagios/plugins/ (or /usr/local/bin)

## List of scripts and what they do (planned)

* check_wallet_remctl - see if the wallet remctl interface is up and working
* check_wallet_backups - are the backups to GCP current
* check_wallet_crud - create, read, update and destroy a wallet object
* check_wallet_acls - swiss army acl check - gets fail appropriately, ADMIN ACL is correct, downloading  keytab works
* check_wallet_keytab - verify password changes on re-download or not (flag not set unchanging, flag set unchanging)
* check_wallet_file_replication.sh - check that replicas are replicating promptly from the master

## Access Requirements! 

All of these checks need to be executed by/under a person/keytab with permission/access 
to perform them. This is not optional. 

If the checks are failing where you install them, check that the user executing them 
actually has the rights to do the sample code in the header of each check.  

Getting to this point may require adding ACLs and keytabs on all wallet instances.

Seriously, these MUST be run under wrappers or specific users with wallet access rights.

## Building

To build this package, it pretty much gets tarred up and signed. No compiled code is planned.

It uses the native style Debian packaging

## Actual Monitors

`/usr/lib/nagios/plugins/check_wallet_remctl.sh` 
``` 
Usage: usr/lib/plugins/check_wallet_remctl.sh -s <wallet-server> [-a <acl>] [-p <nagios_servers>] -d -h 
    Nagios/Icinga check for wallet remctl test 
    -s <wallet server>: wallet server name is required 
    -a <acl>: acl to look for. Default is group/as-acs-test 
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers> 
    -d: Set debug flag on
    -h: this help message
```

`/usr/lib/nagios/plugins/check_wallet_file.sh` 
```
Usage: ./check_wallet_file.sh -s <wallet-server> [-f <file>] [-p <nagios_servers>] -d -h 
    Nagios/Icinga check for wallet file object test 
    -s <wallet server>: wallet server name is required 
    -f <file>: file to look for. Default is "config/its-idg/wallet/test"
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers> 
    -d: Set debug flag on 
    -h: this help message 
```

`/usr/lib/nagios/plugins/check_wallet_backups.sh`
``` 
Usage: ./check_wallet_backups.sh [-e <environment>] [-k <key-file>] [-u <url>] [-s <server>] [-p <nagios_servers>] -d -h
    Nagios/Icinga check for wallet backup test 
    -e <environment>: wallet environment, default is dev 
    -k <key-file>: where to find the json key for the backup bucket 
       (default is "/etc/wallet/gcs_wallet_user_serviceaccount.json") 
    -u <url> storage url, default is "gs://stage-uit-authnz-wallet-backup/dev/wallet-db" 
    -s <server>: the server in nagios to report this under for passive check (default is hostname -s)
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers> 
    -d: Set debug flag on 
    -h: this help message 
```

`/usr/lib/nagios/plugins/check_wallet_crud.sh`
``` 
Usage: ./check_wallet_crud.sh -s <wallet-server> [-i <item>] [-p <nagios_servers>] -d -h 
    Nagios/Icinga check for wallet crud test including creating and deleting a file object
    -s <wallet server>: wallet server name is required 
    -i <item>: item to crud. Default is password/wallet-tester/\$wallet-server/testword 
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers> 
    -d: Set debug flag on 
    -h: this help message
```

`/usr/lib/nagios/plugins/check_wallet_keytab.sh`
```
    Usage: ./check_wallet_keytab.sh [-s <wallet-server>] -k <keytab> [-p <nagios_servers>] -d -h
    Nagios/Icinga check for wallet keytab test.
    -s <wallet server>: wallet server name is required, default is 'hostname -s'
    -k <keytab>: keytab to test. Must be specified.
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers>
    -d: Set debug flag on
    -h: this help message
Note: You must run this with an unchanging keytab on the read-only 
      replicas, otherwise you will get false alarms.
```

`/usr/lib/nagios/plugins/check_wallet_file_replication.sh`
``` 
Usage: ./check_wallet_file_replication.sh -s <master-server> [-p <nagios_servers>] -d -h
    Nagios/Icinga check for wallet file object replication test
    -s <master server>: master server name is required
    -p <nagios_servers> Use Nagios passive mode to submit to <nagios_servers>
    -d: Set debug flag on
    -h: this help message 
```
