# NAME

cron-maint - www-scheduler maintenance script

# USAGE

cron-maint _ACTION_ \[options\]

# DESCRIPTION

Use **cron-maint** for www-scheduler maintenance tasks. ACTION should be one of

     manual
     active
     inactive
     expired
     expire
     show-expire
     show-id
     activate-id
     deactivate-id
     expire-id
     show-expire-id
     touch-id
     is-expired-id

# ACTIONS

## manual

Display this man page.

## active

List all the records that have their `cr_active` field set to "Yes". The results
will be a sequence of records each line of which is formatted as

    ID,REQUESTER,MODIFIED_DATETIME

## inactive

List all the records that have their `cr_active` field set to "No".
The results will be a sequence of records each line of which is formatted as

    ID,REQUESTER,MODIFIED_DATETIME

## expired

List all the records whose `cr_modified` field is at least 365 days in the
past and whose `cr_active` field is set to "Yes".
The results will be a sequence of records each line of which is formatted as

    ID,REQUESTER,MODIFIED_DATETIME

## expire

Find all records that are active and whose last modify date is at least
365 days in the past. For these records set them to be inactive and send
an e-mail to the e-mail address in the `cr_email` field informing them
that this record has been deactivated. Note that this process
does _not_ change the value of the `cr_modified` field.

## show-expire

This action is a _dry-run_ version of the expire action.
Find all records that are active and whose last modify date is at least
365 days in the past. Do not change these records but instead
print to standard output the e-mail that _would_ be sent if
you had actually run the expire command.

## show-id _id_

Show the details for the record with `cr_id` equal to _id_.

## activate-id _id_

Activate record _id_, i.e., set the `cr_active` field for the record with
`cr_id` equal to _id_ to "Yes". This action does _NOT_ change the last-modified time
for the record.

## deactivate-id _id_

Deactivate record _id_, i.e., set the `cr_active` field for record with
`cr_id` equal to _id_ to "No". This action does _NOT_ change the last-modified time
for the record.

## expire-id _id_

Deactivate the record with `cr_id` field equal to _id_ to "No" and send
an e-mail informing the requester that the record has been deactivated.
Note that this action happens regardless of whether the record is already
deactivated or what the last-modified time is.

## show-expire-id _id_

This action is a _dry-run_ version of the expire-id action.
This will show the e-mail that would have been sent to the requester
if the record has actually been expired.

## touch-id _id_

Set the last-modified time of record _id_ to the currrent datetime.

## is-expired-id _id_

Exits with exit code 0 if the record _id_ has a last modified time more
than a year in the past; exits with code 1 otherwise. Whether the record
is active or not is ignored.

# OPTIONS

- **--verbose**

    Show extra information when running.

# EXIT STATUS

The script will exit with 0 if the script completes and there were no
failures, 255 for any other reason. The _is-expired-id_ action exits with code 0 if
the supplied id is expired, and with exit code 1 if not expired.

# EXAMPLES

List all records that are active:

    cron-main active

List all records that are not active:

    cron-main inactive

Deactivate all active records whose last-modified time is at least 365 days
in the past and send an e-mail to the requester informing them that their
job has been deactivated:

    cron-main expire

Do a dry-run of the above:

    cron-main show-expire

Display record 1234's details:

    cron-main show-id 1234

# BUGS AND LIMITATIONS

None known.

# CONFIGURATION

Configuration is managed via the the file
`/etc/www-scheduler/www-scheduler-config.yaml`.

# SEE ALSO

????(1)

# AUTHOR

Adam Lewenberg <adamhl@stanford.edu>

# LICENSE AND COPYRIGHT

Copyright 2022 The Board of Trustees of the Leland Stanford Junior
University.  All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Stanford University not be used in
advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  Stanford University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
