package Stanford::Schema::WebApps::SharedEmail::Result::AccountOwner;

use strict;
use warnings FATAL => 'all';

use base qw(DBIx::Class::Core);

__PACKAGE__->table('accountowner');
__PACKAGE__->add_columns(
    account => {
        data_type     => 'char',
        size          => 32,
        is_nullable   => 0,
    },
    owner => {
        data_type     => 'char',
        size          => 8,
        is_nullable   => 0,
    },
);

# This bears special mention.  With DBIx::Class, setting a primary key is
# *not* the same as requiring that the primary key be unique.  Instead,
# DBIx::Class uses it as the column for things like updates and deletions.
__PACKAGE__->set_primary_key('account');

# sqlt_deploy_hook: Hook table creation to add an index on 'account'.
sub sqlt_deploy_hook {
    my ($self, $sqlt_table) = @_;

    $sqlt_table->add_index(
        name => 'account_idx',
        fields => ['account', 'owner'],
    );

    return;
}

1;
