package Stanford::Schema::WebApps::SharedEmail::Result::Account;

use strict;
use warnings FATAL => 'all';

use base qw(DBIx::Class::Core);

__PACKAGE__->table('account');
__PACKAGE__->add_columns(
    account => {
        data_type     => 'char',
        size          => 32,
        is_nullable   => 0,
    },
    description => {
        data_type     => 'text',
        is_nullable   => 0,
    },
    requestor => {
        data_type     => 'char',
        size          => 8,
        is_nullable   => 0,
    },
    org => {
        data_type     => 'char',
        size          => 4,
        is_nullable   => 0,
    },
    sponsor => {
        data_type     => 'char',
        size          => 8,
        is_nullable   => 0,
    },
    additional => {
        data_type     => 'text',
        is_nullable   => 1,
    },
    when_requested => {
        data_type     => 'timestamp',
        is_nullable   => 0,
        default_value => \'CURRENT_TIMESTAMP',
    },
    when_reviewed => {
        data_type     => 'timestamp',
        is_nullable   => 1,
    },
    reject_reason => {
        data_type     => 'text',
        is_nullable   => 1,
    },
    is_approved => {
        data_type     => 'tinyint',
        size          => 1,
        is_nullable   => 0,
        default_value => '0',
    },
    when_created => {
        data_type     => 'timestamp',
        is_nullable   => 1,
    },
    when_moved => {
        data_type     => 'timestamp',
        is_nullable   => 1,
    },
);
__PACKAGE__->set_primary_key('account');

__PACKAGE__->has_many('owners',
'Stanford::Schema::WebApps::SharedEmail::Result::AccountOwner');
__PACKAGE__->has_many('forwards',
'Stanford::Schema::WebApps::SharedEmail::Result::AccountForward');


# sqlt_deploy_hook: Hook table creation to add indexes.
sub sqlt_deploy_hook {
    my ($self, $sqlt_table) = @_;

    $sqlt_table->add_index(
        name => 'when_reviewed_idx',
        fields => ['when_reviewed', 'when_requested'],
    );
    $sqlt_table->add_index(
        name => 'when_created_idx',
        fields => ['when_created', 'when_requested'],
    );
    $sqlt_table->add_index(
        name => 'when_moved_idx',
        fields => ['when_moved', 'when_requested'],
    );

    return;
}

1;
