# NAME

shared-email-manage - CLI manager for shared-email database

# SYNOPSIS

shared-email-manage manual

shared-email-manage help

shared-email-manage list

shared-email-manage show _account_

shared-email-manage delete --delete _account_

shared-email-manage unapprove _account_

# DESCRIPTION

**shared-email-manage** is a command-line script to help manage the
shared-email database. It can list, show, delete, and unapprove shared-email
records. This script must be run in a context containing the shared-email
configuration file.

# ACTIONS

There are six "actions": list, show, delete, unapprove, manual, and help.

The list action lists all the records in the database with their
status. The output looks like this:

    aaalabaws,provisioned
    aabs2018conf,provisioned
    aafacultysearch,provisioned
    aarcturoring,pending
    ...

The string following the comma is the status. There are four statuses:
"provisioned", "pending", "approved", and "rejected".

    pending --> approved --> provisioned
       |
       `------> rejected

provisioned: the shared-email account has been approved and provisioned in
Office365. There is nothing further to be done for this record.

rejected: the shared-email account request has been rejected by a
shared-email admin.  There is nothing further to be done for this record.

approved: the shared-email account request has been approved by a
shared-email admin but not yet been provisioned

pending: the shared-email account request has not yet been approved by a
shared-email admin.

The "show" action shows detailed information about a single shared-email account.

The "delete" action deletes a single shared-email account record out of
the database. Note that this action does NOT delete any other shared-email
artifiacts, e.g., it is does not delete the office365: Stanford Workgroup
or the Office365 account itself. All those deletions must be done
manually.

The "unapprove" action alters the given shared-email account record
setting the `is_approved` field to "0" and setting the `when_reviewed`
field to NULL. If the shared-email is not yet approved this action will
have not effect.

The "manual" action displays the man page.

The "help" action displays a short help text.

# OPTIONS

- **--delete**

    Use this option when deleting a record. It serves no other purpose than
    making the user typing the command extra mindful that he is deleting a
    record.

# EXIT STATUS

Returns `0` on success, `1` on any failure.

# LICENSE AND COPYRIGHT

Copyright 2021 The Board of Trustees of the Leland Stanford Junior
University.  All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Stanford University not be used in
advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  Stanford University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
