[[_TOC_]]

# Shared Email web application

## Overview

The [Shared Email service][10] allows a Stanford person or group to
request a new account for shared mail. This repository contains the
software that runs the web application used for requesting and managing
shared email accounts.

A new account shared email is added to the LDAP accounts tree and a new account is
created in Office365. The `suMailDrop` attributes of the new LDAP accounts
tree entry tell the mail router where to deliver mail addressed to the
shared mail address.

Forwarding: Up to three addresses can be specified as recipients of copies
of mails sent to the shared email account. Note, however, that if the
"Keep a copy of email in the mailbox" box is checked then delivered mail stays
in the shared mail account's mailbox (e.g., stays in Office365) and this
counts as one of the three recipients.

This repo was migrated from the stanford-server-tools-mail package
currently hosted here:
`ssh://gitolite@git.stanford.edu/server/stanford-server-tools-mail`

See also these projects:

* [Shared e-mail Docker project][6]

* [Shared e-mail Helm project][7]

* [Shared e-mail Kubernetes service page][8]


## Workflow

```mermaid
graph LR
    A[Submission] --> B[Approval] --> C[Sponsorship] --> D[WG Linkage]

    M1(Submitter)
    M2(Sponsor)
    L1(LDAP)

    A -.->|mail notification| M1
    B -.->|mail notification| M2
    C -->|insert entry| L1
```

1. [web app] _Client requests a new shared mail account._ For details on
   what information must accompany the request see ["The requester
   interface"](#the-requester-interface) below. The request creates a new
   record in the shared-email database.

1. [web app] _Service Desk approves the request._ Every so often the
   Service Desk checks to see if there are any shared mail account
   requests not yet approved.  For any such requests the Service Desk
   looks over the request and verifies that the account name is
   appropriate (not too generic, does not collide with another group's
   name, is not a person's name, etc.).  If the request looks good the
   Service Desk marks the request as approved.  As part of the approval
   process the web application creates a Workgroup with stem `office365:`
   and tells the Accounts system to make the new name accessible to
   Sponsorship Manager by creating a "functional account". The web
   application also sends mail to the sponsor (the "Sponsor SUNetID"
   address) telling them that the account can now be sponsored.


1. [manual process] _Account is sponsored._ Service Desk approval creates
   the functional account but now someone has to sponsor the account in
   [Sponsorship Manager][3] (be sure to choose "Shared email" in the
   "Sponsor a service" pull-down). This is usually the the person listed
   in the "Sponsor SUNetID" field but can be anyone with sponsorship
   access. Once sponsored Sponsorship Manager automatically creates the
   accounts entry in LDAP.  For example, if the account name is
   `our-research-group` the entry in the accounts tree will be
   `uid=our-research-group,cn=accounts,dc=stanford,dc=edu`.

   Note: One can usually determine that an LDAP accounts entry is a
   "functional" account by the fact that the account name has at least
   nine characters (sunetid's are eight characters or fewer), although a
   handful of functional account names have fewer than nine characters.
   Furthermore, shared-email accounts do not have any `suPrivilegeGroup`
   attributes.

1. [cron jobs] _Workgroup Linkage._ UPDATE: As of 2025-05-01 we no longer
   use either of these two linkage processes. So this entire step can be skipped.

   There are two cron jobs that do
   workgroup linking.  The first
   ([`shared-email-link`](usr/sbin/shared-email-link)) runs every hour looking
   for approved shared-email requests. For any approved requests that have
   not yet been linked in the Workgroup Linkage system to a Windows Active
   Directory group, a remctl call is made to make that linkage.

   The second job ([`shared-email-create-cal-wg`](usr/sbin/shared-email-create-cal-wg)) runs
   every hour looking for new [CRDB calendar resources](???) and creates a
   Stanford Workgroup for that calendar resource and, like
   `shared-email-link`, links the workgroup to an Active Directory group.

   IMPORTANT: According to Jason Cowart the "Stanford Group Manager"
   service will do the Workgroup Linkage. So, once "Stanford Group
   Manager" is in production we can eliminate the `shared-email-link` cron
   job and remove the AD linking part of `shared-email-create-cal-wg`.

   UPDATE: (March 2022) The MaIS team has put into place an hourly process
   that looks for `office365:*` workgroups that have not been linked to
   their Active Directory group. As such we no longer need the
   `shared-email-link` cron job and can remove the AD linking part of
   `shared-email-create-cal-wg`. See also the `link_workgroup_enabled`
   configuration directive in ["Workgroup Linkage
   settings"](#workgroup-linkage-settings).

1. [on-premise Exchange server] _Office 365 provisioning._
   A scheduled task on an on-premise Exchange server
   looks for approved accounts every three hours and creates them,
   setting appropriate permissions. A second task moves
   those mailboxes up to the cloud. These processes are owned by the Windows
   group (currently Joshua Barnett's team). The processes use the `/remote` endpoint
   of the shared-email web application to get the list of accounts
   and to update the database once the account is
   moved; see section "The `/remote` path functions"
   below for more information on the `/remote` endpoint.

   The cron job and exchange server are not dependent on the
   sponsorship. Thus it possible that the O365 account exists and can be
   accessed but will never get any mail (Proofpoint needs the LDAP entry
   to route mail to Office365).

   Currently there are no Windows systems tied-in with the non-production
   web application database.


## Components

There are three components of the shared-email request system that
are handled by the software in this repository:

1. the request web application (steps 1 and 2 above)

1. cron jobs making the Workgroup Linkage (step 4 above)

1. the `/remote` web interface the Exchange script uses (part of step 5 above)

There is also a utility script that helps with manual account database
maintenance.

### Web Application

#### Access control and authentication attributes

In general this web application does provide an authentication layer.
Authentication enforcement is left to the deployer (e.g., SAML). This
application _does_ require that the environment variable `REMOTE_USER` be
set to the SUNetid of the authenticated user so that the correct user is
notified when the shared e-mail account is set up.

If the environment variable `WEBAUTH_LDAP_SUPRIMARYORGANIZATIONID` is set,
this value will be used as the default Org ID on the request page.
However, this environment variable is _not_ required and if omitted the
Org ID field will be left blank; the requester will still need to fill it
in with a valid Org ID.

The [`/admin` endpoint](#the-admin-interface-admin) is meant only for
Shared Email administrators; it is up to the deployer to protect that
page.

The [`/remote` endpoint](#the-remote-path-functions) is meant for a remote
script to update the database. It must also be protected by the deployer.


#### The requester interface

1. A requester fills out a web form asking that a new shared mail
   account be created. The request includes a name for the account, a
   description of the account, the SUNet id of a sponsor, up to three
   sunet ids who will act as owners for the account, and an [org id][1]
   representing the Stanford organization managing the shared
   account. Furthermore, the requester lists from one to three forwarding
   mail addresses associated with this account.

   The Service Desk is not notified directly. Rather, the Service Desk checks
   a few times a day to see if there are new requests.

1. When the requester presses submit the request is validated. There are
   several validations (some of these validations include remctl calls to
   external servers):

   * the account name has the correct format and does not already exist,
     i.e., there is no existing accounts tree entry with a `suSeasSunetID`
     attribute matching the requested shared-account name

   * the description is not too long

   * the account owners are valid Stanford users

   * the org id is valid

   * the forwarding addresses are properly-formatted

1. Assuming the request is valid, the request is added to the shared
   mail database and, if the database save is successful, an mail is sent
   to the requester letting them know that the request has been submitted.

#### The admin interface (`/admin`)

The admin page is restricted to users in the `acs:team` and
`helpdesk:techsupport` Stanford Workgroups.

When an admin pushes the "Approve" button the application does the
following:

1. A new Stanford Workgroup `office365:ACCOUNT_NAME` is created using the
Workgroup API. The owners of this shared mail account are added as both
members and admins to this new workgroup.

1. A remctl call is made to an Accounts server that creates a "functional
account". This creates an entry so that someone with sponsorship rights
can then go and sponsor the account in [Sponsorship Manager][3].

1. Mails are sent notifying of the provisioning. The mails go to the
requester, the sponsor, and to the addresses in the application configuration
directive `shared_email_backend_list`.

1. Other independent jobs run that finish the provisioning.  See
["Workflow"](#workflow) for more information on these independent jobs.

#### The `/remote` path functions

There are two scripts in the `/remote` path:
[`new-list.pl`](usr/share/shared-email/cgi-bin/remote/new-list.pl) and
[`setdate2.pl`](usr/share/shared-email/cgi-bin/remote/setdate2.pl). Because
the Exchange scripts that call the functions in `/remote` are automated,
the `/remote` should require non-SAML authentication, for example, basic
authentication. The workflow is that the Exchange server script calls
`new-list.pl` to get a list of all the accounts that need to be created,
creates them, and then calls `setdate2.pl` on each created account to mark
them as created.

* `new-list.pl`: this script returns a new-line delimited list of accounts
in the shared-email database that have not yet been created in Office365.

* `setdate2.pl`: this script takes a single parameter: the account name
and updates the database by setting the `when_created` field for that
account to the current date and time. This indicates that the Office365
account has been created.

#### The maintenance page (`/maintenance`)

A maintenance page is supplied at
`/usr/share/shared-email/maintenance/index.html` for those times when the
application needs to be "turned off", i.e., put in maintenance mode.

### Workgroup linkage scripts (cron jobs)

There are two scripts that create the required Workgroup Linkages. The two
scripts are [`shared-email-link`](usr/sbin/shared-email-link) and
[`shared-email-create-cal-wg`](usr/sbin/shared-email-create-cal-wg).  For
more information on these scripts see the "_Workgroup Linkage_" portion of the
["Workflow" section](#workflow) above. These scripts are intended to be
run periodically, for example as cron jobs.

There is also the script
[`shared-email-link-jobs`](usr/sbin/shared-email-link-jobs) which wraps
the two linkage scripts and runs one or both depending on the values of
the environment variables `SHARED_LINK_ENABLED` and
`CREATE_CAL_WG_ENABLED`.

### Utility scripts

#### `shared-email-manage`

This script allows you to do some data management via the command line.
See the [script's man page](docs/shared-email-manage) for more
information.

## Notes

1. Even if a shared mail account is approved in this application
it must still be sponsored in [Sponsorship Manager][3] before it will
appear in the LDAP.

1. The shared-email web application is only used for the initial
set-up. Changes to the account such as updating the list of recipients of
forwarded mails are done outside of the application. Thus over time what
is shown in this application for approved requests may differ from what is
in the LDAP.

## Configuration

The application is configured via the YAML file
`/etc/shared-email-web/config.yaml`.

### General settings

* `platform`: must be one of `dev` or `prod`.

* `shared_email_backend_list`: a single mail address that receives a
notification of approvals; the recipient of this notification is expected
to carry out some manual tasks. (According to Jason Cowart all the "manual
tasks" have since been automated.)

* `shared_email_max_forwards`: The maximum number of addresses that are
allowed to receive forwarded copies of mail sent to the shared account;
note that if a copy is kept on the mail server that counts as one of the
addresses.

### Database settings

* `shared_email_db_host`: hostname or IP address of the database host.

* `shared_email_db_name`: database name.

* `shared_email_db_user`: database username used when logging into the
database server. This user must have read and write access to the database
specified by `shared_email_db_name`.

* `shared_email_db_passwd_file`: The full path to a file containing the
password associated with the database user `shared_email_db_user`. This
file should consist of a single line which is the password itself.

### Kerberos settings

The shared-email web application needs to make remctl calls and read from
the LDAP. Both of these require a GSSAPI context. The application expects
to find a Kerberos keytab file containing credentials of a Kerberos
principal with sufficient access.

* `krb5_keytab`: The path to the keytab file.  Should normally be
`/etc/shared-email-web/keytab`.

* `ccache`: The path where Kerberos credentials created from the keytab
`krb5_keytab` are cached.

### LDAP settings

The shared-email web application queries the LDAP to verify that the
requested shared account name is not already taken. It also queries the
organizations tree. More specifically, the Kerberos principal (see
["Kerberos settings"](#kerberos-settings)) needs to be
able to read these attributes:
```
suAdminID, displayName (cn=organizations,dc=stanford,dc=edu)
suSeasSunetID          (cn=accounts,dc=stanford,dc=edu)
```

* `ldap_server`: The name of the LDAP server to query.

### Remctl settings

The shared-email web application makes remctl calls to the Accounts
system. One of these remctl calls is to do a `sunetid-verify` on the
requested shared-email account name to ensure that it is not already
taken.  The other is when the shared-email account creation request is
approved in the admin interface in which case a remctl call is made to
create a new entry for the requested shared-email account.

See also ["remctl access"](#remctl-access).

* `acctsponsor_server`: The name of the MaIS system for making remctl
calls related to accounts and sponsorship.  This used to be
`acct-scripts`.

* `acctsponsor_server_principal`: The Kerberos principal name
to use when making remctl calls to `acctsponsor_server`.

* `workgroup_link_server`: The name of the MaIS system for making remctl
calls to create workgroup linkages.

* `workgroup_server_principal`: The Kerberos principal name
to use when making remctl calls to `workgroup_server`.

* `workgroup_link_environment`: this should be set to `prod` when making
workgroup linkage remctl calls to the production `workgroup_link_server`,
and set to `uat` when making workgroup linkage remctl calls to the
non-production `workgroup_link_server`.

### Workgroup API settings

When the shared-email account is created part of the process is to create
a new [Stanford Workgroup][2] in the `office365` stem. This creation is done
using the Workgroup API.

* `wgapi_version`: the version of the Workgroup API to use. There are
only two valid values: `v1` (version 1) and `v2` (version 2). Set
`wgapi_version` to `v1` to use the [older SOAP API interface][11]; set
`wgapi_version` to `v2` to use version 2 of the [RESTFul API
interface][12]. Version 2 supports basic authentication.
Default: `v1`.

#### Workgroup API settings: `v1` (version 1)

The following are used when `wgapi_version` is set to `v1`.

* `shared_email_wxml_urlbase`: The base URL for the Workgroup API.

* `shared_email_wxml_key`: The _private_ part of the credentials used to
access the Workgroup API.

* `shared_email_wxml_cert`: The _public_ part of the credentials used to
access the Workgroup API.

#### Workgroup API settings: `v2` (version 2)

The following are used when `wgapi_version` is set to `v2`. When using
version 2 of the Workgroup API the shared-email application only supports
basic authentication.

* `wgapi_v2_url_base`: The base URL for the Workgroup API, version 2. Be
sure to _omit_ the trailing forward slash. For UAT this should be set to
`https://aswsuat.stanford.edu/mais/workgroupsvc/workgroups/2.0`; for PROD
this should be set to
`https://aswsweb.stanford.edu/mais/workgroupsvc/workgroups/2.0`;

* `wgapi_v2_username`: The username to use when authenticating to the
version 2 Workgroup API.

* `wgapi_v2_password_file`: The full path to a file containing tghe
password to use when authenticating to the version 2 Workgroup API.
The file should be a single line consisting of the password.
Default: `/etc/shared-email-web/wgapi-v2-password.txt`.


### Workgroup Linkage settings

The cronjobs mentioned in the [Workflow section](#workflow) make remctl
calls to create a Workgroup Linkage from the Stanford workgroup
to a Windows group in Active Directory. The settings in this section
relate to this linkage creation. All the following settings are required.

* `link_workgroup_enabled`: if set to the string `yes` enabled Workgroup
linking, otherwise Workgroup linking is disabled. If disabled the other
`workgroup_link_*` configuration directives are ignored.

* `workgroup_link_server`: the server that the remctl call should be made to.

* `workgroup_link_server_principal`: The Kerberos principal to use when
making the remctl call.

* `workgroup_link_environment`: the Stanford Workgroup environment being
used. This should be either `prod` or `uat`; no other values are
supported.

### Calendar Resource Database (CRDB)

One of the cronjobs from the [Workflow section](#workflow) is
`shared-email-create-cal-wg` which creates the shared email account for a calendar
resource in the CRDB system. In order to do this the script
`shared-email-create-cal-wg` must connect to the CRDB. The settings in this section
relate to connecting to the CRDB. Note that no other part of the
shared-email application needs the settings from this section: they are
needed only for `shared-email-create-cal-wg`.

* `crdb_db_host`: the hostname of the MySQL database server hosting the
CRDB application data.

* `crdb_db_name`: the database name for the CRDB data.

* `crdb_db_user`: the username to use when connecting to the database.

* `crdb_db_passwd_file`: the file containing the password to use when
connecting to the database.

### SMTP settings

On successful submission and on successful approval the shared-email
application sends notification e-mails. The shared-email application
supports both authenticated and unauthenticated SMTP e-mail sending. The
following settings configure the application so that it can send these
e-mails.

* `send_email_smtp_host`: the SMTP host to use when sending
e-mails. Default: `smtp.stanford.edu`.

* `send_email_smtp_port`: the SMTP port to use when connecting to
`send_email_smtp_host`. Default: 465

* `send_email_from`: the e-mail address to use in the "From:" header. No default.

* `send_email_use_auth_enabled`: if you need to use username and password
in order to send e-mail set this parameter to "YES", otherwise set it to
"NO". If set to "YES" both `send_email_use_auth_username` and
`send_email_use_auth_password_file` must be set. No default.

* `send_email_use_auth_username`: the username to use when authenticating
to the SMTP server before sending. No default.

* `send_email_use_auth_password_file`: the full path to the file
containing the password to use when authenticating to the SMTP server
before sending. No default.

## Network Access

For this application to work properly it needs to be able to access a few
external services. These services need to be open to this application's IP
address. The external services are:

* Stanford LDAP (`ldap_server`): port 389

* Remctl access (`acctsponsor_server`): port 4373.

* MySQL database server (`shared_email_db_host`): port 3306


## Database tables

### `account`

    +----------------+------------+------+-----+-------------------+-------+
    | Field          | Type       | Null | Key | Default           | Extra |
    +----------------+------------+------+-----+-------------------+-------+
    | account        | char(32)   | NO   | PRI | NULL              |       |
    | description    | text       | NO   |     | NULL              |       |
    | requestor      | char(8)    | NO   |     | NULL              |       |
    | org            | char(4)    | NO   |     | NULL              |       |
    | sponsor        | char(8)    | NO   |     | NULL              |       |
    | additional     | text       | YES  |     | NULL              |       |
    | when_requested | timestamp  | NO   |     | CURRENT_TIMESTAMP |       |
    | when_reviewed  | timestamp  | YES  | MUL | NULL              |       |
    | reject_reason  | text       | YES  |     | NULL              |       |
    | is_approved    | tinyint(1) | NO   |     | 0                 |       |
    | when_created   | timestamp  | YES  | MUL | NULL              |       |
    | when_moved     | timestamp  | YES  | MUL | NULL              |       |
    +----------------+------------+------+-----+-------------------+-------+


* `when_created`: the datetime when the account is created in Office365.

* `when_moved`: the datetime when the Stanford Workgroup linkage is
created. *UPDATE (2022-03-20):* The MaIS servers are now doing the Workgroup
Linkage themselves so the shared-email-web application no longer has any
chance to update the `when_moved` field. In other words, the `when_moved`
field will ALWAYS be NULL. That is, the `when_moved` field no longer
serves any purpose. See also the [`new-list.pl`
script](usr/share/shared-email/cgi-bin/remote/new-list.pl).



### `accountforward`

    +---------+-------------+------+-----+---------+-------+
    | Field   | Type        | Null | Key | Default | Extra |
    +---------+-------------+------+-----+---------+-------+
    | account | char(32)    | NO   | MUL | NULL    |       |
    | forward | varchar(67) | NO   |     | NULL    |       |
    +---------+-------------+------+-----+---------+-------+

### `accountowner`

    +---------+----------+------+-----+---------+-------+
    | Field   | Type     | Null | Key | Default | Extra |
    +---------+----------+------+-----+---------+-------+
    | account | char(32) | NO   | MUL | NULL    |       |
    | owner   | char(8)  | NO   |     | NULL    |       |
    +---------+----------+------+-----+---------+-------+

## remctl access

* `account-create-functional submit` against server `acctsponsor_server`:
This creates a "functional" account in the LDAP accounts tree.

* `sunetid-verify show` against server `acctsponsor_server`:
Checks to see if the requested account already exists.

* `wg-int-api link_group` against server  `workgroup_link_server`:
Create a Workgroup Manager linkage from a workgroup to an Active Directory group.

## LDAP

The LDAP is queried

* to verify that the org id is valid and to return an org id's full name,
  and

* to verify that the owner account name does not match an existing sunetid
  alias

## Stanford Workgroup API

As part of the shared-email account setup a new [Stanford Workgroup][2] is
created and populated with the account owners. The Stanford Workgroup API
has two interfaces: version 1 (`v1`) and version 2 (`v2`). See section
["Workgroup API settings"](#workgroup-api-settings) for details on how to
configure for each version of the API.

## Testing

### Testing the main application

Here are the steps to perform a test against the non-production instance.

1. Go to the non-production web site:
https://shared-email-test.stanford.edu/ for the non-production instance
and https://shared-email.stanford.edu/ for the production instance.

1. Add a new shared account. For Sponsor SunetID put in a uid other than
your own. Click the checkbox "Keep a copy of email in the mailbox?".
Add a second e-mail address to the "Forwarding Addresses #2" text box.

1. Push "Submit".

1. The resulting page should say "Thank you for your request
submission.". If there are any errors displayed on this page the test has
failed.

1. Verify that the submitter (you) and the Sponsor received a
notification e-mail.

1. Go to the admin page and "Approve".

1. Verify that the account is in the [Workgroup Manager][2] (or
[UAT Workgroup Manager][5] for non-production). The
workgroup name will be "office365:NAME_OF_ACCOUNT" where "NAME_OF_ACCOUNT"
is the shared account name you entered in Step 1. Verify that the admins
are members of the group as well as administrators of the workgroup.

1. Go to the [Sponsorship Manager][9] (or [UAT Sponsorship Manager][4] for
non-production) and under "Sponsor a Service" choose "Shared email".

1. In "Step 1: Sponsorship details" click "Next".

1. In "Step 2: Search for sponsee" type in the NAME_OF_ACCOUNT
and click search. If it is not found you will know something in the above
process failed. Once found, click the blue "Sponsor" button.

1. In "Step 3: Confirmation" check the terms-and-conditions
checkbox and click the blue "Finish" button.

1. The LDAP accounts tree will be updated with a new entry for the
functional account (it may take a few minutes). To see this entry use
ldapsearch:

        $ ldapsearch -H ldap://ldap.stanford.edu -b uid=NAME_OF_ACCOUNT,cn=accounts,dc=stanford,dc=edu       (PROD)
        $ ldapsearch -H ldap://ldap-uat.stanford.edu -b uid=NAME_OF_ACCOUNT,cn=accounts,dc=stanford,dc=edu   (NON-PROD)

1. If no result comes back for the above ldapsearch something is wrong
(check with MaIS that the slog has not crashed).

1. The rest of the steps can be done with production only as there is currently
no way for the UAT Workgroup Manager to link to UAT Windows AD.

1. [PROD ONLY] Link the Stanford Workgroup to an Active Directory group. Do this by running
`shared-email-link`. (For the Kubernetes cluster deployed instance use
remctl.)

        $ kremctl --dev shared-email shared-email-link shared-email-test
        $ remctl        shared-email shared-email-link shared-email-prod

        (or, if you don't have kremctl installed)

        $ remctl -s service/remctl-central-dev  remctl-central-stage.stanford.edu shared-email shared-email-link shared-email-test
        $ remctl -s service/remctl-central-prod remctl-central-prod.stanford.edu  shared-email shared-email-link shared-email-prod

1. [PROD ONLY] After running `shared-email-link` check that the workgroup
`office365:NAME_OF_ACCOUNT` in the [Workgroup Manager][2] (or [UAT
Workgroup Manager][5] for non-production) indicates it is linked to Active
Directory.

1. [UNDER CONSTRUCTION] The next step _would_ be to verify that the the
corresponding groups was created in UAT Active Directory. However,
according to Edward Louie, the UAT Workgroup Manager API calls to WINUAT
is broken. It is not clear when this get fixed. Thus, there is no way to
verify that the group actually got created in WINUAT.

1. The scripts on the Exchange server that provisions the Office365
account runs once every three hours. Once enough time has elapsed test by
sending an e-mail to the new account.

### Testing CRDB linking

The easiest way to test CRDB account linking in UAT is to copy the production
CRDB database into UAT. Then run the linking script in link-one mode(??)

1. Copy the production CRDB database into UAT. The production database is
currently hosted on mysql-app.stanford.edu and the crdb remctl endpoint is
crdb.stanford.edu.


### How to remove a shared e-mail account

1. [IEDO] Delete the account from the shared-email database backend. Use the
[shared-email-manage script](usr/sbin/shared-email-manage) to do this. See
the [shared-email-manage script manpage](docs/shared-email-manage) for
more information.

1. [IEDO] Unlink the `office365:` workgroup in Workgroup Manager.

1. [IEDO/MAIS] End the sponsorship in Sponsorship Manager

1. [MAIS] Delete the workgroup from Workgroup Manager.

1. [MAIS] Remove the account from Sponsorship Manager. (Need MaIS's help with
this.)

1. [MAIS] Delete the account.

1. [WINDOWS] Remove the account from Office365.



[1]: https://web.stanford.edu/dept/pres-provost/budget/org/orgchart/index.html

[2]: https://workgroup.stanford.edu

[3]: https://uit.stanford.edu/service/sponsorship

[4]: https://sponsorship-uat.stanford.edu/

[5]: https://workgroup-uat.stanford.edu/

[6]: https://code.stanford.edu/et-iedo/docker/docker-shared-email

[7]: https://code.stanford.edu/et-iedo/helm/helm-shared-email

[8]: https://code.stanford.edu/et-iedo/kube-shared-email/-/blob/master/service.md

[9]: https://sponsorship.stanford.edu/

[10]: https://uit.stanford.edu/service/sharedemail

[11]: https://uit.stanford.edu/developers/apis/workgroup

[12]: https://uit.stanford.edu/developers/apis/workgroup2.0
