#!/usr/bin/perl
#
# Check that too-new features of Perl are not being used.
#
# The canonical version of this file is maintained in the rra-c-util package,
# which can be found at <http://www.eyrie.org/~eagle/software/rra-c-util/>.
#
# Written by Russ Allbery <rra@stanford.edu>
# Copyright 2013
#     The Board of Trustees of the Leland Stanford Junior University
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

use 5.006;
use strict;
use warnings;

use lib 't/lib';

use File::Spec;
use Test::More;
use Test::RRA qw(use_prereq);
use Test::RRA::Config qw($MINIMUM_VERSION);

# We can't use the default Test::MinimumVersion rules since they're specific
# to the Perl package layout, and just adding the current directory duplicates
# checks in modules because it examines both blib and other directories.  So
# we roll our own rules.
use_prereq('File::Find::Rule');
use_prereq('File::Find::Rule::Perl');
use_prereq('Test::MinimumVersion');

# Locate all Perl files from the root directory.  Don't check blib, since that
# would result in duplicate checks.
my $blib  = File::Find::Rule->new->directory->name('blib');
my $perl  = File::Find::Rule->perl_file;
my $rule  = File::Find::Rule->new->or($blib->prune->discard, $perl);
my @files = $rule->in(q{.});

# Check all files for the minimum version used.
plan tests => scalar(@files);
for my $file (@files) {
    minimum_version_ok($file, $MINIMUM_VERSION);
}
