#!/bin/sh

# Get the latest git tag
latest_git_tag=`git describe --abbrev=0 --tags`

# Change forward slash to '-'
latest_git_tag=`echo $latest_git_tag | sed s/\\\//\-/ `

# Remove the 'debian-' part
latest_git_tag=`echo $latest_git_tag | sed s/debian-// `

# Do the in-place replacment.
sed -i "s/my\s*\$VERSION\s*=\s*'.*';/my \$VERSION = '${latest_git_tag}';/g" $1

