
# Define source files here although the tag comes later
%define vers 164
%define rel %(if [ -e /etc/centos-release ] ; then cat /etc/centos-release | grep -o -E '[0-9]+' | head -1 ; else cat /etc/redhat-release | grep -o -E '[0-9]+' | head -1 ; fi)
%define source0 redhat/stanford-server-%{vers}.tar.gz

Name: stanford-server
Summary: A collection of scripts standard for any Stanford ITS maintained server
Version: %{vers}
Release: 1.EL%{rel}
License: BSD
Group: Applications/System
BuildRoot: /var/tmp/%{name}-buildroot
Vendor: Stanford University
#Source0: ssh://git.stanford.edu/srv/git/redhat/stanford-server.git
Source0: svn://subversion/srv/svn/redhat/packages/stanford-server-%{vers}/%{source0}

BuildArch: noarch
Distribution: EL

URL: http://www.stanford.edu/

## BuildRequires (for package build)

##CentOS7 chroot requirements
%{?el7:
BuildRequires: perl-podlators
BuildRequires: perl-Exporter 
BuildRequires: perl-Carp 
BuildRequires: perl-Encode 
BuildRequires: perl-constant 
BuildRequires: perl-Getopt-Long
BuildRequires: perl-Pod-Simple
BuildRequires: perl-Pod-Escapes
BuildRequires: perl-Pod-Usage
BuildRequires: perl-PathTools
}

##CentOS8 chroot requirements
%{?el8:
BuildRequires: perl-podlators
BuildRequires: perl-Exporter 
BuildRequires: perl-Carp 
BuildRequires: perl-Encode 
BuildRequires: perl-constant 
BuildRequires: perl-Getopt-Long
BuildRequires: perl-Pod-Simple
BuildRequires: perl-Pod-Escapes
BuildRequires: perl-Pod-Usage
BuildRequires: perl-PathTools
}
##

## Requires (for package installation)
Requires: stanford-nagios
Requires: filter-syslog
Requires: newsyslog
Requires: remctl-client
Requires: remctl-server
Requires: puppet
Requires: munin-node
Requires: kstart >= 3.14-4
Requires: curl
Requires: perl-IPC-Run
Requires: perl-Getopt-Long-Descriptive
Requires: perl-Net-OpenSSH
Requires: perl-Params-Validate
#Requires: perl-Params-Validate >= 0.95
Requires: perl-Sys-Hostname-Long
Requires: perl-TermReadKey

## Provides
Provides: rebuild-iptables
#Provides: rotate-history
Provides: remctl-help

## Conflicts (RPM package conflicts)
#Conflicts: kftgt-SU

%description
Provides scripts stanford for all Stanford ITS maintained Red Hat servers.  
This includes:
 * rotate-history script, which rotates the history of the root user. 
 * rebuild-iptables script, which rebuilds the iptables file using fragments
   found in /etc/iptables.d
 * cron job to keep remctl acl updated
 * remctl commands for puppet
 * remctl command access to package manager
 * remctl command to list commands and their help
 * klogin/krsh replacement (this package conflicts with kftgt-SU now)
 * make-local-cert to generate self-signed apache certs
 * retire-system command
 * patch-system command (usually run from 'at' job)
 * multipath-local-root-wwn script
 * get-dell-warranty

%prep
# On the following line, you'll have to add "-a n" for each source file
%setup -c -n %{name}-%{version}

find . -name *.orig -exec rm {} \;

%build


%install
if [[ $RPM_BUILD_ROOT != "/" ]]
then
  rm -rf $RPM_BUILD_ROOT
fi

ls
make -f redhat/install.mk install DESTDIR=$RPM_BUILD_ROOT
cd $RPM_BUILD_ROOT/usr/local/bin/
# ln -fs klogin krsh

%clean
if [[ $RPM_BUILD_ROOT != "/" ]]
then
  rm -rf $RPM_BUILD_ROOT
fi

%files
%defattr(-,root,root)
%dir /etc/iptables
%dir /etc/iptables.d
%dir /root/.history-save
%config(noreplace) /etc/remctl/conf.d/*
#/etc/remctl/acl/monitoring
#/etc/nagios-plugins/ipmi_sel.conf
###/etc/cron.hourly/remctl-acl
###/etc/cron.d/remctl-acl-onboot
###/etc/cron.daily/wallet-rekey-periodic
###/etc/cron.daily/tripwire
/usr/sbin/*
/usr/bin/*
#/usr/lib/*
#/usr/local/bin/*
%doc /usr/share/man/man1/*

%post -p /usr/sbin/remctl-acl-update


%changelog
* Wed May 12 2021 Adam Henry Lewenberg <adamhl@stanford.edu> 164-1.EL
  - Add package dependency for remctl-acl-update-flex.

* Wed Mar 10 2021 Lonlone Lee <lonlone@stanford.edu> 163-1.EL
  - Commented out 'use autodie' from the /usr/sbin/key-system script.
  - IEDO-900 was created in order to properly test this command before it's
    re-introduced.

* Wed Mar 10 2021 Lonlone Lee <lonlone@stanford.edu> 162-1.EL
  - Added file existance check for /var/lock/key-system to keep key-system
    script from erroring out.
  - The addition of autodie was causing a problem in /usr/sbin/key-system on line 90.

* Tue Mar 09 2021 Lonlone Lee <lonlone@stanford.edu> 161-1.EL
  - Updated check_procs_perf and check_service executability

* Tue Mar 09 2021 Lonlone Lee <lonlone@stanford.edu> 160-1.EL
  - Updated check_procs_perf for command line argument check

* Tue Mar 09 2021 Lonlone Lee <lonlone@stanford.edu> 159-1.EL
  - Added check_service and check_procs_perf Nagios plugins to remctl and
    monitor base for: IEDO-725, IEDO-792

* Mon Feb 08 2021 Adam Henry Lewenberg <adamhl@stanford.edu> 158-1.EL
  - Remove nagios-alert-wrapper (should not have ever been in this
    package).

* Mon Feb 08 2021 Adam Henry Lewenberg <adamhl@stanford.edu> 157-1.EL
  - Added new script nagios-alert-wrapper.

* Thu Oct 08 2020 Lonlone Lee <lonlone@stanford.edu> 157-1.EL
stanford-server (156+nmu1) unstable; urgency=medium
  - Added update as a new parameter to monitor-base and added it to remctl
    conf.d

* Thu Sep 10 2020 Adam Henry Lewenberg <adamhl@stanford.edu> 156-1.EL
  - restart-dns-cache: A wrapper script that restarts the dnsmasq and bind
    services.

* Wed Sep 02 2020 Srinivas Rao Puttagunta <psr123@stanford.edu> 155-1.EL
  - Add the remctl ACL group "iedo" to /usr/sbin/remctl-acl-update.

* Tue Feb 25 2020 Srinivas Rao Puttagunta <psr123@stanford.edu> 154-1.EL
  - monitor-base: add the tcp monitor so that we can see if servers have
    access to services on other servers.

* Tue Dec 03 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 153-1.EL
  - Ossec-syscheck: Default email to root

* Thu Nov 21 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 152-1.EL
  -  More Updates to ossec script

* Fri Nov 15 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 151-1.EL
  - ossec-syscheck: add ossec service status check

* Thu Nov 14 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 150-1.EL
  - New script: ossec-syscheck script to perform some ossec related tasks

* Mon Nov 04 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 149-1.EL
  - New script: merge-ossec-fragments to support the su_ossec Puppet module.

* Wed Sep 11 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 148-1.EL
  - Add rsyslog-restart script to restart for programs like newsyslog that can only
    handle running a script with no arguments.

* Tue Sep 10 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 147-1.EL
  - add reboot remctl conf to reboot the servers using remctl

* Tue Aug 27 2019 Srinivas Rao Puttagunta <psr123@stanford.edu> 146-1.EL
  - debchange again to sign the package. Debsign checks the last commented user
    from the changelog file to sign the package.

* Tue Aug 27 2019 Adam Henry Lewenberg <adamhl@stanford.edu> 145-1.EL
  - [/usr/sbin/monitor-base] Exclude the tracefs file system from the disk_check
    command (permissions issue).

* Sat Aug 24 2019 Adam Henry Lewenberg <adamhl@stanford.edu> 144-1.EL
  - Move puppet-backend3 and puppet-backend5 to the new package
    stanford-puppet-backend. [adamhl]
  - Add an ntp monitor to monitor-base that can be called by the Nagios
    server via remctl. [ljlgeek]

* Wed Aug 07 2019 Adam Henry Lewenberg <adamhl@stanford.edu> 143-1.EL
  - [puppet-backend5] Puppet agent 5.5.16 outputs server_list in a
    different format than previously, so deal with that.

* Wed Jan 30 2019 Adam Henry Lewenberg <adamhl@stanford.edu> 142-1.EL
  - [remctl-acl-update] Suppress copying the "security" group from AFS for the
    Kerberos KDCs.

* Fri Oct 05 2018 Adam Henry Lewenberg <adamhl@stanford.edu> 141-1.EL
  - [remctl-acl-update] Add debian-repo-managers to the list of remctl ACL
    files to automatically copy into /etc/remctl/acl whenever
    remctl-acl-update runs. This is an innocuous action as the
    debian-repo-managers ACL file will only have an effect if someone puts
    it into a remctl conf file.

* Thu Jan 11 2018 Adam Henry Lewenberg <adamhl@stanford.edu> 140-1.EL
  - Split puppet-backend into two programs, one for the old Puppet 3
    infrastructure, and one for the new Puppet 5 infrastructure. Use
    Debian alternatives to help manage which one is used.

* Mon Jul 03 2017 Adam Henry Lewenberg <adamhl@stanford.edu> 139-1.EL
  - [key-system] Revert mistaken commenting out of important code.

* Mon Jul 03 2017 Adam Henry Lewenberg <adamhl@stanford.edu> 138-1.EL
  - [key-system] For Debian stretch (and later) add the "-u ntp" option to
    the ntpd command so we don't get file permission errors.

* Thu Feb 23 2017 Adam Henry Lewenberg <adamhl@stanford.edu> 137-1.EL
  - [/usr/sbin/remctl-acl-update] Add new remctl ACL file acs-linux to the
    script. This change means that two new files /etc/remctl/acl/acs-linux
    and /etc/remctl/acl/acs-linux-root will be added to all systems
    running remctl-acl-update. Note that adding these files has no effect
    until they some remctl configuration uses them.

* Sat Oct 01 2016 Adam Henry Lewenberg <adamhl@stanford.edu> 136-1.EL
  - Add new script: nagios-log-file-alerter. Used to help alert on scary
    things in log files. To support this, add a new remctl/conf.d file.

* Fri Jul 01 2016 Adam Henry Lewenberg <adamhl@stanford.edu> 135-1.EL
  - Fix install of run-through-filter-syslog.

* Fri Jul 01 2016 Adam Henry Lewenberg <adamhl@stanford.edu> 134-1.EL
  - Added new script: run-through-filter-syslog

* Mon Jun 13 2016 Jonathan Lent <jlent@stanford.edu> 133-1.EL
- Merge from Debian release 133:
  - remctl-acl-update: addition of groups coreinfra,as-cia,as-linuxops

* Wed Feb 10 2016 Jonathan Lent <jlent@stanford.edu> 132-1.EL
- Merge from Debian release 132:
  - puppet-backend: add resources sub-command 
  - retire-system: remove Puppet 2.x remctl calls 
  - retire-system: reach out to the V3 puppet infrastructure, add output
     relevant to which puppet infra. to give any errors context, and
     explicitly check for swhois binary before trying to execute
  - retire-system: Delete host's pam-duo object; handle case when Heimdal
     version of klist is run
  - Change DNS server name in sysname-check script.

* Tue May 12 2015 Jonathan Lent <jlent@stanford.edu> 128-1.EL
- Merge from Debian:
  - fixes to puppet-backend
  - addition of racadm-update script

* Thu Apr 30 2015 Jonathan Lent <jlent@stanford.edu> 126-1.EL
- vastly updated version eliminating backport fix packages

* Wed Jan 21 2015 Darren Patterson <darrenp1@stanford.edu> 105-3.EL
- backport fixes for wallet-rekey-periodic

* Wed Dec 17 2014 Darren Patterson <darrenp1@stanford.edu> 105-2.EL
- fixes for puppet-backend and puppet 3.

* Fri Sep 6 2013 Meei-You Lee <meeilee@stanford.edu> 105-1.EL
- Remove requirement to run retire-system on a bastion host.
- key-system: Use an explicit call to glob instead of the angle bracket
   syntax, since the latter confuses Test::MinimumVersion.
- rotate-history: Delete. 
-  wallet-rekey-periodic and key-system are added
- horsewatcher updates and retire-system from debian.

* Wed Nov 7 2012 Darren Patterson <darrenp1@stanford.edu> 94-1.EL
- pull in changes from debian v94 for puppet-backend, rtripwire.
- remctl-acl-builder fix to check for root ACL.
- Fix puppet-backend PID discovery in case oneshot is running.

* Wed Oct 24 2012 Darren Patterson <darrenp1@stanford.edu> 91-2.EL
- fix for status on rhel

* Thu Sep 6 2012 Darren Patterson <darrenp1@stanford.edu> 91-1.EL
- update to 91, add multipath-local-root-wwn, get-dell-warranty, retire-system
- update horsewatcher-feed and rtripwire

* Fri Mar 2 2012 Darren Patterson <darrenp1@stanford.edu> 79-1.EL
- update to 79 w/ horsewatcher-feed

* Mon Jan 30 2012 Darren Patterson <darrenp1@stanford.edu> 78-1.EL
- update to 78 && fixes for RHEL6. 

* Mon Nov 7 2011 Darren Patterson <darrenp1@stanford.edu> 73-1.EL
- match debian release w/ puppet-backend, rtripwire, remctl-acl-update. 
- Add patch-system util.

* Thu Jan 20 2011 Darren Patterson <darrenp1@stanford.edu> 70-1.EL
- update puppet-backend, make-local-cert, and remctl-acl-update.
- match deb pkg version number

* Thu Jan 20 2011 Darren Patterson <darrenp1@stanford.edu> 64-2.EL
- fix for rhel6

* Wed Jan 05 2011 Darren Patterson <darrenp1@stanford.edu> 64-1.EL
- updated puppet-backend

* Mon Nov 01 2010 Tim Skirvin <tskirvin@stanford.edu> 63-1.EL
- updated for stanford-server 63
- updated tripwire scripts

* Thu Aug 26 2010 Darren Patterson <darrenp1@stanford.edu> 62-1.EL
- added generate-conf and sync release num to match deb.

* Mon May 10 2010 Darren Patterson <darrenp1@stanford.edu> 60-1.EL
- updated puppet-backend to support locktestrun and synced release num w/ deb.

* Thu Oct 29 2009 Darren Patterson <darrenp1@stanford.edu> 56-1.EL
- Updated rebuild-iptables with the fix to change SUL to INPUT chain.
- Updated puppet-backend with latest from Debian pkg with Digant's fixes.

* Thu Sep 03 2009 Tim Skirvin <tskirvin@stanford.edu> 48-8.EL
- added /etc/iptables dir (preparing for new git-repo version)

* Fri Jul 24 2009 Darren Patterson <darrenp1@stanford.edu> 48-7.EL
- added service-restart

* Fri May 8 2009 Darren Patterson <darrenp1@stanford.edu> 48-6.EL
- new version of make-local-cert

* Wed Apr 22 2009 Darren Patterson <darrenp1@stanford.edu> 48-5.EL
- re-added missing scripts/configs that got lost sometime around 2 or 3.

* Wed Apr 22 2009 Darren Patterson <darrenp1@stanford.edu> 48-4.EL
- fix remctl-help

* Mon Mar 23 2009 Darren Patterson <darrenp1@stanford.edu> 48-3.EL
- Added make-local-cert.
- rpmlint cleanup.

* Thu Nov 13 2008 Tim Skirvin <tskirvin@stanford.edu) 48-2
- Forgot tripwire config in /etc/remctl/conf.d

* Thu Nov 13 2008 Tim Skirvin <tskirvin@stanford.edu) 48-1
- Updated for stanford-server 48
- Various tripwire fixes

* Tue Jun 17 2008 Tim Skirvin <tskirvin@stanford.edu> 0.3-4
- another round of puppet-backend fixes.

* Tue May 27 2008 Digant C Kasundra <digant@stanford.edu> 0.3-3
- added new functions to puppet-backend (trace, summarize, and classes)

* Fri Apr 11 2008 Darren Patterson <darrenp1@stanford.edu> 0.3-2
- updated remctl-acl-update script.

* Tue Apr 8 2008 Darren Patterson <darrenp1@stanford.edu> 0.3-1
- added klogin/krsh replacement.
- conflict with kftgt-SU package.

* Wed Mar 26 2008 Darren Patterson <darrenp1@stanford.edu> 0.2-1
- removed up2date backened & remctl config.
- added generic package backend and remctl config.
- removed unused up2date_all munin plugin.
- removed leland_srvtab since only wallet works now (k4->k5 update).

* Wed Feb 6 2008 Darren Patterson <darrenp1@stanford.edu> 0.1-21
- updated puppet-backend

* Thu Oct 11 2007 Digant C Kasundra <digant@stanford.edu> 0.1-20
- Changed the suffix created by rebuild-iptables

* Thu Oct 4 2007 Digant C Kasundra <digant@stanford.edu> 0.1-19
- Added version command to puppet backend

* Fri Aug 17 2007 Digant C Kasundra <digant@stanford.edu> 0.1-18
- updated the puppet-backend to filter out annoying warnings from
  Ruby

* Tue Jul 31 2007 Darren Patterson <darrenp1@stanford.edu> 0.1-17
- added up2date_all munin plugin.

* Fri Apr 20 2007 Darren Patterson <darrenp1@stanford.edu> 0.1-16
- added remctl-help and remctl conf.d/ for this command.
- added /root/.history-save since it was missing.
- added leland_srvtab.
- adjusted rotate-history script.
- updated remctl-acl-update.

* Thu Mar 22 2007 Digant C Kasundra <digant@stanford.edu> 0.1-15
- run remctl-acl-update on install

* Thu Mar 8 2007 Digant C Kasundra <digant@stanford.edu> 0.1-14
- removed the unneeded puppet.acl
- added conf to allow up2date via remctl

* Wed Feb 21 2007 Digant C Kasundra <digant@stanford.edu> 0.1-12
- bug fix (make cron executable)

* Wed Feb 21 2007 Digant C Kasundra <digant@stanford.edu> 0.1-11
- puppet now uses the systems-root acl file
- added remctl-acl-update script and cron job

* Wed Feb 7 2007 Darren Patterson <darrenp1@stanford.edu> 0.1-10
- changed requires for remctl-client and remctl-server.

* Tue Jan 9 2007 Digant C Kasundra <digant@stanford.edu> 0.1-9
- Bugfixes to puppet-backend script

* Sat Jan 6 2007 Digant C Kasundra <digant@stanford.edu> 0.1-7
- Updated puppet-backend script

* Thu Jan 4 2007 Digant C Kasundra <digant@stanford.edu> 0.1-6
- Meshed all the puppet scripts into on

* Fri Oct 27 2006 Digant C Kasundra <digant@stanford.edu> 0.1-5
- Added puppet remctl scripts

* Tue Sep 19 2006 Digant C Kasundra <digant@stanford.edu> 0.1-3
- added requirements to stanford-nagios, filter-syslog and newsyslog

* Tue Sep 19 2006 Digant C Kasundra <digant@stanford.edu> 0.1-2
- Added rotate-history script

* Fri Sep 15 2006 Digant C Kasundra <digant@stanford.edu> 0.1-1
- initial version
