#!/usr/bin/env python3
# script to read debian style changelogs and write out yum package spec style changelogs
import os,re
comments=""

with open("debian/changelog", "r") as infile, open("/dev/stdout", "w") as outfile:
	for line in infile:
#		outfile.write(line.split("<_|_>")[0])
#match package name and version
#stanford-server (164) unstable; urgency=medium
		try:
			[(name,version)] = re.findall(r'^(\S+)\s+\((\d+)\)\s+',line)
#			print(name,":",version)
			comments=""
		except:
#match email and date
# -- Lonlone Lee <lonlone@stanford.edu>  Wed, 10 Mar 2021 15:21:22 -0800
			try:
				[(email,day,date,month,year,time)] = re.findall(r'^\s+--\s+(\S.*>)\s+(\S+),\s+(\d+)\s+(\S+)\s+(\d+)\s+(.*)\n',line)
				print("*", day, month, date, year, email, version + "-1.EL")
				print(comments)
				comments=""
			except:
#exclude blank lines only comment fields remaining
				comment_line = line.rstrip()
				if comment_line:
					comments += comment_line.replace(r'*','-',1) + "\n"
#		outfile.write(list[0])
		
