/*
  Attach an event to changes to the csr text box
*/

$(document).ready(function(){
    $('#csr').change(populate_subject_and_sans) ;
}) ;

function csr_event_change() {
    alert("change detected") ;
}


function parse_return_subject_san_string(subject_sans_string) {
  parts =  subject_sans_string.split(';') ;

  subject      = parts[0] ;
  pk_algorithm = parts[1].toLowerCase() ;
  sans_string  = parts[2].trim() ;

  if (subject.length == 0) {
    subject = null ;
  }

  if (sans_string.length > 0) {
    sans = sans_string.split(",") ;
    if (sans.length > 0) {
      sans_joined = sans.join(",") ;
    }
  } else {
    sans_joined = null ;
  }

  return [subject, pk_algorithm, sans_joined];

}

function populate_subject_and_sans() {
  var xmlhttp, element, parameters, csr, result ;
  var subject, sans_string ;

  csr = getCSR() ;

  // If csr is empty, skip.
  if (!csr) {
    return ;
  }

  if (window.XMLHttpRequest) {
    // code for IE7+, Firefox, Chrome, Opera, Safari
    xmlhttp = new XMLHttpRequest();
  } else {
    // code for IE6, IE5
    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
  }

  xmlhttp.onreadystatechange = function() {
    if ((xmlhttp.readyState == 4) && (xmlhttp.status==200)) {
      alternatives_element = document.getElementById("alternatives");
      if (!alternatives_element) {
        alert('could not find element alternatives!');
      }

      result = xmlhttp.responseText;

      [subject, public_key_algorithm, sans_joined] = parse_return_subject_san_string(result);

      // Populate subject
      subject_element = document.getElementById("server_name");
      if (!subject_element) {
        alert('could not find element server_name!');
      }
      if (subject != null) {
        subject_element.value = subject
      } else {
	alert("Warning: could not find Subject in CSR; problem with CSR string?") ;
      }

      // Populate key-type
      // Is this a public-key algorithm we recgonize?
      recognized_public_key_algorithms = {
        'id-ecpublickey': 'ECC',
        'rsaencryption':  'RSA',
        'dsaencryption':  'DSA',
      } ;

      if (public_key_algorithm in recognized_public_key_algorithms) {
          pk_alg_friendly = recognized_public_key_algorithms[public_key_algorithm] ;
      } else {
          pk_alg_friendly = 'unrecognized: ' + public_key_algorithm ;
      }

      public_key_algorithm_element = document.getElementById("public_key_algorithm");
      if (!public_key_algorithm_element) {
        alert('could not find element public_key_algorithm!');
      }
      if (public_key_algorithm != null) {
        public_key_algorithm_element.value = pk_alg_friendly ;
      } else {
	alert("Warning: could not find public key algorithm in CSR; problem with CSR string?") ;
      }

      // Populate sans
      alternatives_element = document.getElementById("alternatives") ;
      if (!alternatives_element) {
        alert('could not find element alternatives!');
      }
      if (sans_joined != null) {
        alternatives_element.value = sans_joined ;
      }
    }
  }

  xmlhttp.open("POST", "/csr-parse", true) ;

  xmlhttp.setRequestHeader("Content-type",
                           "application/x-www-form-urlencoded") ;

  parameters = "csr=" + encodeURIComponent(csr) ;
  xmlhttp.send(parameters) ;
}

function getCSR()
{
  var element ;

  element = document.getElementById('csr') ;

  if (!element) {
    alert('Could not extract CSR string; please type in by hand') ;
  } else {
    return element.value.replace(/(^\s*)|(\s*$)/g,"");
  }
}

function js_validate()
{
    var element ;

    // Get the value of the contact e-mail form input
    element = document.getElementById("contact_address") ;

    if (!element)
    {
        alert('Could not find contact_address input element?!?') ;
        return false ;
    }
    else
    {
        contact_address = element.value ;

        /*
           If this is not a mailman address pop-up a warning.

           A mailman address looks like "<something>@(mailman|lists).stanford.edu"
        */
        var mailmanRe = /\w+@(mailman|lists)\.stanford\.edu$/;
        if (!contact_address) {
            msg = 'Missing contact group/mailman address.'
            window.alert(msg) ;
            return false ;
        } else if (!(mailmanRe.test(contact_address)))
        {
            msg =   'Contact group/mailman address "' + contact_address + '" does not appear to be a Mailman address. '
                + 'If you REALLY want to use this address, press the "OK" button; to '
                + 'change the contact group/mailman address to a Mailman address click on the "Cancel button.' ;
            return window.confirm(msg) ;
        } else {
            return true ;
        }
    }
}
