% netdb-access-info-for-ssl(1)
% Adam Lewenberg
% February 2020

# NAME

netdb-access-info-for-ssl - Get NetDB access information for nodes and domains

# SYNOPSIS

**netdb-access-info-for-ssl** [**-v**] [**-t**] [**-n**|**-d**] _user,hostname[:user,hostname,...]_

**netdb-access-info-for-ssl** **-h**

# DESCRIPTION

The netdb-access-info-for-ssl is a JRuby script written to be used with
the Stanford Certificate provisioning web application. It takes (_user_,
_hostname_) pairs and, by querying NetDB, determines if _user_ has
"control" of the NetDB node or domain with name _hostname_.

This script uses the NetDBI RMI to query NetDB. As such it needs to be run
in the context of a Kerberos principal that has access to read NetDB.

## Control of a node or domain

We say that a user has control of a NetDB **node** if that user is listed
in the NetDB "User" field for that node, or is an admin of that node.

We say that a user has control of a NetDB **domain** if that user is listed
in the NetDB ""Use as name" field for that domain, or is an admin of that domain.

Note that a user can be an admin of a node or domain if that user is either
listed explicitly in the Admin section or is a member of a group listed in
the Admin section.

Normally access information about nodes and domains with name _hostname_
is returned, but if you want information about nodes only you can pass in
the **-n** option; similarly, if you want information about domains only
use the **-d** option.

## Input

The input to this command is one or more user-hostname pairs. The username
should be a Stanford SUNetID and the hostname should be
fully-qualified. Separate the user and the hostname with a comma (","). Here is an example:

    netdb-access-info-for-ssl 'adamhl,ldap.stanford.edu'

To pass in more than one user-hostname pair use the colon (":") character as separator. Example:

    netdb-access-info-for-ssl 'adamhl,ldap.stanford.edu:adamhl,debian.stanford.edu'

## Output

The output will be a set of triples. The first two components just repeat
_user_ and _hostname_ while the third component is a number representing
the access that _user_ has to _hostname_ in NetDB. The number is the sum
of the following:

     2  : no USER   user in NetDB [*]
     4  : no NODE   hostname in NetDB
     8  : no DOMAIN hostname in NetDB
    16  : user has control of NODE hostname
    32  : user has control of DOMAIN hostname

    [*] No longer relevant as we no longer care if the user has a User
        object in NetDB.

If the result is 0 then _user_ has no access to _hostname_ in NetDb. For example, on
the input "adamhl,ldap.stanford.edu" the output will be

     adamhl,ldap.stanford.edu,48

meaning that user adamhl has control over both the node and domain with
name "ldap.stanford.edu".

# OPTIONS

**-n|\--get-node-access-info**

: Get ONLY **node** access information for _hostname_. Only one of **-n**
or **-d** can be provided.

**-d|\--get-domain-access-info**

: Get ONLY **domain** access information for _hostname_. Only one of
**-n** or **-d** can be provided.

**-t|\--use-netdb-dev**

: Normally, all queries are made against the
production NetDB. Using the **-t** option tells the script to use the
development version of NetDB (netdb-dev.stanford.edu).

**-v|\--verbose**

: Show run-time debugging information.

**-h|\--help**

: Show a usage screen and exit.

# EXIT STATUS

Exits with 0 on success, non-zero on error.

# EXAMPLE

To show user adamhl's domain and node access for "ldap.stanford.edu":

    netdb-access-info-for-ssl 'adamhl,ldap.stanford.edu'

To show user adamhl's node access, but not domain access, for "ldap.stanford.edu":

    netdb-access-info-for-ssl -n 'adamhl,ldap.stanford.edu'

To show user adamhl's domain access, but not node access, for "ldap.stanford.edu":

    netdb-access-info-for-ssl -d 'adamhl,ldap.stanford.edu'

To show access for multiple user-hostname pairs:

    netdb-access-info-for-ssl -d 'adamhl,ldap.stanford.edu:johndoe,debian.stanford.edu'

# SEE ALSO

jruby(1)
