@test_input_elements
Feature: A web form that validates user's input

  As an SSL Certificate requesting client
  I need all the input elements to be validated in the web form
  So that I can be sure my information is sent correctly

  @web_form
  @testlink-CERT-13
  Scenario: The user uses the "fill-in the servername" feature
    Given that we are on the main page
    When  I type in a fake entry
      And I press the Fill in Server Name button
    Then I will see the server name appear in the correct input field

  @testlink-CERT-1
  Scenario: The web form appears with all the input elements visible
    Given that we are on the main page
    Then I will see the correct title
      And I will see a "Requirements" section
      And I will see a "Requests" section
      And I will see three "Certificate type" radio buttons
      And I will see a text input with name "server_name"
      And I will see a text input with name "contact_address"

  # testlink-CERT-4
  Scenario: The user types in an entry without a _server name_
    Given that we are on the main page
    When  I type in a fake entry
      And I erase the server name
      And I press Submit
    Then I will see the error: you must indicate the name of the server

  # testlink-CERT-5
  Scenario: The user types in an entry without a _contact email_
    Given that we are on the main page
    When  I type in a fake entry
      And I erase the contact address
      And I press Submit
    Then I will see the error: include a contact email address

  # testlink-CERT-6
  Scenario: The user types in an entry without a _csr_
    Given that we are on the main page
    When  I type in a fake entry
      And I erase the csr
      And I press Submit
    Then I will see the error: include a valid Certificate Signing Request

  # testlink-CERT-7
  Scenario: The user types in an entry without a server name or contact address
    Given that we are on the main page
    When  I type in a fake entry
      And I erase the contact address
      And I erase the server name
      And I press Submit
    Then I will first see the error: you must indicate the name of the server
     And I will second see the error: include a contact email address

  # testlink-CERT-8
  Scenario: The user types in an entry with a malformed CSR
    Given that we are on the main page
    When  I type in a fake entry
      And I erase the CSR
      And I enter a bad CSR
      And I press Submit
    Then I will see the error: Cannot find the CN within the contents of your CSR
      And I will NOT see any openssl error text

  # testlink-CERT-9
  Scenario: The user chooses multi-hostnames but provides no SANs
    Given that we are on the main page

  # testlink-CERT-10
  Scenario: The user chooses provides SANs but does not select multi-hostname
    Given that we are on the main page

  # testlink-CERT-11
  Scenario: The user has malformed SANs
    Given that we are on the main page

  # testlink-CERT-12
  Scenario: The user types in an entry with more than one e-mail contact
    Given that we are on the main page
    When  I type in a fake entry
      And I type in two addresses for the contact e-mail
      And I press Submit
    Then I will see the error: please include a single valid contact email

