require 'remctl'
require 'rubygems'
require 'selenium-webdriver'
require 'features/lib/hooks'
require 'number_to_words'
require 'capybara'
require 'capybara/cucumber'
require 'capybara/dsl'
require 'test/unit'
require "selenium/webdriver/webauth"
require "test/unit"

# driver = h.browserDriver("firefox")
headless = parse_headless()

driver = Selenium::WebDriver.for :firefox
driver.weblogin_cookie_file = '/afs/ir.stanford.edu/users/a/d/adamhl/private/private/webauth_cookie'
driver.weblogin_domain = 'weblogin.stanford.edu'
url = nil

# Pre-test setup. Outside scope of scenario wording
h = Hooks.new(nil, nil, driver)
h.headless = headless
driver.two_factor_totp_secret =
  h.read_totp_shared_secret('/afs/ir.stanford.edu/users/a/d/adamhl/private/private/xuw_totp_ss.txt')

# Use:
#   cucumber environment=SBX file.feature
# or
#   cucumber environment=DEV file.feature
#
Given /^that we are on the main page$/ do
  if (ENV['environment'].nil?)
    h.environment = 'SBX'
  else
    h.environment = ENV['environment']
  end

  if (h.environment =~ /sbx/i)
    @url = 'https://certreq-sbx.stanford.edu/cgi-bin/cert-request'
  elsif (h.environment =~ /dev/i)
    @url = 'https://certreq-dev.stanford.edu/cgi-bin/cert-request'
  else
    raise "unknown environment '#{h.environment}'"
  end

  # puts "environment: #{h.environment}"

  if (!h.onMainPage())
    h.getSite(@url)

    if (!h.onMainPage())
      h.driver.web_auth(@url) { h.findTextOnPage('SSL Certificate Request Form', 0, false) }
    end
  end

  if (!h.onMainPage())
    raise "failed to load main page"
  end
end


When /^I load the cert-request page$/ do
  h.getSite(@url)
end

Then /^I will see a WebLogin screen$/ do
  h.testOnWebLoginPage()
  h.driver.web_auth(@url)  { h.findTextOnPage('SSL Certificate Request Form', 0, false) }
end

Then /^I will see the correct title$/ do
  title = h.driver.title()
  match = 'SSL Certificate Request Form'
  r = Regexp.new(match)
  if (r.match(title).nil?)
    raise("We are on the wrong page -- expected match to #{match}, but found #{title} instead")
  end
end


Then /^I will see the confirmation page$/ do
  h.findTextOnPage('SSL Certificate Request Confirmation', 10)
end



Then /^I will see a .Requirements. section$/ do
  h4tag = h.driver.find_element(:id, 'requirements_header')
  if (h4tag.text !~ /Requirements/)
    raise("could not find requirements section")
  end
end

Then /^I will see a .Requests. section$/ do
  h4tag = h.driver.find_element(:id, 'request_header')
  if (h4tag.text !~ /Request form/)
    raise("could not find Request Form section")
  end
end

Then /^I will see three .Certificate type. radio buttons$/ do
  types = ['single', 'multi', 'wildcard']
  types.each do |type|
    element = h.driver.find_element(:css, %Q&input[type="radio"][value="#{type}"]&)
    if (element.tag_name !~ /INPUT/i)
      raise("did not find INPUT element with name '#{type}'")
    end
    if (element.attribute('name') !~ /certificate_type/i)
      raise("element does not have name 'certificate_type'")
    end
  end
end

Then /^I will see a text input with name "(.*)"$/ do |name|
  element = h.driver.find_element(:css, %Q&input[type="text"][name="#{name}"]&)
  if (element.tag_name !~ /INPUT/i)
    raise("did not find INPUT element with name '#{name}'")
  end
end

Given /that I am at the cert-request page/ do
  title = h.driver.title()
  match = 'SSL Certificate Request Form'
  r = Regexp.new(match)
  if (r.match(title).nil?)
    raise("We are on the wrong page -- expected match to #{match}, but found #{title} instead")
  end
end

When /I type in a fake entry/ do
  h.select_radio_element('single')
  h.enter_text('testabc123.stanford.edu', 'server_name')
  h.enter_text('adamhl@macrotex.net', 'contact_address')
  h.enter_textarea(h.csr_for_testabc123(), 'csr')
  h.select_duration(2)
  h.select_server_type('Tomcat')
end

When /I type in a fake wildcard entry/ do
  h.select_radio_element('wildcard')
  h.enter_text('*.itservices.stanford.edu', 'server_name')
  h.enter_text('adamhl@macrotex.net', 'contact_address')
  h.enter_textarea(h.csr_for_wildcard(), 'csr')
  h.select_duration(2)
  h.select_server_type('Apache')
end

When /I enter a bad CSR/i do
  h.enter_textarea(h.bad_csr_for_testabc123(), 'csr')
end

When /I type in two addresses for the contact e-mail/i do
  h.enter_text('adamhl@macrotex.net,ahl456@gmail.com', 'contact_address')
end

When /I erase the (.*)/ do |element_to_erase|
  if (element_to_erase =~ /server.*name/)
    element = h.find_text_input_element('server_name')
  elsif (element_to_erase =~ /contact/)
    element = h.find_text_input_element('contact_address')
  elsif (element_to_erase =~ /csr/i)
    element = h.find_textarea('csr')
  else
    raise "unrecognized element '#{element_to_erase}'"
  end

  element.clear()
end

When /I press Submit/ do
  h.press_submit()
end

When /I press the Fill in Server Name button/ do
  element_server_name = h.find_text_input_element('server_name')
  element_server_name.clear()
  element = h.driver.find_element(:id, 'get_csr_subject')
  element.click()
  element_server_name = h.find_text_input_element('server_name')
end

Then /I will (\S*\s*)see the error: (.*)$/ do |position, error_message|
  h.take_picture()
  position.strip!
  if (position.nil? || position.empty? || (position =~ /first/))
    element = h.driver.find_element(:css, %Q&div[id="submission_warning"] li:nth-child(1)&)
  elsif (position =~ /second/)
    element = h.driver.find_element(:css, %Q&div[id="submission_warning"] li:nth-child(2)&)
  else
    raise "could not interpret cucumber Then"
  end

  if (element.text() !~ /#{error_message}/)
    raise "did not see error message #{error_message}"
  end
end

Then /I will NOT see any openssl error text/ do
  if (!h.findTextOnPage('openssl'))
    raise "missing openssl command help text"
  end
end


When /I enter an emailtest address/ do
  element = h.find_text_input_element('contact_address')
  element.clear()
  testaddress = h.emailtest_address()
  h.enter_text(testaddress, 'contact_address')
end

Then /the contact address will receive a confirmation e-mail/ do
  identifier = h.emailtest_identifier()

  expected_key_to_value = Hash.new()
  expected_key_to_value['created_at_epoch'] = Time.now.to_i

  h.waitfor_email_arrival(identifier, expected_key_to_value, 20)
end

Then /the approval list gets a reminder e-mail about a (\S+) cert/ do |cert_type|
  identifier = h.emailtest_identifier()

  expected_key_to_value = Hash.new()
  expected_key_to_value['created_at_epoch'] = Time.now.to_i

  if (cert_type =~ /normal/)
    subject = 'approval needed.*testabc123'
  elsif (cert_type =~ /wildcard/)
    subject = 'Special handling.*needed.*itservices'
  else
    raise "unknown cert type #{cert_type}"
  end

  expected_key_to_value['subject'] = subject

  h.waitfor_email_arrival(identifier, expected_key_to_value, 20)
end

