# require '~adamhl/development/git/qa/common/lib/hookfiles'

class Hooksbase < Test::Unit::TestCase

end

class Hooks < Hooksbase

  require 'headless'

  attr_accessor :browser,
                :siteurl,
                :driver,
                :headless,
                :picture_count,
                :picture_base_dir,
                :environment

  def initialize(browser, siteurl, driver)
    @browser        = browser
    @siteurl        = siteurl
    @driver         = driver
    @headless       = nil
    @picture_count  = 0
    @picture_base_dir = File.join('/tmp', 'screenshots')
    @environment    = nil
  end

  # Load the requested website
  def getSite(url)
    self.driver.get("#{url}")
  end

  def onMainPage()
    title = self.driver.title
    return (title =~ /SSL Certificate Request Form/)
  end

  def testOnWebLoginPage()
    title = self.driver.title
    if (title =~ /Stanford WebLogin/i)
      true
    else
      raise("We are not on the WebLogin page expected title 'Stanford WebLogin', but found #{title} instead")
    end
  end

  def select_radio_element(type)
    element = self.driver.find_element(:css, %Q&input[type="radio"][value="#{type}"]&)
    element.click()
  end

  def enter_text(name, element_name)
    element = self.find_text_input_element(element_name)
    element.send_keys(name)
  end

  def find_text_input_element(element_name)
    return self.driver.find_element(:css, %Q&input[type="text"][name="#{element_name}"]&)
  end

  def enter_textarea(name, element_name)
    element = self.find_textarea(element_name)
    element.send_keys(name)
  end

  def find_textarea(element_name)
    return self.driver.find_element(:css, %Q&textarea[name="#{element_name}"]&)
  end



  def select_duration(duration)
    select_element = self.driver.find_element(:css, %Q&select[name="duration"]&)
    options = select_element.find_elements(:tag_name, 'option')
    option = options.detect{|option| (option['value'] =~ /#{duration} year/) }
    if (!option)
      raise "could not find option matching duration '#{duration}'"
    else
      option.click()
    end
  end

  def select_server_type(server_type)
    select_element = self.driver.find_element(:css, %Q&select[name="server_type"]&)
    options = select_element.find_elements(:tag_name, 'option')
    option = options.detect{|option| (option['value'] =~ /#{server_type}/) }
    if (!option)
      raise "could not find option matching server type '#{server_type}'"
    else
      option.click()
    end
  end

  def csr_for_testabc123()
  return  <<-eos
-----BEGIN CERTIFICATE REQUEST-----
MIIC0TCCAbkCAQAwgYsxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlh
MREwDwYDVQQHEwhTdGFuZm9yZDEcMBoGA1UEChMTU3RhbmZvcmQgVW5pdmVyc2l0
eTEUMBIGA1UECxMLSVQgU2VydmljZXMxIDAeBgNVBAMTF3Rlc3RhYmMxMjMuc3Rh
bmZvcmQuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArbbIY9Qv
TcuGS8Iuk0CctAQcYZaxXRPWGESxjaddsR4lkVRMQFhACyChAOKzqeRZOvb6D24D
tOtJozL7NKNB8j0qypZB3A/veR5S2RytKblczXdAOoztV1rysSqrZsEfqUv5QTBU
hH/d8NlvyF6iM3GLHfZ24KFKsPVqq6qJZEn+rDPgDuP60j8x9xJWlq/gl6+ewJ8X
qEYq6ANatsTwpKR5vrmPGDUMKq+Nz5luRYXFYjsHxq9oIsto47XjzxgXy04OCXFG
fZax5e23GhSdN3B/vnkXJYVRSmAS9g5W6dPAYmV0qVqx7QQmumyM7TZRyIH+4zs2
0QhKLakE/QtoJwIDAQABoAAwDQYJKoZIhvcNAQEFBQADggEBAALueATymWcwxFIt
lnT+ZwCmnEpe52/h9vf8GRGtvZuzJbVuW2itakGfck9uPSa9HCgXEGeMe3LJagFK
PwxBgCmssjEZTtTktwApN4Me9G1n9Rx4242zzBT0AoaR4kBFg67J6UUd7cXOa2B4
ygTyWbBae3RDFNTRY1aMK97yzWAqzWnV7Ly9PJmgZKCsAYUCkK3MBE+0VDid2TiE
sJ5xr7nO9lD1piJ3iW9AiHWUKwenJJIQcV7LKBVmU8neHevlIS+zy5u8gJxdNUHW
Bhnfn4ygJoE3/D+OLh5F5LxChDuOiEIHvCQYDzks9B6ZlzXLQs6wiopBtVNWVucH
6pgmr0s=
-----END CERTIFICATE REQUEST-----
  eos
  end

  def bad_csr_for_testabc123()
  return  <<-eos
-----BEGIN CERTIFICATE REQUEST-----
MIIC0TCCAbkCAQAwgYsxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlh
MREwDwYDVQQHEwhTdGFuZm9yZDEcMBoGA1UEChMTU3RhbmZvcmQgVW5pdmVyc2l0
eTEUMBIGA1UECxMLSVQgU2VydmljZXMxIDAeBgNVBAMTF3Rlc3RhYmMxMjMuc3Rh
bmZvcmQuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArbbIY9Qv
tOtJozL7NKNB8j0qypZB3A/veR5S2RytKblczXdAOoztV1rysSqrZsEfqUv5QTBU
hH/d8NlvyF6iM3GLHfZ24KFKsPVqq6qJZEn+rDPgDuP60j8x9xJWlq/gl6+ewJ8X
qEYq6ANatsTwpKR5vrmPGDUMKq+Nz5luRYXFYjsHxq9oIsto47XjzxgXy04OCXFG
fZax5e23GhSdN3B/vnkXJYVRSmAS9g5W6dPAYmV0qVqx7QQmumyM7TZRyIH+4zs2
0QhKLakE/QtoJwIDAQABoAAwDQYJKoZIhvcNAQEFBQADggEBAALueATymWcwxFIt
lnT+ZwCmnEpe52/h9vf8GRGtvZuzJbVuW2itakGfck9uPSa9HCgXEGeMe3LJagFK
PwxBgCmssjEZTtTktwApN4Me9G1n9Rx4242zzBT0AoaR4kBFg67J6UUd7cXOa2B4
ygTyWbBae3RDFNTRY1aMK97yzWAqzWnV7Ly9PJmgZKCsAYUCkK3MBE+0VDid2TiE
sJ5xr7nO9lD1piJ3iW9AiHWUKwenJJIQcV7LKBVmU8neHevlIS+zy5u8gJxdNUHW
Bhnfn4ygJoE3/D+OLh5F5LxChDuOiEIHvCQYDzks9B6ZlzXLQs6wiopBtVNWVucH
6pgmr0s=
-----END CERTIFICATE REQUEST-----
  eos
  end


  def csr_for_wildcard()
  return  <<-eos
-----BEGIN CERTIFICATE REQUEST-----
MIIC0zCCAbsCAQAwgY0xCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlh
MREwDwYDVQQHEwhTdGFuZm9yZDEcMBoGA1UEChMTU3RhbmZvcmQgVW5pdmVyc2l0
eTEUMBIGA1UECxMLSVQgU2VydmljZXMxIjAgBgNVBAMUGSouaXRzZXJ2aWNlcy5z
dGFuZm9yZC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4N9dS
Q6WgLKhApxOryWUW783974eplaWDsejkCo4mIObNSVrUIA5+g+oKT8w6TUFaVy0l
062syo4CyGYI6Zc52qtS5qkmZxeQd/nKjnmuZppi8BxRxo7bPzWGRO3tvkJdrkwt
D2SxbDMk9IzLHHk/fTuEElbiyQlTSuwpOKUC5o8D0acukVUEOmQCoT8F9mPxDJl+
x6MHlAEBdbS4cz/riuqc+50MoAK7VlflW9UVAqMFJYEzpMPQsPzulQChaAiGOFLT
MzS+IFZhkm7lZZB/lIEC3L/vVEz9agW0ZdKtC6y1do603su2oT9pIfpMlHrslCPv
APEoqgTSigeJU6zzAgMBAAGgADANBgkqhkiG9w0BAQUFAAOCAQEARKYnbLC1R8Nd
BPlttu4eXLh6eNhFE18iDhrPXkjV2qmiWiwb8uOP5JbKusyrJfHi4XxBb3ETVx31
+24joReshXQjaK22KMp+H06a5dC5lM1b8G1H5ptPKo2FkEda4864RCkfaQakKmu5
q6HNIlI2TYFfajjCZGS1shY7Wl5DAZiVIaWHSA8ZZX7kmCiPBmtwgnDxDIyQqLtl
QnZARJZ5ewhRYhTDlVJmwuCBZ6GE8x9ArZ2lyoyCAmt3r9bndJG3O0JjD/lqBX9E
IgOlzpfU0HRZNg5LecX3DzX62myMr8vx2S78YGkZpkOJ3S5uLjlx45Wgr5NXziwj
qqLNROdTPQ==
-----END CERTIFICATE REQUEST-----
  eos
  end


  def submit_element()
    return self.driver.find_element(:id, 'submit_form')
  end

  def press_submit()
    self.submit_element().click()
  end

  # Find the passed in text _anywhere_ on the page. The last argument
  # is for timeout (omit and there will be no timeout).
  def findTextOnPage(text, timeout = 0, raise_exception = true)
    begin
      if (timeout > 0)
        wait = Selenium::WebDriver::Wait.new(:timeout => timeout)
        element = wait.until { self.driver.find_element(:xpath, "//*[contains(.,'#{text}')]") }
      else
        element = self.driver.find_element(:xpath, "//*[contains(.,'#{text}')]")
      end
    rescue Exception
      if (element.nil? and raise_exception)
        raise "could not find text '#{text}' on this page"
      end
    end
  end

  def getEmailTestJson(identifier, number_to_get = 1)
    require 'open-uri'
    url = 'http://emailtest.stanford.edu/identifier/' + identifier +
      "?quantity=#{number_to_get}"
    file = open(url)
    contents = file.read
    print "url is #{url}"

    require 'json'
    return JSON.parse(contents)
  end

  def emailtest_address()
    return 'emailtest' + self.emailtest_identifier() +
           '@devnull.stanford.edu'
  end

  def emailtest_identifier()
    if (self.environment =~ /sbx/i)
      return '64D51C6F882EE5240B62C440945BC47E'
    elsif (self.environment =~ /dev/i)
      return 'D3061B6375CD92404DEBECD8108C10F9'
    else
      raise "unknown environment '#{self.environment}'"
    end
  end


  def expected_same_as_actual?(expected, actual)
    expected.each_pair do |key, value|
      if (key == 'created_at_epoch')
        expected_created_at_epoch_i = expected[key].to_i()
        actual_created_at_epoch_i   = actual[key].to_i()
        if ((expected_created_at_epoch_i - actual_created_at_epoch_i).abs() > 15)
          puts "diff is #{(expected_created_at_epoch_i - actual_created_at_epoch_i).abs()}"
          return false
        end
     else
        # For all other fields, do a regex search
        rx = Regexp::new(expected[key])
        if (rx.match(actual[key]).nil?)
          return false
        end
      end
    end
    return true ;
  end

  def email_arrived(identifier, expected, number_to_get = 4)
    # remember that getEmailTestJson returns an array of hashes
    actuals = self.getEmailTestJson(identifier, number_to_get)

    actuals.each do |actual|
      if (expected_same_as_actual?(expected, actual))
        return true
      end
    end

    # If we get here, either we had no results or had results, but no matches
    return false ;
  end

  def waitfor_email_arrival(identifier, expected_key_to_value, timeout = 10)
    wait = Selenium::WebDriver::Wait.new(:timeout => timeout)
    element = wait.until { self.email_arrived(identifier, expected_key_to_value) }
    puts "element is #{element}"
  end

  def self.pad(n, width = 2)
    return Kernel.sprintf("%0#{width}d", n)
  end

  # Take a picture and deposit in /tmp/. Uses the counter @picture_count
  def take_picture(imagefile = nil)
    if (self.headless.nil?)
      puts "cannot take a picture (no headless)"
    else
      if (imagefile.nil?)
        if (!File.exists?(@picture_base_dir))
          Dir.mkdir(@picture_base_dir)
        end

        @picture_count = @picture_count + 1
        count_padded = Hooks.pad(@picture_count + 1, 3)

        filename  = "screenshot_#{count_padded}.jpg"
        imagefile = File.join(self.picture_base_dir, filename)
      end
      self.headless.take_screenshot(imagefile)
      puts "took picture"
    end
  end

  # Read the TOTP code
  def read_totp_shared_secret(filename)
    return IO.read(filename)
  end

end
