# NAME

remctl-acl-update-flex - Update remctl ACLs on local disk

# SYNOPSIS

**remctl-acl-update-flex** \[options\] _acl_ _acl_ ...

**remctl-acl-update-flex** \[options\] --all

**remctl-acl-update-flex** \[-h|--help\]

**remctl-acl-update-flex** \[-m|--manual\]

# DESCRIPTION

For many years Stanford has made available a collection of remctl ACL
files corresponding to workgroups within Stanford. These files contain
lists of Kerberos principals of three types: regular user names, root user
names, and non-user service principal names. The advantage of this is that
rather than requiring each system and service admin to maintain their own
ACL files corresponding to a list of users in a workgroup, we manage this
centrally leveraging Stanford's preferred grouping service Stanford
Workgroups.

The collection of these remctl ACL files is maintained centrally and is
accessible via AFS (for on-campus servers and services) and via HTTPS (for
all servers and services, either on- or off-premise). The
**remctl-acl-update-flex** script's purpose it so copy some (or all) of
these files to a local directory.

The default action is to sync the list of ACL files specified as a
space-delimited list of arguments to this shell script. This is done by
checking to see if the source version is newer than the version on local
disk. If so, copy the version from source to the directory
`/etc/remctl/acl`, preserving timestamps. The destination directory can
be changed.

The source is either AFS (the default) or the HTTPS remctl ACL file
service (used when **--source** is set to "https").

This script only adds/updates files; no remctl files are ever _removed_.

If the **--all** option is given then all the ACL files are copied.

If any ACLs cannot be found (e.g., they were provided with _acl_ ...
but misspelled) then the script will skip those that are missing and write
a warning to standard output. If you want the script to abort before copying
if any ACL files are missing use the **--abort-when-missing** option.

# ROOT ACL FILES

ACL files created by the upstream ACL builder service contain a list of
service and user principals. For every regular user principal in the file
there will also be a corresponding root principal (provided that the user
_has_ a root principal). For example, the **iedo** ACL file contains these
principals

    adamhl@stanford.edu
    adamhl/root@stanford.edu
    aguzhavi@stanford.edu
    aguzhavi/root@stanford.edu
    alanxge@stanford.edu
    bnbarnes@stanford.edu
    bnbarnes/root@stanford.edu
    lonlone@stanford.edu
    lonlone/root@stanford.edu
    pjudd@stanford.edu
    spinto@stanford.edu
    spinto/root@stanford.edu

Depending on how this script is called an extra ACL file based on the
regular ACL file, called the "root" ACL file, will be created. For the above
example, the root ACL file will be called **iedo-root** and will contain
_only_ the root principals:

    adamhl/root@stanford.edu
    aguzhavi/root@stanford.edu
    bnbarnes/root@stanford.edu
    lonlone/root@stanford.edu
    spinto/root@stanford.edu

To get root ACL files for the supplied ACL files provide the
**--root-acls** option. If you want some of your ACL files to get root ACL
file versions and some to _not_ get root ACL files run
**remctl-acl-update-flex** twice, once with the **--root-acls** option, and
once without. See the EXAMPLES section for an example of this.

# OPTIONS

- **--root-acls**

    If this option is provided then both the non-root and root version of the
    ACL file is written to **dest-dir**. For example, the result of
    `remctl-acl-update-flex --root-acls tcg-staff` will be that both the
    `tcg-staff` and `tcg-staff-root` ACL files will be written to
    **dest-dir**.

- **--source**=afs|https

    Use the **--source** option to specify which source you want to use for the
    ACL file downloads: AFS or the HTTPS service. Both sources have the same
    files. The default is `afs`. Supplying any other value than "afs" or
    "https" will result in an error.

- **--dest-dir**=&lt;path>

    Normally this script will write the remctl ACL files to the directory
    **/etc/remctl/acl**. To override this use the **--dest-dir** option. For
    example, to write the remctl ACL files to `/tmp/acl` use
    "**--dest-dir**=`/tmp/acl`".  Note that if the destination directory does
    not already exist the script will exit with an error.

- **--dest-ext**=&lt;ext>

    When this script creates the remctl ACL files the files have no extension.
    For example, the `its-idg` ACL file has the name "its-idg". However,
    there may be times when you want the ACL files to have a common extension.
    To do this supply the **--dest-ext** option. For example, to have all
    generated ACL files have the extension ".acl" use the option
    `--dest-ext=acl`.

- **--all**

    Copy _all_ remctl ACL files. Do not use this option and also specify ACL
    files on the command line; doing so will result in an error.

- **--abort-when-missing**

    Normally this script skips any missing ACL files. If you supply
    **--abort-when-missing** then the script first checks that all the ACL
    files exists before copying; if any are missing it aborts without copying
    any files.

- **--dry-run|-n**

    Run in "dry-run" mode. This mode downloads the file to a temporary
    directory (just like normal mode) but does **not** write them to the
    destination directory. Use with the **--verbose** option when debugging.

- **--platform**=dev|prod

    (Only relevant when the source is "https".)
    Normally this program will download the remctl ACL files from the
    production remctl ACL file storage bucket. Howevever, if you want to
    download them from the _non-production_ bucket, use this option like so:
    **--platform=dev**. This option only recognizes two values: "prod" or "dev".
    See also EXAMPLES below.

- **--baseurl**=&lt;url>

    (Only relevant when the source is "https".)
    The script normally infers the remctl ACL file service URL from the
    **--platform** option, but you can override this and specify the URL
    yourself by using the **--baseurl** option.

- **--verbose|-v**

    Run in verbose mode.

- **--help|-h**

    Show a help summary and exit.

- **--manual|-m**

    Show the man page and exit. Will only work if pod2man is installed.

# EXAMPLES

To update the ACL files "coreinfra", "its-idg", and "as-cia":

    remctl-acl-update-flex coreinfra its-idg as-cia

To update the ACL files "coreinfra", "its-idg", and "as-cia" using HTTPS
as the source:

    remctl-acl-update-flex coreinfra its-idg as-cia --source=https

To update the ACL files "coreinfra", "its-idg", and "as-cia" and to generate
the corresponding root ACL files as well:

    remctl-acl-update-flex coreinfra its-idg as-cia --root-acls

The above will update/generate the following six ACL files: "coreinfra", "its-idg", "as-cia",
"coreinfra-root", "its-idg-root", and "as-cia-root".

If you want to update the ACL files "coreinfra", "its-idg", and "as-cia"
but only generate the corresponding root ACL files for "coreinfra" and
"its-idg" and not for "as-cia" run the script twice:

    remctl-acl-update-flex coreinfra its-idg --root-acls
    remctl-acl-update-flex as-cia

To update from https using the non-production storage bucket:

    remctl-acl-update-flex coreinfra its-idg as-cia --root-acls --source=https --platform=dev

To update ALL the remctl files:

    remctl-acl-update-flex -all

# FILES

- `/afs/ir.stanford.edu/pubsw/Local/config/share/etc/acl`

    The directory in pubsw that is checked for newer copies of the ACLs. If
    this directory doesn't exist, the script exits quietly without changing
    anything. The ACLs in this directory are expected to end in `.acl` but
    are copied over without that extension. Note that this directory is
    \*not\* used when the **--source** option is set to "https".

- `/etc/remctl/acl`

    The local directory where the ACL files are stored (unless overridden by
    the **--dest-dir** option).

# AUTHOR

Russ Allbery <rra@stanford.edu>

Updated by Adam H. Lewenberg <adamhl@stanford.edu>
