# NAME

remctl-acl-update-flex - Update remctl ACLs on local disk

# SYNOPSIS

**remctl-acl-update-flex** \[options\] \[_acl_ ...\]

**remctl-acl-update-flex** \[-h|--help\]

**remctl-acl-update-flex** \[-m|--manual\]

# DESCRIPTION

For many years Stanford has made available a collection of remctl ACL
files corresponding to workgroups within Stanford. These files contain
lists of Kerberos principals of three types: regular user names, root user
names, and non-user service principal names. The advantage of this is that
rather than requiring each system and service admin to maintain their own
ACL files corresponding to a list of users in a workgroup, we manage this
centrally leveraging Stanford's preferred grouping service Stanford
Workgroups.

The collection of these remctl ACL files is maintained centrally and is
accessible via AFS (for on-campus servers and services) and via HTTPS (for
all servers and services, either on- or off-premise). The
**remctl-acl-update-flex** script's purpose it so copy some (or all) of
these files to a local directory.

The default action is, for the list of ACLs specified at the beginning of
this shell script, check to see if the source version is newer than the
version on local disk. If so, copy the version from source to the
directory `/etc/remctl/acl`, preserving timestamps. The destination
directory can be changed.

The source is either AFS (the default) or the HTTPS remctl ACL file
service (used when **--source** is set to "https").

This script only adds/updates files; no remctl files are _removed_.

If ACLs are given on the command line, those files are copied instead of the
default set.  This allows adding an additional cron job to copy other ACLs
that a given server cares about without copying the same ACLs twice.

If the **--all** option is given then all the ACL files are copied and not
just the ones specified at the beginning of this shell script.

If any ACLs cannot be found (e.g., they were provided with \[_acl_ ...\]
but misspelled) then the script will skip those that are missing and write
to standard output a warning. If you want the script to abort  before copying
if any ACL files are  missing use the **--abort-when-missing** option.

As a special case, this script also creates `its-idg`, `its-systems`,
and `systems-root` ACL files, generated by extracting only root instances
from the corresponding ACL files without the `-root` ending.

If there are admin instances in `/root/.k5login`, or if `/root/.k5login`
doesn't exist, this script removes the `operations` and `systems` ACLs
from the default set.  This is to prevent changing ACL files on systems
with more restricted access than normal.  It also declines to update the
`operations` and `systems` ACLs if the `systems` ACL contains lines of
the form `file:_path_`, since it then assumes that those ACLs are
pointed at the appropriate group-specific ACLs instead of using the
general ACL.

# ROOT ACL FILES

ACL files created by the upstream ACL builder service contain a list of
service and user principals. For every regular user principal in the file
there will also be a corresponding root principal (provided that the user
_has_ a root principal). For example, the **iedo** ACL file contains these principals

    adamhl@stanford.edu
    adamhl/root@stanford.edu
    aguzhavi@stanford.edu
    aguzhavi/root@stanford.edu
    alanxge@stanford.edu
    bnbarnes@stanford.edu
    bnbarnes/root@stanford.edu
    lonlone@stanford.edu
    lonlone/root@stanford.edu
    pjudd@stanford.edu
    spinto@stanford.edu
    spinto/root@stanford.edu

Depending on how this script is called an extra ACL files called "root" ACL
file based on the regular ACL file may be created. For the above example,
the root ACL file will be called **iedo-root** and will contain _only_ the
root principals:

    adamhl/root@stanford.edu
    aguzhavi/root@stanford.edu
    bnbarnes/root@stanford.edu
    lonlone/root@stanford.edu
    spinto/root@stanford.edu

The algorithm determining which ACL files get corresponding root ACL files
created is as follows: if no ACLs are provided on the command line then
the ACLs listed in the "special" variable get root ACL files; if ACLs
_are_ provided on the command line and the **--root-acls** option is
given, then the ACLS in the "special" variable _and_ the ACLs supplied
will all get a root ACL file; if ACLs _are_ provided on the command line
and the **--root-acls** option is _not_ given, then _no_ ACL files will
get a root ACL file.

If the above is confusing, run the script in verbose (**-v**) and dry-run
(**--dry-run**) mode and look at the messages to see which ACL files get
root ACL files and which do not.

# OPTIONS

- **--source**=afs|https

    Use the **--source** option to specify which source you want to use for the
    ACL file downloads: AFS or the HTTPS service. Both sources have the same
    files. The default is `afs`. Supplying any other value than "afs" or
    "https" will result in an error.

- **--dest-dir**=&lt;path>

    Normally this script will write the remctl ACL files to the directory
    **/etc/remctl/acl**. To override this use the **--dest-dir** option. For
    example, to write the remctl ACL files to `/tmp/acl` use
    "**--dest-dir**=`/tmp/acl`".  Note that if the destination directory does
    not already exist the script will exit with an error.

- **--all**

    Copy _all_ remctl ACL files. Do not use this option and also specify ACL
    files on the command line; doing so will result in an error.

- **--abort-when-missing**

    Normally this script skips any missing ACL files. If you supply
    **--abort-when-missing** then the script first checks that all the ACL
    files exists before copying; if any are missing it aborts without copying
    any files.

- **--dry-run|-n**

    Run in "dry-run" mode. This mode downloads the file to a temporary
    directory (just like normal mode) but does **not** write them to the
    destination directory. Use with the **--verbose** option when debugging.

- **--platform**=dev|prod

    Normally this program will download the remctl ACL files from the
    production remctl ACL file storage bucket. Howevever, if you want to
    download them from the _non-production_ bucket, use this option like so:
    **--platform=dev**. This option only recognizes two values: "prod" or "dev".
    See also the Examples below.

- **--baseurl**=&lt;url>

    The script normally infers the remctl ACL file service URL from the
    **--platform** option, but you can override this and specify the URL
    yourself by using the **--baseurl** option.

- **--root-acls**

    Summary: if providing ACLs on the command-line and you want ACL root files
    for those ACLs use **--root-acls**.

    Details: If this option is provided _and_ a list of ACLs is given on the
    command line, then both the non-root and root version of the ACL file is
    written to **dest-dir**. For example, the result of
    `remctl-acl-update-flex --root-acls tcg-staff` will be that both the
    `tcg-staff` and `tcg-staff-root` ACL files will be written to
    **dest-dir**. If no ACLs are provided on the command line this option has
    no effect, that is, if no ACLS are given then the default root and
    non-root files are written regardless of whether **--root-acls** is
    provided or not.

- **--verbose|-v**

    Run in verbose mode.

- **--help|-h**

    Show a help summary and exit.

- **--manual|-m**

    Show the man page and exit. Will only work if pod2man is installed.

# EXAMPLES

To update the default set of ACLs (using AFS as the source), just run:

    remctl-acl-update-flex

To update the default set of ACLs (using HTTPS as the source), run:

    remctl-acl-update-flex --source=https

To update a specific ACL (whether one of the defaults or not), do:

    remctl-acl-update-flex helpdesk-all

To update a specific ACL as well as its root ACL file:

    remctl-acl-update-flex --root-acls helpdesk-all

This will copy the helpdesk-all ACL file into `/etc/remctl/acl`.

To download from the non-production storage bucket:

    remctl-acl-update-flex --platform=dev

# FILES

- `/afs/ir.stanford.edu/pubsw/Local/config/share/etc/acl`

    The directory in pubsw that is checked for newer copies of the ACLs. If
    this directory doesn't exist, the script exits quietly without changing
    anything. The ACLs in this directory are expected to end in `.acl` but
    are copied over without that extension. Note that this directory is
    \*not\* used when the **--source** option is set to "https".

- `/etc/remctl/acl`

    The local directory where the ACL files are stored (unless overridden by
    the **--dest-dir** option).

# AUTHOR

Russ Allbery <rra@stanford.edu>

Updated by Adam H. Lewenberg <adamhl@stanford.edu>
