# QCMDB::Database -- a connection to the CMDB DB
#
# Written by Digant C Kasundra <digant@stanford.edu>
# Copyright 2009 Board of Trustees, Leland Stanford Jr. University
#
# See LICENSE for licensing terms.

#############################################################################
# Modules and declarations
#############################################################################

package QCMDB::Database;

use strict;
use vars qw($VERSION);

use QCMDB::Config;
use DBI;

$VERSION = '0.01';


##############################################################################
# Constructor, destructor, and accessors
##############################################################################

# Create a new config object that loads information from the config object
sub new {
    my ($class, $cfg) = @_;

    if (!$cfg) {
        return;
    }

    my $dsn = "DBI:mysql:database=$cfg->{dbname};host=$cfg->{dbhost};port=$cfg->{dbport}";
    my %attrs = (PrintError => 0, RaiseError => 1, AutoCommit => 0);
    my $dbh = DBI->connect($dsn, $cfg->{dbuser}, $cfg->{dbpw}, \%attrs);

    my $self = {
        dbh  => $dbh,
    };

    bless ($self, $class);
    return $self;
}

sub DESTROY {
    my ($self) = @_;
    $self->{dbh}->disconnect();
}
